/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.widget.swing;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ScaledImageIcon
extends ImageIcon {
    private static final long serialVersionUID = 2268678595787789821L;
    final double sx;
    final double sy;
    final int unscaledWidth;
    final int unscaledHeight;

    public static int scale(int n, double d2) {
        return (int)Math.ceil((double)n * d2);
    }

    public ScaledImageIcon(Image image, double d2) {
        this(image, d2, d2);
    }

    public ScaledImageIcon(Image image, double d2, double d3) {
        this.sx = d2;
        this.sy = d3;
        this.unscaledWidth = image.getWidth(null);
        this.unscaledHeight = image.getHeight(null);
        this.setImage(this.scaleImage(image, d2, d3));
    }

    public ScaledImageIcon(Icon icon, double d2) {
        this(icon, d2, d2);
    }

    public ScaledImageIcon(Icon icon, double d2, double d3) {
        this.sx = d2;
        this.sy = d3;
        this.unscaledWidth = icon.getIconWidth();
        this.unscaledHeight = icon.getIconHeight();
        this.setImage(this.scaleImage(icon, d2, d3));
        if (icon instanceof ImageIcon) {
            String string = ((ImageIcon)icon).getDescription();
            this.setDescription(string + " (sx=" + d2 + ",sy=" + d3 + ")");
        }
    }

    public double getScaleX() {
        return this.sx;
    }

    public double getScaleY() {
        return this.sy;
    }

    public int getUnscaledWidth() {
        return this.unscaledWidth;
    }

    public int getUnscaledHeight() {
        return this.unscaledHeight;
    }

    protected Image scaleImage(Icon icon, double d2, double d3) {
        if (this.isOptimal(d2) && this.isOptimal(d2)) {
            int n = ScaledImageIcon.scale(icon.getIconWidth(), d2);
            int n2 = ScaledImageIcon.scale(icon.getIconHeight(), d3);
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.scale(d2, d3);
            icon.paintIcon(null, graphics2D, 0, 0);
            graphics2D.dispose();
            return bufferedImage;
        }
        int n = icon.getIconWidth();
        int n3 = icon.getIconHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n3, 2);
        Graphics graphics = bufferedImage.getGraphics();
        icon.paintIcon(null, graphics, 0, 0);
        graphics.dispose();
        return this.scaleImage(bufferedImage, d2, d3);
    }

    protected Image scaleImage(Image image, double d2, double d3) {
        int n = ScaledImageIcon.scale(image.getWidth(null), d2);
        int n2 = ScaledImageIcon.scale(image.getHeight(null), d3);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Image image2 = image.getScaledInstance(n, n2, 4);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image2, 0, 0, null);
        graphics.dispose();
        image2.flush();
        return bufferedImage;
    }

    private boolean isOptimal(double d2) {
        return d2 > 0.0 && d2 == (double)((int)d2);
    }
}

