/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.widget.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.Timer;

public class RepeatJButton
extends JButton {
    private static final long serialVersionUID = 5854551546851355477L;
    private Timer timer;
    private boolean repeatable = true;
    private int initialDelay = 200;
    private int delay = 30;

    public RepeatJButton() {
        this(null, null);
    }

    public RepeatJButton(Icon icon) {
        this(null, icon);
    }

    public RepeatJButton(String string) {
        this(string, null);
    }

    public RepeatJButton(String string, Icon icon) {
        super(string, icon);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RepeatJButton.this.fireActionPerformed(actionEvent);
            }
        };
        this.timer = new Timer(this.delay, actionListener);
        this.timer.setInitialDelay(this.initialDelay);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (RepeatJButton.this.repeatable) {
                    RepeatJButton.this.timer.start();
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (RepeatJButton.this.timer.isRunning()) {
                    RepeatJButton.this.timer.stop();
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                ButtonModel buttonModel = RepeatJButton.this.getModel();
                if (!RepeatJButton.this.isEnabled() && buttonModel.isPressed()) {
                    RepeatJButton.this.setEnabled(true);
                    buttonModel.setPressed(false);
                    RepeatJButton.this.setEnabled(false);
                    buttonModel.setPressed(true);
                }
                if (RepeatJButton.this.timer.isRunning()) {
                    RepeatJButton.this.timer.stop();
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                ButtonModel buttonModel;
                if (RepeatJButton.this.repeatable && (buttonModel = RepeatJButton.this.getModel()).isPressed() && !RepeatJButton.this.timer.isRunning()) {
                    int n = RepeatJButton.this.timer.getInitialDelay();
                    RepeatJButton.this.timer.setInitialDelay(0);
                    RepeatJButton.this.timer.start();
                    RepeatJButton.this.timer.setInitialDelay(n);
                }
            }
        };
        this.addMouseListener(mouseAdapter);
    }

    @Override
    protected void fireActionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            this.timer.stop();
            ButtonModel buttonModel = this.getModel();
            this.setEnabled(true);
            buttonModel.setPressed(false);
            this.setEnabled(false);
            buttonModel.setPressed(true);
            return;
        }
        super.fireActionPerformed(actionEvent);
    }

    public void setDelay(int n) {
        this.delay = n;
        this.timer.setDelay(n);
    }

    public int getDelay() {
        return this.delay;
    }

    public void setInitialDelay(int n) {
        this.timer.setInitialDelay(n);
    }

    public int getInitialDelay() {
        return this.timer.getInitialDelay();
    }

    public void setRepeatable(boolean bl) {
        this.repeatable = bl;
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }
}

