/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.widget.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.Serializable;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import net.astah.golf.widget.swing.IColorProvider;
import net.astah.golf.widget.swing.IFontProvider;
import net.astah.golf.widget.swing.ITableColorProvider;
import net.astah.golf.widget.swing.ITableFontProvider;
import net.astah.golf.widget.swing.ITableLabelProvider;
import org.eclipse.emf.edit.provider.IDisposable;

public class LabelProviderTreeTableCellRenderer
extends DefaultTreeCellRenderer
implements IDisposable {
    private static final long serialVersionUID = 1L;
    protected final ITableLabelProvider labelProvider;

    public LabelProviderTreeTableCellRenderer(ITableLabelProvider iTableLabelProvider) {
        Objects.requireNonNull(iTableLabelProvider, "labelProvider");
        this.labelProvider = iTableLabelProvider;
    }

    public void dispose() {
        this.labelProvider.dispose();
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Serializable serializable;
        Object object2;
        Icon icon;
        int n2 = this.getColumn(jTree);
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        this.setFont(jTree.getFont());
        String string = this.labelProvider.getColumnText(object, n2);
        if (string != null) {
            this.setText(string);
        }
        if ((icon = this.labelProvider.getColumnImage(object, n2)) != null) {
            this.applyImage(jTree, icon);
        }
        if (!bl && !bl4 && this.labelProvider instanceof ITableColorProvider) {
            Color color;
            if (this.labelProvider instanceof IColorProvider.Relative) {
                object2 = (IColorProvider.Relative)((Object)this.labelProvider);
                serializable = this.getForeground();
                if (serializable != null) {
                    object2.setCurrentForeground((Color)serializable);
                }
                if ((color = this.getBackgroundNonSelectionColor()) != null) {
                    object2.setCurrentBackground(color);
                }
            }
            if ((serializable = (object2 = (ITableColorProvider)((Object)this.labelProvider)).getForeground(object, n2)) != null) {
                this.setForeground((Color)serializable);
            }
            if ((color = object2.getBackground(object, n2)) != null) {
                this.setBackground(color);
            }
        }
        if (this.labelProvider instanceof ITableFontProvider) {
            if (this.labelProvider instanceof IFontProvider.Relative) {
                object2 = (IFontProvider.Relative)((Object)this.labelProvider);
                serializable = this.getFont();
                if (serializable != null) {
                    object2.setCurrentFont((Font)serializable);
                }
            }
            if ((serializable = (object2 = (ITableFontProvider)((Object)this.labelProvider)).getFont(object, n2)) != null) {
                this.setFont((Font)serializable);
            }
        }
        return this;
    }

    protected int getColumn(JTree jTree) {
        return 0;
    }

    protected void applyImage(JTree jTree, Icon icon) {
        if (icon != null) {
            if (jTree.isEnabled()) {
                this.setEnabled(true);
                this.setIcon(icon);
            } else {
                this.setEnabled(false);
                LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
                Icon icon2 = lookAndFeel.getDisabledIcon(jTree, icon);
                this.setDisabledIcon(icon2 != null ? icon2 : icon);
            }
        }
    }
}

