/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.widget.swing;

import com.google.common.base.Strings;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.io.Serializable;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import net.astah.golf.widget.swing.IColorProvider;
import net.astah.golf.widget.swing.IExtraLabelProvider;
import net.astah.golf.widget.swing.IFontProvider;
import net.astah.golf.widget.swing.ILabelProvider;
import org.eclipse.emf.edit.provider.IDisposable;

public class LabelProviderTreeCellRenderer
extends DefaultTreeCellRenderer
implements IDisposable {
    private static final long serialVersionUID = 1L;
    protected final ILabelProvider labelProvider;
    protected JPanel panel;
    protected JLabel extraImage;

    public LabelProviderTreeCellRenderer(ILabelProvider iLabelProvider) {
        Objects.requireNonNull(iLabelProvider, "labelProvider");
        this.labelProvider = iLabelProvider;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setOpaque(false);
        this.extraImage = new JLabel();
        this.extraImage.setOpaque(false);
        this.extraImage.setForeground(Color.GRAY);
        FlowLayout flowLayout = new FlowLayout(0, 0, 0);
        this.panel = new JPanel(flowLayout);
        this.panel.setOpaque(false);
        this.panel.setFont(this.isFontSet() ? this.getFont() : null);
        this.panel.setForeground(this.isForegroundSet() ? this.getForeground() : null);
        this.panel.setBackground(this.isBackgroundSet() ? this.getBackground() : null);
        this.panel.add(this);
        this.panel.add(this.extraImage);
    }

    public Icon getExtraImage() {
        return this.extraImage.getIcon();
    }

    public void setExtraImage(Icon icon) {
        Icon icon2 = this.extraImage.getIcon();
        this.extraImage.setIcon(icon);
        if (icon2 != icon) {
            this.firePropertyChange("extraImage", icon2, icon);
        }
    }

    public void dispose() {
        this.labelProvider.dispose();
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Serializable serializable;
        Object object2;
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        this.setFont(jTree.getFont());
        this.setText(Strings.nullToEmpty((String)this.labelProvider.getText(object)));
        this.applyImage(jTree, this.labelProvider.getImage(object));
        if (this.labelProvider instanceof IExtraLabelProvider) {
            object2 = (IExtraLabelProvider)this.labelProvider;
            this.setExtraImage(object2.getExtraImage(object));
        }
        if (this.labelProvider instanceof IColorProvider) {
            Color color;
            if (this.labelProvider instanceof IColorProvider.Relative) {
                object2 = (IColorProvider.Relative)((Object)this.labelProvider);
                serializable = this.getForeground();
                if (serializable != null) {
                    object2.setCurrentForeground((Color)serializable);
                }
                if ((color = this.getBackgroundNonSelectionColor()) != null) {
                    object2.setCurrentBackground(color);
                }
            }
            if ((serializable = (object2 = (IColorProvider)((Object)this.labelProvider)).getForeground(object)) != null) {
                this.setForeground((Color)serializable);
            }
            if ((color = object2.getBackground(object)) != null) {
                this.setBackgroundNonSelectionColor(color);
            }
        }
        if (this.labelProvider instanceof IFontProvider) {
            if (this.labelProvider instanceof IFontProvider.Relative) {
                object2 = (IFontProvider.Relative)((Object)this.labelProvider);
                serializable = this.getFont();
                if (serializable != null) {
                    object2.setCurrentFont((Font)serializable);
                }
            }
            if ((serializable = (object2 = (IFontProvider)((Object)this.labelProvider)).getFont(object)) != null) {
                this.setFont((Font)serializable);
            }
        }
        this.panel.setForeground(this.getForeground());
        this.panel.setBackground(this.getBackgroundNonSelectionColor());
        this.panel.doLayout();
        return this.panel;
    }

    protected void applyImage(JTree jTree, Icon icon) {
        if (icon != null) {
            if (jTree.isEnabled()) {
                this.setEnabled(true);
                this.setIcon(icon);
            } else {
                this.setEnabled(false);
                LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
                Icon icon2 = lookAndFeel.getDisabledIcon(jTree, icon);
                this.setDisabledIcon(icon2 != null ? icon2 : icon);
            }
        } else {
            this.setIcon(null);
            this.setDisabledIcon(null);
        }
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
        if ("font".equals(string)) {
            if (this.panel != null) {
                this.panel.setFont((Font)object2);
            }
        } else if ("foreground".equals(string)) {
            if (this.panel != null) {
                this.panel.setForeground((Color)object2);
            }
        } else if ("background".equals(string) && this.panel != null) {
            this.panel.setBackground((Color)object2);
        }
        super.firePropertyChange(string, object, object2);
    }
}

