/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.widget.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import net.astah.golf.view.swing.LineWrappingTableCellRenderer;
import net.astah.golf.widget.IBaseLabelProvider;
import net.astah.golf.widget.swing.IColorProvider;
import net.astah.golf.widget.swing.IFontProvider;
import net.astah.golf.widget.swing.ILabelProvider;
import net.astah.golf.widget.swing.ITableColorProvider;
import net.astah.golf.widget.swing.ITableFontProvider;
import net.astah.golf.widget.swing.ITableLabelProvider;
import org.eclipse.emf.edit.provider.IDisposable;

public class LabelProviderTableCellRenderer
extends LineWrappingTableCellRenderer
implements IDisposable {
    private static final long serialVersionUID = 1L;
    protected final IBaseLabelProvider labelProvider;

    public LabelProviderTableCellRenderer(ITableLabelProvider iTableLabelProvider) {
        Objects.requireNonNull(iTableLabelProvider, "labelProvider");
        this.labelProvider = iTableLabelProvider;
    }

    public LabelProviderTableCellRenderer(ILabelProvider iLabelProvider) {
        Objects.requireNonNull(iLabelProvider, "labelProvider");
        this.labelProvider = iLabelProvider;
    }

    public void dispose() {
        this.labelProvider.dispose();
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Object object2;
        Object object3;
        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (this.labelProvider instanceof ITableLabelProvider) {
            object3 = (ITableLabelProvider)this.labelProvider;
            this.setValue(object3.getColumnText(object, n2));
            this.applyImage(jTable, object3.getColumnImage(object, n2));
        } else if (this.labelProvider instanceof ILabelProvider) {
            object3 = (ILabelProvider)this.labelProvider;
            this.setValue(object3.getText(object));
            this.applyImage(jTable, object3.getImage(object));
        }
        if (!bl && !bl2) {
            Object object4;
            if (this.labelProvider instanceof IColorProvider.Relative) {
                object3 = (IColorProvider.Relative)((Object)this.labelProvider);
                object2 = this.getForeground();
                if (object2 != null) {
                    object3.setCurrentForeground((Color)object2);
                }
                if ((object4 = this.getBackground()) != null) {
                    object3.setCurrentBackground((Color)object4);
                }
            }
            object3 = null;
            object2 = null;
            if (this.labelProvider instanceof ITableColorProvider) {
                object4 = (ITableColorProvider)((Object)this.labelProvider);
                object3 = object4.getForeground(object, n2);
                object2 = object4.getBackground(object, n2);
            } else if (this.labelProvider instanceof IColorProvider) {
                object4 = (IColorProvider)((Object)this.labelProvider);
                object3 = object4.getForeground(object);
                object2 = object4.getBackground(object);
            }
            if (object3 != null) {
                this.setForeground((Color)object3);
            }
            if (object2 != null) {
                this.setBackground((Color)object2);
            }
        }
        if (this.labelProvider instanceof IFontProvider.Relative) {
            object3 = (IFontProvider.Relative)((Object)this.labelProvider);
            object2 = this.getFont();
            if (object2 != null) {
                object3.setCurrentFont((Font)object2);
            }
        }
        object3 = null;
        if (this.labelProvider instanceof ITableFontProvider) {
            object2 = (ITableFontProvider)((Object)this.labelProvider);
            object3 = object2.getFont(object, n2);
        } else if (this.labelProvider instanceof IFontProvider) {
            object2 = (IFontProvider)((Object)this.labelProvider);
            object3 = object2.getFont(object);
        }
        if (object3 != null) {
            this.setFont((Font)object3);
        }
        return component;
    }

    protected void applyImage(JTable jTable, Icon icon) {
        if (icon != null) {
            if (jTable.isEnabled()) {
                this.setEnabled(true);
                this.setIcon(icon);
            } else {
                this.setEnabled(false);
                LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
                Icon icon2 = lookAndFeel.getDisabledIcon(jTable, icon);
                this.setDisabledIcon(icon2 != null ? icon2 : icon);
            }
        } else {
            this.setIcon(null);
            this.setDisabledIcon(null);
        }
    }

    @Override
    protected void setValue(Object object) {
        String string = Objects.toString(object, "");
        if (this.isLineWrap()) {
            this.label.setText(string, false);
        } else {
            this.setText(string);
        }
    }
}

