/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.widget.swing;

import java.awt.Component;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import net.astah.golf.widget.swing.AdjustedRowHeightTable;
import net.astah.jomt.jutil.ExecutorManager;

public class GenericTable
extends AdjustedRowHeightTable {
    private static final long serialVersionUID = 6144215686411496177L;
    private final Map<Integer, ScheduledFuture<?>> updateRowHeightTasks = new HashMap();
    private static final long scheduleTime = 300L;

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        if (this.isAutoAdjustRowHeight() && tableModelEvent.getType() != -1) {
            int n = Math.max(tableModelEvent.getFirstRow(), 0);
            int n2 = Math.min(tableModelEvent.getLastRow(), this.getRowCount() - 1);
            for (int k = n; k <= n2; ++k) {
                this.addUpdateRowHeightTask(k);
            }
        }
    }

    @Override
    public boolean editCellAt(final int n, int n2, EventObject eventObject) {
        boolean bl = super.editCellAt(n, n2, eventObject);
        if (bl && this.isAutoAdjustRowHeight()) {
            for (Map.Entry<Integer, ScheduledFuture<?>> entry : this.updateRowHeightTasks.entrySet()) {
                entry.getValue().cancel(false);
                this.updateRowHeight(entry.getKey());
            }
            this.updateRowHeightTasks.clear();
            this.updateRowHeight(n);
            final TableCellEditor tableCellEditor = this.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.addCellEditorListener(new CellEditorListener(){

                    @Override
                    public void editingStopped(ChangeEvent changeEvent) {
                        tableCellEditor.removeCellEditorListener(this);
                        if (n >= 0 && n < GenericTable.this.getRowCount()) {
                            GenericTable.this.addUpdateRowHeightTask(n);
                        }
                    }

                    @Override
                    public void editingCanceled(ChangeEvent changeEvent) {
                        tableCellEditor.removeCellEditorListener(this);
                        if (n >= 0 && n < GenericTable.this.getRowCount()) {
                            GenericTable.this.addUpdateRowHeightTask(n);
                        }
                    }
                });
            }
        }
        return bl;
    }

    @Override
    protected double getPreferredCellHeight(int n, int n2) {
        if (this.getEditingRow() != n) {
            return super.getPreferredCellHeight(n, n2);
        }
        JPanel jPanel = new JPanel();
        jPanel.setFont(this.getFont());
        double d2 = 0.0;
        if (this.getEditingColumn() == n2) {
            Component component = this.getEditorComponent();
            if (component == null) {
                return d2;
            }
            d2 = component.getPreferredSize().getHeight();
        } else {
            d2 = super.getPreferredCellHeight(n, n2);
        }
        return d2;
    }

    private void addUpdateRowHeightTask(final int n) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(() -> {
                    GenericTable.this.updateRowHeight(n);
                    GenericTable.this.updateRowHeightTasks.remove(n);
                });
            }
        };
        if (!this.updateRowHeightTasks.containsKey(n)) {
            this.updateRowHeightTasks.put(n, ExecutorManager.getScheduledExecutor().schedule(runnable, 300L, TimeUnit.MILLISECONDS));
        }
    }
}

