/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.widget.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.MenuElement;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.astah.golf.control.GolfAction;
import net.astah.golf.draw.UnderLineIcon;
import net.astah.golf.util.GolfUtilities;
import net.astah.golf.widget.CMenuElement;
import net.astah.golf.widget.CPopupMenu;
import net.astah.golf.widget.swing.ArrowDownIcon;
import net.astah.golf.widget.swing.SwingMenuElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropDownJButton
extends JButton
implements ActionListener,
PropertyChangeListener,
ChangeListener,
PopupMenuListener {
    private static final long serialVersionUID = 4667948396687328662L;
    private JButton mainButton = this;
    private JButton arrowButton = new JButton();
    private boolean popupVisible = false;
    private String key;
    private boolean enableChangeTip = false;
    private boolean pressArrowButton;
    private Supplier<CPopupMenu> popup;
    private static final Logger logger = LoggerFactory.getLogger(DropDownJButton.class);

    public DropDownJButton() {
        this(null, null);
    }

    public DropDownJButton(Icon icon) {
        this(null, icon);
    }

    public DropDownJButton(String string) {
        this(string, null);
    }

    public DropDownJButton(String string, Icon icon) {
        this.mainButton.setText(string);
        this.mainButton.setIcon(icon);
        this.mainButton.getModel().addChangeListener(this);
        this.mainButton.setFocusable(false);
        Dimension dimension = new Dimension((int)Math.ceil(this.getPreferredSize().getWidth() / 5.0), this.getPreferredSize().height);
        this.arrowButton.setIcon(new ArrowDownIcon(dimension.width, dimension.height));
        this.arrowButton.setName("arrow");
        this.arrowButton.getModel().addChangeListener(this);
        this.arrowButton.addActionListener(this);
        this.arrowButton.setMaximumSize(dimension);
        this.arrowButton.setMinimumSize(dimension);
        this.arrowButton.setMargin(new Insets(3, 0, 3, 0));
        this.arrowButton.setFocusable(false);
        this.mainButton.addPropertyChangeListener("enabled", this);
    }

    public JButton getArrowButton() {
        return this.arrowButton;
    }

    public boolean isEnableChangeTip() {
        return this.enableChangeTip;
    }

    public void setEnableChangeTip(boolean bl) {
        this.enableChangeTip = bl;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.arrowButton.setEnabled(this.mainButton.isEnabled());
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.mainButton.getModel()) {
            this.pressArrowButton = false;
            if (this.popupVisible && !this.mainButton.getModel().isRollover()) {
                this.mainButton.getModel().setRollover(true);
            } else {
                this.arrowButton.getModel().setRollover(this.mainButton.getModel().isRollover());
                this.arrowButton.getModel().setArmed(this.mainButton.getModel().isArmed());
                this.arrowButton.getModel().setPressed(this.mainButton.getModel().isPressed());
            }
        } else {
            this.pressArrowButton = true;
            if (this.popupVisible && !this.arrowButton.getModel().isSelected()) {
                this.arrowButton.getModel().setSelected(true);
            } else {
                this.mainButton.getModel().setRollover(this.arrowButton.getModel().isRollover());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.arrowButton) {
            CPopupMenu cPopupMenu;
            if (this.pressArrowButton && (cPopupMenu = this.getPopup()) != null) {
                cPopupMenu.addPopupMenuListener(this);
                cPopupMenu.addActionListenerForAllItems(this);
                cPopupMenu.show(this.mainButton, 0, this.mainButton.getHeight());
            }
        } else if (actionEvent.getSource() instanceof AbstractButton) {
            this.getPopup().setVisible(false);
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.setCurrentMainButton(abstractButton);
        }
    }

    private void setCurrentMainButton(AbstractButton abstractButton) {
        String string = abstractButton.getActionCommand();
        if (string.startsWith("*c")) {
            if (string.indexOf("Color%") != -1 || string.indexOf("AddMMIcon%") != -1) {
                String string2 = string.substring(string.indexOf("%") + 1);
                this.setCurrentIcon(string2, abstractButton);
                this.setCurrentActionCommand(string.substring(2));
            } else {
                this.changeCurrentIcon(abstractButton);
                this.setCurrentAction(this.getAction(abstractButton));
                this.setName(abstractButton.getName());
            }
            this.setMainButtonTooltip(abstractButton);
        }
    }

    public void setCurrentButton(String string) {
        AbstractButton abstractButton = this.getButtonItemFromActionName(string);
        if (abstractButton != null) {
            this.changeCurrentIcon(abstractButton);
            this.setCurrentAction(this.getAction(abstractButton));
            this.setMainButtonTooltip(abstractButton);
        }
    }

    private AbstractButton getButtonItemFromActionName(String string) {
        AbstractButton[] abstractButtonArray;
        if (string == null) {
            return null;
        }
        for (AbstractButton abstractButton : abstractButtonArray = this.getAllButtons()) {
            GolfAction golfAction = this.getAction(abstractButton);
            logger.debug("sItem={}", (Object)abstractButton.getActionCommand());
            logger.debug("aItem={}", (Object)golfAction.getActionName());
            if (!string.equals(golfAction.getActionName())) continue;
            return abstractButton;
        }
        return null;
    }

    public AbstractButton[] getAllButtons() {
        CMenuElement[] cMenuElementArray;
        ArrayList arrayList = new ArrayList();
        CPopupMenu cPopupMenu = this.getPopup();
        if (cPopupMenu == null) {
            return arrayList.toArray(new AbstractButton[0]);
        }
        for (CMenuElement cMenuElement : cMenuElementArray = cPopupMenu.getSubElements()) {
            SwingMenuElement swingMenuElement;
            MenuElement menuElement;
            if (!(cMenuElement instanceof SwingMenuElement) || !((menuElement = (swingMenuElement = (SwingMenuElement)SwingMenuElement.class.cast(cMenuElement)).getComponent()) instanceof JMenuItem)) continue;
            arrayList.add(JMenuItem.class.cast(menuElement));
        }
        return arrayList.toArray(new AbstractButton[0]);
    }

    private void setMainButtonTooltip(AbstractButton abstractButton) {
        String string = abstractButton.getToolTipText();
        if (this.enableChangeTip) {
            this.setToolTipText(string);
        }
    }

    public void setCurrentIcon(String string, AbstractButton abstractButton) {
        int n = string.indexOf("|");
        Color color = null;
        color = n != -1 ? GolfUtilities.createColor(string.substring(n + 1)) : GolfUtilities.createColor(string);
        if (color != null && this.mainButton.getIcon() instanceof UnderLineIcon) {
            UnderLineIcon underLineIcon;
            ((UnderLineIcon)this.mainButton.getIcon()).setColor(color);
            UnderLineIcon underLineIcon2 = (UnderLineIcon)this.mainButton.getDisabledIcon();
            if (underLineIcon2 != null) {
                underLineIcon2.setColor(Color.LIGHT_GRAY);
                this.mainButton.setDisabledIcon(underLineIcon2);
            }
            if ((underLineIcon = (UnderLineIcon)this.mainButton.getRolloverIcon()) != null) {
                underLineIcon.setColor(color);
                this.mainButton.setRolloverIcon(underLineIcon);
            }
            this.mainButton.updateUI();
        } else {
            this.changeCurrentIcon(abstractButton);
        }
    }

    private void changeCurrentIcon(AbstractButton abstractButton) {
        this.mainButton.setIcon(abstractButton.getIcon());
        this.mainButton.setDisabledIcon(abstractButton.getDisabledIcon());
        this.mainButton.setRolloverIcon(abstractButton.getRolloverIcon());
        this.mainButton.updateUI();
    }

    public void setCurrentActionCommand(String string) {
        for (int k = 0; k < this.mainButton.getActionListeners().length; ++k) {
            if (!(this.mainButton.getActionListeners()[k] instanceof GolfAction)) continue;
            GolfAction golfAction = (GolfAction)this.mainButton.getActionListeners()[k];
            golfAction.setActionCommand(string);
            break;
        }
    }

    public void setCurrentAction(GolfAction golfAction) {
        ActionListener[] actionListenerArray = this.mainButton.getActionListeners();
        for (int k = 0; k < actionListenerArray.length; ++k) {
            this.mainButton.removeActionListener(actionListenerArray[k]);
        }
        this.mainButton.addActionListener(golfAction);
    }

    private GolfAction getAction(AbstractButton abstractButton) {
        for (int k = 0; k < abstractButton.getActionListeners().length; ++k) {
            if (!(abstractButton.getActionListeners()[k] instanceof GolfAction)) continue;
            return (GolfAction)abstractButton.getActionListeners()[k];
        }
        return null;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        this.popupVisible = true;
        this.mainButton.getModel().setRollover(true);
        this.arrowButton.getModel().setSelected(true);
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.popupVisible = false;
        this.mainButton.getModel().setRollover(false);
        this.arrowButton.getModel().setSelected(false);
        ((JPopupMenu)popupMenuEvent.getSource()).removePopupMenuListener(this);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        this.popupVisible = false;
    }

    public JButton addToToolBar(JToolBar jToolBar) {
        JToolBar jToolBar2 = new JToolBar();
        jToolBar2.setAlignmentX(0.0f);
        Dimension dimension = this.getOtherButtonSize(jToolBar);
        if (dimension != null) {
            this.mainButton.setPreferredSize(dimension);
            int n = (int)Math.ceil((double)dimension.width / 2.5);
            int n2 = dimension.height;
            ArrowDownIcon arrowDownIcon = new ArrowDownIcon(n, n2);
            this.arrowButton.setIcon(arrowDownIcon);
            Dimension dimension2 = new Dimension(n, n2);
            this.arrowButton.setPreferredSize(dimension2);
            this.arrowButton.setMaximumSize(dimension2);
            this.arrowButton.setMinimumSize(dimension2);
        }
        jToolBar2.add(this.mainButton);
        jToolBar2.add(this.arrowButton);
        jToolBar2.setFloatable(false);
        jToolBar2.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        jToolBar.add(jToolBar2);
        return this.mainButton;
    }

    private Dimension getOtherButtonSize(JToolBar jToolBar) {
        Component[] componentArray;
        for (Component component : componentArray = jToolBar.getComponents()) {
            if (component instanceof DropDownJButton) continue;
            Dimension dimension = component.getPreferredSize();
            dimension.width = dimension.height;
            if (!(component instanceof JButton) && !(component instanceof JToggleButton)) continue;
            return dimension;
        }
        return null;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.arrowButton.setToolTipText(string);
    }

    public CPopupMenu getPopup() {
        return this.popup.get();
    }

    public void setPopupSupplier(Supplier<CPopupMenu> supplier) {
        this.popup = supplier;
    }
}

