/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.widget.swing;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.Component;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.OverlayLayout;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import lombok.NonNull;
import org.eclipse.emf.edit.provider.IDisposable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DragAndDropTreeCellRenderer
implements TreeCellRenderer,
IDisposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DragAndDropTreeCellRenderer.class);
    protected final JTree tree;
    @NonNull
    protected final JPanel panel;
    protected final JPanel effect;
    protected int borderWidth = 2;
    protected TreeCellRenderer renderer;
    protected Object target;
    private int feedback;

    public DragAndDropTreeCellRenderer(JTree jTree) {
        Objects.requireNonNull(jTree, "tree");
        this.tree = jTree;
        this.panel = new JPanel();
        this.panel.setOpaque(false);
        this.panel.setLayout(new OverlayLayout(this.panel));
        this.effect = new JPanel();
        this.activate();
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Preconditions.checkState((this.renderer != null ? 1 : 0) != 0, (Object)"disposed");
        Component component = this.renderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        this.updateEffect(object);
        if (!this.panel.isAncestorOf(component)) {
            this.panel.removeAll();
            this.panel.add(this.effect);
            this.panel.add(component);
            jTree.setRowHeight(0);
        }
        this.panel.repaint();
        return this.panel;
    }

    public void update(Object object, int n) {
        Object object2 = this.target;
        int n2 = this.feedback;
        this.target = object;
        this.feedback = n;
        if (object2 != object || n2 != n) {
            this.tree.repaint();
        }
        LOGGER.debug("update({}, {})", object, (Object)n);
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int n) {
        this.borderWidth = n;
        this.tree.repaint();
    }

    public void dispose() {
        if (this.renderer != null) {
            TreeCellRenderer treeCellRenderer = this.renderer;
            this.renderer = null;
            this.target = null;
            this.feedback = 0;
            this.panel.removeAll();
            if (treeCellRenderer instanceof IDisposable) {
                ((IDisposable)treeCellRenderer).dispose();
            }
            LOGGER.debug("disposed");
        }
    }

    protected void activate() {
        TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
        Objects.requireNonNull(treeCellRenderer, "renderer");
        this.renderer = treeCellRenderer;
        this.tree.setCellRenderer(this);
    }

    protected void updateEffect(Object object) {
        if (Objects.equals(object, this.target)) {
            Color color = this.getBorderColor();
            switch (this.feedback) {
                case 1: {
                    this.applySelectEffect(color);
                    break;
                }
                case 2: {
                    this.applyInsertBeforeEffect(color);
                    break;
                }
                case 4: {
                    this.applyInsertAfterEffect(color);
                }
            }
        } else {
            this.applyNoneEffect();
        }
    }

    protected void applyNoneEffect() {
        this.effect.setOpaque(false);
        this.effect.setBorder(null);
    }

    protected void applySelectEffect(Color color) {
        this.effect.setOpaque(true);
        this.effect.setBackground(DragAndDropTreeCellRenderer.setAlpha(color, 32));
        this.effect.setBorder(new LineBorder(color, this.borderWidth, true));
    }

    protected void applyInsertAfterEffect(Color color) {
        this.effect.setOpaque(true);
        this.effect.setBackground(DragAndDropTreeCellRenderer.setAlpha(color, 32));
        this.effect.setBorder(BorderFactory.createMatteBorder(0, 0, this.borderWidth, 0, color));
    }

    protected void applyInsertBeforeEffect(Color color) {
        this.effect.setOpaque(true);
        this.effect.setBackground(DragAndDropTreeCellRenderer.setAlpha(color, 32));
        this.effect.setBorder(BorderFactory.createMatteBorder(this.borderWidth, 0, 0, 0, color));
    }

    protected Color getBorderColor() {
        if (this.renderer instanceof DefaultTreeCellRenderer) {
            return ((DefaultTreeCellRenderer)this.renderer).getBackgroundSelectionColor();
        }
        return new Color(255, 0, 0);
    }

    static Color setAlpha(Color color, int n) {
        return new Color(color.getRGB() & 0xFFFFFF | n << 24, true);
    }
}

