/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.widget.swing;

import java.awt.Color;
import java.awt.Font;
import java.util.Objects;
import javax.swing.Icon;
import net.astah.golf.widget.BaseLabelProvider;
import net.astah.golf.widget.ILabelProviderListener;
import net.astah.golf.widget.LabelProviderChangedEvent;
import net.astah.golf.widget.swing.IColorProvider;
import net.astah.golf.widget.swing.IFontProvider;
import net.astah.golf.widget.swing.ILabelDecorator;
import net.astah.golf.widget.swing.ILabelProvider;
import org.eclipse.emf.edit.provider.IDisposable;

public class DecoratingLabelProvider
extends BaseLabelProvider
implements IColorProvider.Relative,
IFontProvider.Relative,
ILabelProvider,
IDisposable {
    private final ILabelProvider provider;
    private ILabelDecorator decorator;

    public DecoratingLabelProvider(ILabelProvider iLabelProvider, ILabelDecorator iLabelDecorator) {
        Objects.requireNonNull(iLabelProvider, "provider");
        this.provider = iLabelProvider;
        this.decorator = iLabelDecorator;
    }

    @Override
    public void dispose() {
        this.provider.dispose();
        if (this.decorator != null) {
            this.decorator.dispose();
        }
    }

    @Override
    public Icon getImage(Object object) {
        Icon icon;
        Icon icon2 = this.provider.getImage(object);
        if (this.decorator != null && (icon = this.decorator.decorateImage(icon2, object)) != null) {
            return icon;
        }
        return icon2;
    }

    public ILabelDecorator getLabelDecorator() {
        return this.decorator;
    }

    public ILabelProvider getLabelProvider() {
        return this.provider;
    }

    @Override
    public String getText(Object object) {
        String string;
        String string2 = this.provider.getText(object);
        if (this.decorator != null && (string = this.decorator.decorateText(string2, object)) != null) {
            return string;
        }
        return string2;
    }

    @Override
    public boolean isLabelProperty(Object object, String string) {
        if (this.provider.isLabelProperty(object, string)) {
            return true;
        }
        return this.decorator != null && this.decorator.isLabelProperty(object, string);
    }

    public void setLabelDecorator(ILabelDecorator iLabelDecorator) {
        ILabelDecorator iLabelDecorator2 = this.decorator;
        if (iLabelDecorator2 != iLabelDecorator) {
            if (iLabelDecorator2 != null) {
                for (ILabelProviderListener iLabelProviderListener : this.listeners) {
                    iLabelDecorator2.removeListener(iLabelProviderListener);
                }
            }
            this.decorator = iLabelDecorator;
            if (iLabelDecorator != null) {
                for (ILabelProviderListener iLabelProviderListener : this.listeners) {
                    iLabelDecorator.addListener(iLabelProviderListener);
                }
            }
            this.fireLabelProviderChanged(new LabelProviderChangedEvent(this));
        }
    }

    @Override
    public Color getForeground(Object object) {
        if (this.provider instanceof IColorProvider) {
            return ((IColorProvider)((Object)this.provider)).getForeground(object);
        }
        return null;
    }

    @Override
    public Color getBackground(Object object) {
        if (this.provider instanceof IColorProvider) {
            return ((IColorProvider)((Object)this.provider)).getBackground(object);
        }
        return null;
    }

    @Override
    public void setCurrentForeground(Color color) {
        if (this.provider instanceof IColorProvider.Relative) {
            ((IColorProvider.Relative)((Object)this.provider)).setCurrentForeground(color);
        }
    }

    @Override
    public void setCurrentBackground(Color color) {
        if (this.provider instanceof IColorProvider.Relative) {
            ((IColorProvider.Relative)((Object)this.provider)).setCurrentBackground(color);
        }
    }

    @Override
    public Font getFont(Object object) {
        if (this.provider instanceof IFontProvider) {
            return ((IFontProvider)((Object)this.provider)).getFont(object);
        }
        return null;
    }

    @Override
    public void setCurrentFont(Font font) {
        if (this.provider instanceof IFontProvider.Relative) {
            ((IFontProvider.Relative)((Object)this.provider)).setCurrentFont(font);
        }
    }
}

