/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.widget.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;

class ArrowDownIcon
implements Icon {
    private int[] xPoints = new int[3];
    private int[] yPoints = new int[3];
    int width = 0;
    int height = 0;

    public ArrowDownIcon(int n, int n2) {
        this.width = n;
        this.height = n2;
        int n3 = (int)Math.floor((double)n * 0.6);
        this.xPoints[0] = (n - n3) / 2;
        this.yPoints[0] = (n2 - n3) / 2;
        this.xPoints[1] = this.xPoints[0] + n3;
        this.yPoints[1] = this.yPoints[0];
        this.xPoints[2] = n / 2;
        this.yPoints[2] = (n2 + n3) / 2;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        ((Graphics2D)Graphics2D.class.cast(graphics)).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (component.isEnabled()) {
            graphics.setColor(component.getForeground());
        } else {
            graphics.setColor(Color.gray);
        }
        graphics.translate(n, n2);
        graphics.fillPolygon(this.xPoints, this.yPoints, this.xPoints.length);
        graphics.translate(-n, -n2);
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }
}

