/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.widget.swing;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class AdjustedRowHeightTable
extends JTable {
    private static final long serialVersionUID = 6144215686411496177L;
    private boolean isAutoAdjustRowHeight = true;
    private TableColumn resizingColumn = null;

    public AdjustedRowHeightTable() {
        this.initialize();
    }

    public AdjustedRowHeightTable(TableModel tableModel) {
        super(tableModel);
        this.initialize();
    }

    public AdjustedRowHeightTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel, null);
        this.initialize();
    }

    public AdjustedRowHeightTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.initialize();
    }

    public AdjustedRowHeightTable(int n, int n2) {
        super(n, n2);
        this.initialize();
    }

    public AdjustedRowHeightTable(Vector vector, Vector vector2) {
        super(vector, vector2);
        this.initialize();
    }

    public AdjustedRowHeightTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.initialize();
    }

    public boolean isAutoAdjustRowHeight() {
        return this.isAutoAdjustRowHeight;
    }

    public void setAutoAdjustRowHeight(boolean bl) {
        this.isAutoAdjustRowHeight = bl;
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
        if (this.isAutoAdjustRowHeight()) {
            this.resizingColumn = this.getTableHeader().getResizingColumn();
            if (this.resizingColumn == null && this.isValid()) {
                this.adjustRowHeight();
            }
        }
        if (this.resizingColumn != null && this.autoResizeMode == 0) {
            this.resizingColumn.setPreferredWidth(this.resizingColumn.getWidth());
        }
        this.resizeAndRepaint();
    }

    private void initialize() {
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (AdjustedRowHeightTable.this.isAutoAdjustRowHeight() && AdjustedRowHeightTable.this.resizingColumn != null) {
                    AdjustedRowHeightTable.this.adjustRowHeight();
                    AdjustedRowHeightTable.this.resizingColumn = null;
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                AdjustedRowHeightTable.this.adjustRowHeight();
            }
        });
    }

    public void adjustRowHeight() {
        for (int k = 0; k < this.getRowCount(); ++k) {
            this.updateRowHeight(k);
        }
    }

    protected int getPreferredRowHeight(int n) {
        int n2 = 0;
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int k = 0; k < tableColumnModel.getColumnCount(); ++k) {
            n2 = Math.max(n2, (int)Math.ceil(this.getPreferredCellHeight(n, k)));
        }
        return n2;
    }

    protected double getPreferredCellHeight(int n, int n2) {
        double d2 = 0.0;
        JPanel jPanel = new JPanel();
        jPanel.setFont(this.getFont());
        TableCellRenderer tableCellRenderer = this.getCellRenderer(n, n2);
        Component component = tableCellRenderer.getTableCellRendererComponent(this, this.getValueAt(n, n2), false, false, n, n2);
        jPanel.setSize(this.columnModel.getColumn(n2).getWidth(), 0);
        jPanel.add(component, 0);
        d2 = component.getPreferredSize().getHeight();
        jPanel.remove(0);
        return d2;
    }

    protected void updateRowHeight(int n) {
        if (n >= this.getRowCount()) {
            return;
        }
        int n2 = this.getPreferredRowHeight(n);
        if (n2 != this.getRowHeight(n)) {
            this.setRowHeight(n, n2);
        }
    }
}

