/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.widget.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JToggleButton;
import javax.swing.filechooser.FileSystemView;
import net.astah.golf.util.LookAndFeelFinder;

public class AdjustToggleButtonSizeFileChooser
extends JFileChooser {
    private static final long serialVersionUID = -93736715086614422L;

    public AdjustToggleButtonSizeFileChooser() {
        this.adjustToggleButtonSize(this);
    }

    public AdjustToggleButtonSizeFileChooser(String string) {
        super(string);
        this.adjustToggleButtonSize(this);
    }

    public AdjustToggleButtonSizeFileChooser(File file) {
        super(file);
        this.adjustToggleButtonSize(this);
    }

    public AdjustToggleButtonSizeFileChooser(FileSystemView fileSystemView) {
        super(fileSystemView);
        this.adjustToggleButtonSize(this);
    }

    public AdjustToggleButtonSizeFileChooser(File file, FileSystemView fileSystemView) {
        super(file, fileSystemView);
        this.adjustToggleButtonSize(this);
    }

    public AdjustToggleButtonSizeFileChooser(String string, FileSystemView fileSystemView) {
        super(string, fileSystemView);
        this.adjustToggleButtonSize(this);
    }

    private void adjustToggleButtonSize(Component component) {
        if (!LookAndFeelFinder.isWindowsLookAndFeel() && !LookAndFeelFinder.isWindowsClassicLookAndFeel()) {
            return;
        }
        List<JToggleButton> list = this.getToggleButtons(component);
        Dimension dimension = this.getMaxDimension(list);
        for (JToggleButton jToggleButton : list) {
            this.setSize(jToggleButton, dimension);
        }
    }

    private List<JToggleButton> getToggleButtons(Component component) {
        Component[] componentArray;
        if (component instanceof JToggleButton) {
            return Arrays.asList((JToggleButton)JToggleButton.class.cast(component));
        }
        ArrayList<JToggleButton> arrayList = new ArrayList<JToggleButton>();
        if (!(component instanceof JComponent)) {
            return arrayList;
        }
        for (Component component2 : componentArray = ((JComponent)JComponent.class.cast(component)).getComponents()) {
            arrayList.addAll(this.getToggleButtons(component2));
        }
        return arrayList;
    }

    private Dimension getMaxDimension(List<JToggleButton> list) {
        int n = 0;
        int n2 = 0;
        for (JToggleButton jToggleButton : list) {
            String string = jToggleButton.getText();
            JToggleButton jToggleButton2 = new JToggleButton(string);
            Icon icon = jToggleButton.getIcon();
            n = Math.max(n, this.getPreferredWidth(jToggleButton2, icon));
            n2 = Math.max(n2, this.getPreferredHeight(jToggleButton2, icon));
        }
        return new Dimension(n, n2);
    }

    private int getPreferredWidth(JToggleButton jToggleButton, Icon icon) {
        int n = icon.getIconWidth();
        String string = jToggleButton.getText();
        if (string == null || string.isEmpty()) {
            return n;
        }
        int n2 = jToggleButton.getPreferredSize().width;
        return Math.max(n2, n);
    }

    private int getPreferredHeight(JToggleButton jToggleButton, Icon icon) {
        int n = icon.getIconHeight();
        String string = jToggleButton.getText();
        if (string == null || string.isEmpty()) {
            return n;
        }
        int n2 = jToggleButton.getPreferredSize().height;
        return n2 + n;
    }

    private void setSize(JToggleButton jToggleButton, Dimension dimension) {
        jToggleButton.setMaximumSize(dimension);
        jToggleButton.setMinimumSize(dimension);
        jToggleButton.setPreferredSize(dimension);
    }
}

