/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.widget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.tree.TreePath;
import net.astah.golf.widget.ElementComparer;
import net.astah.golf.widget.ITreeSelection;
import net.astah.golf.widget.StructuredSelection;

public class TreeSelection
extends StructuredSelection
implements ITreeSelection {
    private static final TreePath[] EMPTY_TREE_PATHS = new TreePath[0];
    private final TreePath[] paths;
    private final Map<Object, List<TreePath>> pathsMap;

    public TreeSelection(TreePath[] treePathArray) {
        this(treePathArray, (ElementComparer)null);
    }

    public TreeSelection(TreePath[] treePathArray, ElementComparer elementComparer) {
        super(TreeSelection.getElements(treePathArray), elementComparer);
        this.paths = TreeSelection.clonePaths(treePathArray);
        this.pathsMap = elementComparer != null && elementComparer == ElementComparer.IDENTITY ? new IdentityHashMap() : new HashMap<Object, List<TreePath>>();
        for (TreePath treePath : treePathArray) {
            Object object = treePath.getLastPathComponent();
            List<TreePath> list = this.pathsMap.get(object);
            if (list == null) {
                list = new ArrayList<TreePath>();
                this.pathsMap.put(object, list);
            }
            list.add(treePath);
        }
    }

    public TreeSelection(TreePath treePath) {
        TreePath[] treePathArray;
        if (treePath != null) {
            TreePath[] treePathArray2 = new TreePath[1];
            treePathArray = treePathArray2;
            treePathArray2[0] = treePath;
        } else {
            treePathArray = EMPTY_TREE_PATHS;
        }
        this(treePathArray, (ElementComparer)null);
    }

    public TreeSelection(TreePath treePath, ElementComparer elementComparer) {
        TreePath[] treePathArray;
        if (treePath != null) {
            TreePath[] treePathArray2 = new TreePath[1];
            treePathArray = treePathArray2;
            treePathArray2[0] = treePath;
        } else {
            treePathArray = EMPTY_TREE_PATHS;
        }
        this(treePathArray, elementComparer);
    }

    @Override
    public TreePath[] getPaths() {
        return TreeSelection.clonePaths(this.paths);
    }

    @Override
    public TreePath[] getPathsFor(Object object) {
        List<TreePath> list = this.pathsMap.get(object);
        if (list == null || list.isEmpty()) {
            return EMPTY_TREE_PATHS;
        }
        return list.toArray(new TreePath[list.size()]);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ITreeSelection)) {
            return false;
        }
        if (object instanceof TreeSelection) {
            TreeSelection treeSelection = (TreeSelection)object;
            return Arrays.equals(this.paths, treeSelection.paths);
        }
        ITreeSelection iTreeSelection = (ITreeSelection)object;
        return Arrays.equals(this.paths, iTreeSelection.getPaths());
    }

    @Override
    public int hashCode() {
        int n = 0;
        for (TreePath treePath : this.paths) {
            n = n * 37 + (treePath == null ? 0 : treePath.hashCode());
        }
        return n;
    }

    static Object[] getElements(TreePath[] treePathArray) {
        Objects.requireNonNull(treePathArray, "paths");
        Object[] objectArray = new Object[treePathArray.length];
        for (int k = 0; k < treePathArray.length; ++k) {
            objectArray[k] = treePathArray[k].getLastPathComponent();
        }
        return objectArray;
    }

    static TreePath[] clonePaths(TreePath[] treePathArray) {
        return treePathArray.length > 0 ? (TreePath[])treePathArray.clone() : EMPTY_TREE_PATHS;
    }
}

