/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.widget;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.astah.golf.widget.ElementComparer;
import net.astah.golf.widget.IListSelection;
import net.astah.golf.widget.ITableSelection;
import net.astah.golf.widget.ListSelection;
import net.astah.golf.widget.StructuredSelection;

public class TableSelection
extends StructuredSelection
implements ITableSelection {
    private static final ITableSelection EMPTY = new TableSelection();
    private final IListSelection rowSelection;
    private final IListSelection columnSelection;

    public static ITableSelection empty() {
        return EMPTY;
    }

    public TableSelection() {
        this.rowSelection = ListSelection.empty();
        this.columnSelection = ListSelection.empty();
    }

    public TableSelection(Object[] objectArray, IListSelection iListSelection, IListSelection iListSelection2) {
        this(Arrays.asList(objectArray), iListSelection, iListSelection2, null);
    }

    public TableSelection(Object[] objectArray, IListSelection iListSelection, IListSelection iListSelection2, ElementComparer elementComparer) {
        super(objectArray, elementComparer);
        this.rowSelection = Objects.requireNonNull(iListSelection, "rowSelection");
        this.columnSelection = Objects.requireNonNull(iListSelection2, "columnSelection");
    }

    public TableSelection(Object object, IListSelection iListSelection, IListSelection iListSelection2) {
        this(Collections.singletonList(object), iListSelection, iListSelection2);
    }

    public TableSelection(List<?> list, IListSelection iListSelection, IListSelection iListSelection2) {
        this(list, iListSelection, iListSelection2, null);
    }

    public TableSelection(List<?> list, IListSelection iListSelection, IListSelection iListSelection2, ElementComparer elementComparer) {
        super(list, elementComparer);
        this.rowSelection = Objects.requireNonNull(iListSelection, "rowSelection");
        this.columnSelection = Objects.requireNonNull(iListSelection2, "columnSelection");
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ITableSelection) || !super.equals(object)) {
            return false;
        }
        ITableSelection iTableSelection = (ITableSelection)object;
        if (!Objects.equals(this.rowSelection, iTableSelection.getRowSelection())) {
            return false;
        }
        return Objects.equals(this.columnSelection, iTableSelection.getColumnSelection());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = n * 37 + Objects.hashCode(this.rowSelection);
        n = n * 37 + Objects.hashCode(this.columnSelection);
        return n;
    }

    @Override
    public IListSelection getRowSelection() {
        return this.rowSelection;
    }

    @Override
    public IListSelection getColumnSelection() {
        return this.columnSelection;
    }
}

