/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.widget;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.astah.golf.widget.ElementComparer;
import net.astah.golf.widget.IStructuredSelection;

public class StructuredSelection
implements IStructuredSelection {
    private static final Object[] EMPTY_ELEMENTS = new Object[0];
    private final Object[] elements;
    private final ElementComparer comparer;
    private static final IStructuredSelection EMPTY = new StructuredSelection();

    public static IStructuredSelection empty() {
        return EMPTY;
    }

    public StructuredSelection() {
        this.elements = EMPTY_ELEMENTS;
        this.comparer = ElementComparer.OBJECT;
    }

    public StructuredSelection(Object[] objectArray) {
        this(objectArray, null);
    }

    public StructuredSelection(Object[] objectArray, ElementComparer elementComparer) {
        Objects.requireNonNull(objectArray, "elements");
        this.elements = StructuredSelection.cloneElements(objectArray);
        this.comparer = elementComparer != null ? elementComparer : ElementComparer.OBJECT;
    }

    public StructuredSelection(Object object) {
        Objects.requireNonNull(object, "element");
        this.elements = new Object[]{object};
        this.comparer = ElementComparer.OBJECT;
    }

    public StructuredSelection(List<?> list) {
        this(list, null);
    }

    public StructuredSelection(List<?> list, ElementComparer elementComparer) {
        Objects.requireNonNull(list, "elements");
        this.elements = list.toArray();
        this.comparer = elementComparer != null ? elementComparer : ElementComparer.OBJECT;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IStructuredSelection)) {
            return false;
        }
        if (object instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)object;
            return this.comparer.equals(this.elements, structuredSelection.elements);
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)object;
        return this.size() == iStructuredSelection.size() && this.comparer.equals(this.iterator(), iStructuredSelection.iterator());
    }

    public int hashCode() {
        int n = 0;
        for (Object object : this.elements) {
            n = n * 37 + (object == null ? 0 : this.comparer.hashCode(object));
        }
        return n;
    }

    @Override
    public Object getFirstElement() {
        return this.isEmpty() ? null : this.elements[0];
    }

    @Override
    public boolean isEmpty() {
        return this.elements.length == 0;
    }

    @Override
    public Iterator<Object> iterator() {
        if (this.isEmpty()) {
            return Collections.emptyIterator();
        }
        return Arrays.asList(this.elements).iterator();
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public Object[] toArray() {
        return StructuredSelection.cloneElements(this.elements);
    }

    @Override
    public List<Object> toList() {
        return Collections.unmodifiableList(Arrays.asList(this.elements));
    }

    public String toString() {
        return this.isEmpty() ? "<empty_selection>" : Arrays.asList(this.elements).toString();
    }

    static Object[] cloneElements(Object[] objectArray) {
        return objectArray.length > 0 ? (Object[])objectArray.clone() : EMPTY_ELEMENTS;
    }
}

