/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.widget;

import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Supplier;
import net.astah.golf.widget.ISelection;
import net.astah.golf.widget.ISelectionChangedListener;
import net.astah.golf.widget.ISelectionProvider;
import net.astah.golf.widget.SelectionChangedEvent;
import net.astah.golf.widget.StructuredSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class SelectionSupport
extends ArrayList<ISelectionChangedListener> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectionSupport.class);
    private static final Marker MARKER_SELECTION = MarkerFactory.getMarker((String)"selection");
    protected final ISelectionProvider provider;
    protected final Supplier<ISelection> supplier;
    protected ISelection selection;

    public SelectionSupport(ISelectionProvider iSelectionProvider, Supplier<ISelection> supplier) {
        this.provider = iSelectionProvider;
        this.supplier = supplier;
        this.refresh();
    }

    public ISelection getSelection() {
        return this.selection != null ? this.selection : StructuredSelection.empty();
    }

    public void refresh() {
        this.selection = this.supplier.get();
    }

    public void update() {
        if (this.isEmpty()) {
            this.refresh();
        } else {
            ISelection iSelection = this.getSelection();
            this.refresh();
            ISelection iSelection2 = this.getSelection();
            if (!Objects.equals(iSelection, iSelection2)) {
                this.fireSelectionChangedEvent(new SelectionChangedEvent(this.provider, iSelection2));
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        Objects.requireNonNull(iSelectionChangedListener, "listener");
        if (!this.contains(iSelectionChangedListener)) {
            this.add(iSelectionChangedListener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.remove(iSelectionChangedListener);
    }

    protected void fireSelectionChangedEvent(SelectionChangedEvent selectionChangedEvent) {
        Objects.requireNonNull(selectionChangedEvent, "event");
        LOGGER.trace(MARKER_SELECTION, "Selection Changed: source={},selection={}", selectionChangedEvent.getSource(), (Object)selectionChangedEvent.getSelection());
        for (ISelectionChangedListener iSelectionChangedListener : this) {
            iSelectionChangedListener.selectionChanged(selectionChangedEvent);
        }
    }

    protected void setSelection(ISelection iSelection) {
        this.selection = iSelection;
    }
}

