/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.widget;

import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.astah.golf.widget.ISelection;
import net.astah.golf.widget.ISelectionChangedListener;
import net.astah.golf.widget.ISelectionProvider;
import net.astah.golf.widget.SelectionChangedEvent;
import net.astah.golf.widget.StructuredSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class SelectionDelegate
extends ArrayList<ISelectionChangedListener>
implements ISelectionChangedListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectionDelegate.class);
    private static final Marker MARKER_SELECTION = MarkerFactory.getMarker((String)"selection");
    protected final ISelectionProvider provider;
    private final Function<SelectionChangedEvent, SelectionChangedEvent> translator;
    private ISelectionProvider currentProvider;
    private ISelection currentSelection = StructuredSelection.empty();

    public SelectionDelegate(ISelectionProvider iSelectionProvider) {
        this(iSelectionProvider, null);
    }

    public SelectionDelegate(ISelectionProvider iSelectionProvider, Function<SelectionChangedEvent, SelectionChangedEvent> function) {
        this.provider = iSelectionProvider;
        this.translator = function != null ? function : Function.identity();
    }

    @Override
    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        SelectionChangedEvent selectionChangedEvent2;
        ISelection iSelection;
        if (!this.isEmpty() && !Objects.equals(this.currentSelection, iSelection = selectionChangedEvent.getSelection()) && iSelection != null && (selectionChangedEvent2 = this.translator.apply(selectionChangedEvent)) != null) {
            this.currentProvider = selectionChangedEvent2.getSelectionProvider();
            this.currentSelection = selectionChangedEvent2.getSelection();
            this.fireSelectionChangedEvent(selectionChangedEvent2);
        }
    }

    public ISelection getSelection(Supplier<ISelectionProvider> supplier) {
        this.update(supplier);
        return this.currentSelection;
    }

    public void setSelection(ISelection iSelection, Supplier<ISelectionProvider> supplier) {
        Objects.requireNonNull(iSelection, "selection");
        this.update(supplier);
        if (this.currentProvider != null) {
            this.currentProvider.setSelection(iSelection);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        Objects.requireNonNull(iSelectionChangedListener, "listener");
        if (!this.contains(iSelectionChangedListener)) {
            this.add(iSelectionChangedListener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.remove(iSelectionChangedListener);
    }

    public void fireSelectionChangedEvent() {
        ISelection iSelection;
        if (!this.isEmpty() && !Objects.equals(this.currentSelection, iSelection = this.provider.getSelection()) && iSelection != null) {
            this.currentProvider = this.provider;
            this.currentSelection = iSelection;
            this.fireSelectionChangedEvent(new SelectionChangedEvent(this.provider, iSelection));
        }
    }

    public void fireSelectionChangedEvent(SelectionChangedEvent selectionChangedEvent) {
        Objects.requireNonNull(selectionChangedEvent, "event");
        LOGGER.trace(MARKER_SELECTION, "Selection Changed: source={},selection={}", selectionChangedEvent.getSource(), (Object)selectionChangedEvent.getSelection());
        for (ISelectionChangedListener iSelectionChangedListener : this) {
            iSelectionChangedListener.selectionChanged(selectionChangedEvent);
        }
    }

    protected void update(Supplier<ISelectionProvider> supplier) {
        if (this.currentProvider == null) {
            this.currentProvider = supplier.get();
            if (this.currentProvider != null) {
                this.currentSelection = this.currentProvider.getSelection();
                if (this.currentSelection == null) {
                    this.currentSelection = StructuredSelection.empty();
                }
            }
        }
    }
}

