/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.widget;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.astah.golf.widget.ElementComparer;
import net.astah.golf.widget.IListSelection;
import net.astah.golf.widget.StructuredSelection;

public class ListSelection
extends StructuredSelection
implements IListSelection {
    private static final int[] EMPTY_INDICES = new int[0];
    private static final ListSelection EMPTY = new ListSelection();
    private final int[] indices;

    public static ListSelection empty() {
        return EMPTY;
    }

    public ListSelection() {
        this.indices = EMPTY_INDICES;
    }

    public ListSelection(int[] nArray) {
        this.indices = (int[])Objects.requireNonNull(nArray, "indices").clone();
    }

    public ListSelection(int[] nArray, Object[] objectArray, ElementComparer elementComparer) {
        super(objectArray, elementComparer);
        this.indices = (int[])Objects.requireNonNull(nArray, "indices").clone();
    }

    public ListSelection(int[] nArray, Object[] objectArray) {
        this(EMPTY_INDICES, objectArray, null);
    }

    public ListSelection(int[] nArray, List<?> list, ElementComparer elementComparer) {
        super(list, elementComparer);
        this.indices = (int[])Objects.requireNonNull(nArray, "indices").clone();
    }

    public ListSelection(int[] nArray, List<?> list) {
        this(nArray, list, null);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof IListSelection) || !super.equals(object)) {
            return false;
        }
        if (object instanceof ListSelection) {
            ListSelection listSelection = (ListSelection)object;
            if (!Arrays.equals(this.indices, listSelection.indices)) {
                return false;
            }
        } else {
            IListSelection iListSelection = (IListSelection)object;
            if (!Arrays.equals(this.indices, iListSelection.getIndices())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = n * 37 + Arrays.hashCode(this.indices);
        return n;
    }

    @Override
    public int[] getIndices() {
        return this.indices.length > 0 ? (int[])this.indices.clone() : EMPTY_INDICES;
    }

    @Override
    public int getFirstIndex() {
        return this.indices.length > 0 ? this.indices[0] : -1;
    }
}

