/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.view.swing;

import java.util.Objects;
import javax.swing.JTable;
import net.astah.golf.view.swing.IPropertySourceProvider;
import net.astah.golf.view.swing.ITableColumnProvider;
import net.astah.golf.view.swing.ITreeTableColumnProvider;
import net.astah.golf.view.swing.TableColumnProvider;
import net.astah.golf.widget.swing.IInputProvider;
import net.astah.golf.widget.swing.ILabelProvider;
import net.astah.jomt.jview.TreeTableModel;
import proguard.annotation.Keep;
import proguard.annotation.KeepClassMembers;
import proguard.annotation.KeepImplementations;

@Keep
@KeepClassMembers
@KeepImplementations
public class TreeTableColumnProvider
extends TableColumnProvider
implements ITreeTableColumnProvider {
    public TreeTableColumnProvider(Iterable<ITableColumnProvider.IColumnDescriptor> iterable) {
        super(iterable);
    }

    @Override
    protected void updateRowSorter(JTable jTable, IInputProvider iInputProvider, IPropertySourceProvider iPropertySourceProvider) {
        assert (this.getColumnDescriptors().stream().noneMatch(iColumnDescriptor -> iColumnDescriptor.getSortKey(iInputProvider, 0) != null));
    }

    @Override
    public ITableColumnProvider.IColumnDescriptor getHierarchicalColumn() {
        return this.columnDescriptors.stream().filter(this::isHierarchical).findFirst().orElse(null);
    }

    @Override
    public boolean isHierarchical(ITableColumnProvider.IColumnDescriptor iColumnDescriptor) {
        return iColumnDescriptor instanceof HierarchicalColumnDescriptor;
    }

    public static HierarchicalColumnDescriptor hierarchical(String string) {
        return TreeTableColumnProvider.hierarchical(string, null);
    }

    public static HierarchicalColumnDescriptor hierarchical(String string, ILabelProvider iLabelProvider) {
        return (HierarchicalColumnDescriptor)new HierarchicalColumnDescriptor(iLabelProvider).setHeaderValue(string);
    }

    @Keep
    @KeepClassMembers
    @KeepImplementations
    public static class HierarchicalColumnDescriptor
    extends TableColumnProvider.AbstractColumnDescriptor {
        protected ILabelProvider labelProvider;

        protected HierarchicalColumnDescriptor(ILabelProvider iLabelProvider) {
            this.labelProvider = iLabelProvider;
        }

        @Override
        public Class<?> getColumnClass(IInputProvider iInputProvider) {
            return TreeTableModel.class;
        }

        @Override
        public Object getColumnValue(IPropertySourceProvider iPropertySourceProvider, Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getColumnTextValue(IPropertySourceProvider iPropertySourceProvider, Object object) {
            Objects.requireNonNull(this.labelProvider, "labelProvider");
            return this.labelProvider.getText(object);
        }

        public ILabelProvider getLabelProvider() {
            return this.labelProvider;
        }

        public HierarchicalColumnDescriptor setLabelProvider(ILabelProvider iLabelProvider) {
            this.labelProvider = iLabelProvider;
            return this;
        }
    }
}

