/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.view.swing;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultRowSorter;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.astah.golf.view.swing.ActivatableCellEditor;
import net.astah.golf.view.swing.FlexiblePropertyCellEditor;
import net.astah.golf.view.swing.ILabelPropertySource;
import net.astah.golf.view.swing.IPropertyDescriptor;
import net.astah.golf.view.swing.IPropertySource;
import net.astah.golf.view.swing.IPropertySourceProvider;
import net.astah.golf.view.swing.ITableColumnProvider;
import net.astah.golf.view.swing.IVariantLabelPropertySource;
import net.astah.golf.view.swing.MultilineTextPropertyCellEditor;
import net.astah.golf.view.swing.PropertyCellEditor;
import net.astah.golf.view.swing.PropertySourceCellRenderer;
import net.astah.golf.widget.swing.ContentTableModel;
import net.astah.golf.widget.swing.IInputProvider;
import net.astah.golf.widget.swing.ILabelProvider;
import net.astah.golf.widget.swing.LabelProvider;
import net.astah.golf.widget.swing.LabelProviderTableCellRenderer;
import net.astah.jomt.jview.TextAwareTableModel;
import proguard.annotation.Keep;
import proguard.annotation.KeepImplementations;
import proguard.annotation.KeepPublicClassMembers;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class TableColumnProvider
implements ITableColumnProvider {
    protected final List<ITableColumnProvider.IColumnDescriptor> columnDescriptors = new ArrayList<ITableColumnProvider.IColumnDescriptor>();

    public TableColumnProvider(Iterable<ITableColumnProvider.IColumnDescriptor> iterable) {
        Iterables.addAll(this.columnDescriptors, iterable);
    }

    @Override
    public void update(JTable jTable, IInputProvider iInputProvider, IPropertySourceProvider iPropertySourceProvider) {
        this.updateColumnModel(jTable.getColumnModel(), iInputProvider, iPropertySourceProvider);
        this.updateRowSorter(jTable, iInputProvider, iPropertySourceProvider);
    }

    protected void updateColumnModel(TableColumnModel tableColumnModel, IInputProvider iInputProvider, IPropertySourceProvider iPropertySourceProvider) {
        ITableColumnProvider.IColumnDescriptor iColumnDescriptor;
        TableColumn tableColumn;
        ListIterator<ITableColumnProvider.IColumnDescriptor> listIterator = this.columnDescriptors.listIterator();
        while (listIterator.hasNext() && listIterator.nextIndex() < tableColumnModel.getColumnCount()) {
            tableColumn = tableColumnModel.getColumn(listIterator.nextIndex());
            iColumnDescriptor = listIterator.next();
            iColumnDescriptor.updateColumn(tableColumn, iInputProvider, iPropertySourceProvider);
        }
        while (listIterator.hasNext()) {
            tableColumn = new TableColumn(listIterator.nextIndex());
            iColumnDescriptor = listIterator.next();
            iColumnDescriptor.updateColumn(tableColumn, iInputProvider, iPropertySourceProvider);
        }
        while (listIterator.nextIndex() > tableColumnModel.getColumnCount()) {
            tableColumnModel.removeColumn(tableColumnModel.getColumn(tableColumnModel.getColumnCount() - 1));
        }
    }

    protected void updateRowSorter(JTable jTable, IInputProvider iInputProvider, IPropertySourceProvider iPropertySourceProvider) {
        TableRowSorter<TableModel> tableRowSorter = null;
        ArrayList<ITableColumnProvider.PrioritySortKey> arrayList = null;
        int n = this.columnDescriptors.size();
        for (int k = 0; k < n; ++k) {
            ITableColumnProvider.IColumnDescriptor iColumnDescriptor = this.columnDescriptors.get(k);
            ITableColumnProvider.PrioritySortKey prioritySortKey = iColumnDescriptor.getSortKey(iInputProvider, k);
            if (prioritySortKey != null) {
                if (tableRowSorter == null) {
                    tableRowSorter = new TableRowSorter<TableModel>();
                    tableRowSorter.setModel(jTable.getModel());
                    for (int i2 = 0; i2 < k; ++i2) {
                        tableRowSorter.setSortable(i2, false);
                    }
                    arrayList = new ArrayList<ITableColumnProvider.PrioritySortKey>(n);
                }
                iColumnDescriptor.updateRowSorter(tableRowSorter, iInputProvider, iPropertySourceProvider, k);
                arrayList.add(prioritySortKey);
                continue;
            }
            if (tableRowSorter == null) continue;
            tableRowSorter.setSortable(k, false);
        }
        if (tableRowSorter != null) {
            Collections.sort(arrayList);
            tableRowSorter.setSortKeys(arrayList);
            jTable.setRowSorter((RowSorter<? extends TableModel>)tableRowSorter);
        }
    }

    protected <T> T getColumnDescriptor(JTable jTable, int n, Class<T> clazz) {
        Object object = jTable.getColumnModel().getColumn(n).getIdentifier();
        return clazz.isInstance(object) ? (T)clazz.cast(object) : null;
    }

    @Override
    public List<ITableColumnProvider.IColumnDescriptor> getColumnDescriptors() {
        return Collections.unmodifiableList(this.columnDescriptors);
    }

    public static LabelColumnDescriptor label(String string) {
        return (LabelColumnDescriptor)new LabelColumnDescriptor(new LabelProvider()).setHeaderValue(string);
    }

    public static LabelColumnDescriptor label(String string, ILabelProvider iLabelProvider) {
        return (LabelColumnDescriptor)new LabelColumnDescriptor(iLabelProvider).setHeaderValue(string);
    }

    public static IdPropertyColumnDescriptor idProperty(String string, Object object) {
        return (IdPropertyColumnDescriptor)new IdPropertyColumnDescriptor(object).setHeaderValue(string);
    }

    public static IdPropertyColumnDescriptor idProperty(String string, Set<Object> set) {
        return (IdPropertyColumnDescriptor)new IdPropertyColumnDescriptor(set).setHeaderValue(string);
    }

    public static LabelPropertyColumnDescriptor labelProperty(String string) {
        return (LabelPropertyColumnDescriptor)new LabelPropertyColumnDescriptor().setHeaderValue(string);
    }

    public static VariantLabelPropertyColumnDescriptor variantLabelProperty(String string, Object object) {
        return (VariantLabelPropertyColumnDescriptor)new VariantLabelPropertyColumnDescriptor(object).setHeaderValue(string);
    }

    public static CheckBoxPropertyColumnDescriptor checkBoxProperty(String string, Object object) {
        return (CheckBoxPropertyColumnDescriptor)new CheckBoxPropertyColumnDescriptor(object).setHeaderValue(string);
    }

    @Keep
    @KeepPublicProtectedClassMembers
    @KeepImplementations
    protected static class ColumnCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActivatableCellEditor {
        private static final long serialVersionUID = 1L;
        protected PropertyColumnDescriptor propertyColumnDescriptor;
        protected IPropertySourceProvider propertySourceProvider;
        protected IPropertySource propertySource;
        protected PropertyCellEditor cellEditor;
        protected int clickCountToStart = 1;

        public ColumnCellEditor(PropertyColumnDescriptor propertyColumnDescriptor, IPropertySourceProvider iPropertySourceProvider) {
            this.propertyColumnDescriptor = propertyColumnDescriptor;
            this.propertySourceProvider = iPropertySourceProvider;
        }

        @Override
        public Object getCellEditorValue() {
            return this.cellEditor != null ? this.cellEditor.getCellEditorValue() : null;
        }

        public void setClickCountToStart(int n) {
            this.clickCountToStart = n;
        }

        public int getClickCountToStart() {
            return this.clickCountToStart;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            Object object = eventObject.getSource();
            if (object instanceof JTable) {
                int n;
                int n2;
                JTable jTable = (JTable)object;
                if (eventObject instanceof MouseEvent) {
                    n2 = jTable.rowAtPoint(((MouseEvent)eventObject).getPoint());
                    n = jTable.columnAtPoint(((MouseEvent)eventObject).getPoint());
                } else {
                    if (eventObject instanceof KeyEvent && this.a((KeyEvent)eventObject)) {
                        return false;
                    }
                    n2 = jTable.getSelectedRow();
                    n = jTable.getSelectedColumn();
                }
                if (n2 >= 0 && n >= 0) {
                    if (!this.isEditable(jTable, n2, n)) {
                        return false;
                    }
                    if (eventObject instanceof MouseEvent) {
                        return ((MouseEvent)eventObject).getClickCount() >= this.clickCountToStart;
                    }
                }
            }
            return true;
        }

        private boolean a(KeyEvent keyEvent) {
            if (keyEvent.isControlDown() || keyEvent.isMetaDown() || keyEvent.isAltDown()) {
                return true;
            }
            switch (keyEvent.getKeyCode()) {
                case 157: 
                case 524: {
                    return true;
                }
            }
            return false;
        }

        protected boolean isEditable(JTable jTable, int n, int n2) {
            TableModel tableModel = jTable.getModel();
            if (tableModel instanceof ContentTableModel) {
                int n3 = jTable.convertRowIndexToModel(n);
                Object object = ((ContentTableModel)tableModel).getRowAt(n3);
                return this.propertyColumnDescriptor.canSetProperty(this.propertySourceProvider, object);
            }
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            return this.cellEditor == null || this.cellEditor.shouldSelectCell(eventObject);
        }

        @Override
        public void startCellEditing() {
            if (this.cellEditor instanceof ActivatableCellEditor) {
                ((ActivatableCellEditor)((Object)this.cellEditor)).startCellEditing();
            }
        }

        @Override
        public boolean stopCellEditing() {
            if (this.cellEditor != null) {
                return this.cellEditor.stopCellEditing();
            }
            return false;
        }

        @Override
        public void cancelCellEditing() {
            if (this.cellEditor != null) {
                this.cellEditor.cancelCellEditing();
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Object object2;
            this.cellEditor = null;
            IPropertyDescriptor iPropertyDescriptor = this.getPropertyDescriptor(jTable, n);
            if (iPropertyDescriptor == null) {
                return null;
            }
            this.cellEditor = iPropertyDescriptor.createPropertyEditor();
            if (this.cellEditor == null) {
                return null;
            }
            this.cellEditor.addCellEditorListener(new TableCellEditorListener());
            Font font = jTable.getFont();
            if (this.cellEditor instanceof FlexiblePropertyCellEditor) {
                int n3 = jTable.getColumnModel().getColumn(n2).getWidth();
                object2 = (FlexiblePropertyCellEditor)this.cellEditor;
                object2.setFlexible(true);
                object2.setSize(new Dimension(n3, 0));
                if (this.cellEditor instanceof MultilineTextPropertyCellEditor) {
                    ((MultilineTextPropertyCellEditor)this.cellEditor).setStopEditingOnEnterKey(true);
                    int n4 = jTable.getFontMetrics(font).getHeight();
                    object2.setMinimumSize(new Dimension(0, n4 * 3));
                }
            }
            Object object3 = null;
            object2 = this.propertySourceProvider.getPropertySource(object);
            if (object2 != null) {
                object3 = object2.getEditableValue();
            }
            Component component = this.cellEditor.getPropertyCellEditorComponent(jTable, object3);
            component.setFont(font);
            return component;
        }

        protected IPropertyDescriptor getPropertyDescriptor(JTable jTable, int n) {
            int n2 = jTable.convertRowIndexToModel(n);
            Object object = ((ContentTableModel)jTable.getModel()).getRowAt(n2);
            IPropertySource iPropertySource = this.propertySourceProvider.getPropertySource(object);
            if (iPropertySource != null) {
                return this.propertyColumnDescriptor.getPropertyDescriptor(iPropertySource);
            }
            return null;
        }

        @Override
        public void addMouseListener(MouseListener mouseListener) {
            if (this.cellEditor instanceof ActivatableCellEditor) {
                ((ActivatableCellEditor)((Object)this.cellEditor)).addMouseListener(mouseListener);
            }
        }

        @Override
        public void removeMouseListener(MouseListener mouseListener) {
            if (this.cellEditor instanceof ActivatableCellEditor) {
                ((ActivatableCellEditor)((Object)this.cellEditor)).removeMouseListener(mouseListener);
            }
        }

        @Keep
        @KeepPublicClassMembers
        class TableCellEditorListener
        implements CellEditorListener {
            TableCellEditorListener() {
            }

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                ColumnCellEditor.super.stopCellEditing();
            }

            @Override
            public void editingCanceled(ChangeEvent changeEvent) {
                ColumnCellEditor.super.cancelCellEditing();
            }
        }
    }

    @Keep
    @KeepPublicProtectedClassMembers
    @KeepImplementations
    protected static class UndoSafeColumnCellRenderer
    extends ColumnCellRenderer {
        private static final long serialVersionUID = 1L;

        public UndoSafeColumnCellRenderer(PropertyColumnDescriptor propertyColumnDescriptor, IPropertySourceProvider iPropertySourceProvider) {
            super(propertyColumnDescriptor, iPropertySourceProvider);
        }

        @Override
        protected void setValue(Object object) {
            String string = Objects.toString(object, "");
            if (this.isLineWrap()) {
                this.label.setText(string, false);
            } else {
                this.setText(string);
            }
        }
    }

    @Keep
    @KeepPublicProtectedClassMembers
    @KeepImplementations
    protected static class ColumnCellRenderer
    extends PropertySourceCellRenderer {
        private static final long serialVersionUID = 1L;
        protected PropertyColumnDescriptor propertyColumnDescriptor;

        public ColumnCellRenderer(PropertyColumnDescriptor propertyColumnDescriptor, IPropertySourceProvider iPropertySourceProvider) {
            super(iPropertySourceProvider);
            this.propertyColumnDescriptor = propertyColumnDescriptor;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, Object object2, boolean bl, boolean bl2, int n, int n2) {
            this.setLineWrap(this.propertyColumnDescriptor.isLineWrap(object, n2));
            this.setShowImage(this.propertyColumnDescriptor.isShowImage());
            return super.getTableCellRendererComponent(jTable, object, object2, bl, bl2, n, n2);
        }

        @Override
        protected Object getRowValue(JTable jTable, int n) {
            int n2 = jTable.convertRowIndexToModel(n);
            return ((ContentTableModel)jTable.getModel()).getRowAt(n2);
        }

        @Override
        protected IPropertyDescriptor getPropertyDescriptor(Object object) {
            IPropertySource iPropertySource = this.getPropertySource(object);
            if (iPropertySource != null) {
                return this.propertyColumnDescriptor.getPropertyDescriptor(iPropertySource);
            }
            return null;
        }
    }

    @Keep
    @KeepPublicProtectedClassMembers
    @KeepImplementations
    public static class CheckBoxPropertyColumnDescriptor
    extends PropertyColumnDescriptor {
        protected final Object propertyId;
        private final JCheckBox a = new JCheckBox();

        protected CheckBoxPropertyColumnDescriptor(Object object) {
            this.propertyId = object;
        }

        @Override
        protected IPropertyDescriptor getPropertyDescriptor(IPropertySource iPropertySource) {
            return (IPropertyDescriptor)Iterables.tryFind(iPropertySource.getPropertyDescriptors(), iPropertyDescriptor -> iPropertyDescriptor.getId().equals(this.propertyId)).orNull();
        }

        @Override
        protected TableCellRenderer createCellRenderer(IPropertySourceProvider iPropertySourceProvider) {
            return new DefaultTableCellRenderer(){
                private static final long serialVersionUID = -6839052758373307454L;

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    a.setSelected((Boolean)object);
                    a.setBackground(super.getBackground());
                    return a;
                }
            };
        }

        @Override
        protected TableCellEditor createCellEditor(IPropertySourceProvider iPropertySourceProvider) {
            return new DefaultCellEditor(this.a);
        }
    }

    @Keep
    @KeepPublicProtectedClassMembers
    @KeepImplementations
    public static class VariantLabelPropertyColumnDescriptor
    extends PropertyColumnDescriptor {
        protected Object variant;

        protected VariantLabelPropertyColumnDescriptor(Object object) {
            this.variant = object;
        }

        public Object getVariant() {
            return this.variant;
        }

        public VariantLabelPropertyColumnDescriptor setVariant(Object object) {
            this.variant = object;
            return this;
        }

        @Override
        protected IPropertyDescriptor getPropertyDescriptor(IPropertySource iPropertySource) {
            if (iPropertySource instanceof IVariantLabelPropertySource) {
                return ((IVariantLabelPropertySource)iPropertySource).getTextPropertyDescriptor(this.variant);
            }
            return null;
        }
    }

    @Keep
    @KeepPublicProtectedClassMembers
    @KeepImplementations
    public static class LabelPropertyColumnDescriptor
    extends PropertyColumnDescriptor {
        protected LabelPropertyColumnDescriptor() {
        }

        @Override
        protected IPropertyDescriptor getPropertyDescriptor(IPropertySource iPropertySource) {
            if (iPropertySource instanceof ILabelPropertySource) {
                return ((ILabelPropertySource)iPropertySource).getTextPropertyDescriptor();
            }
            return null;
        }
    }

    @Keep
    @KeepPublicProtectedClassMembers
    @KeepImplementations
    public static class IdPropertyColumnDescriptor
    extends PropertyColumnDescriptor {
        protected final Set<Object> propertyIds;

        protected IdPropertyColumnDescriptor(Object object) {
            this.propertyIds = Sets.newHashSet((Object[])new Object[]{object});
        }

        protected IdPropertyColumnDescriptor(Set<Object> set) {
            this.propertyIds = Sets.newHashSet(set);
        }

        public Set<Object> getPropertyIds() {
            return this.propertyIds;
        }

        public IdPropertyColumnDescriptor addPropertyId(Object object) {
            this.propertyIds.add(object);
            return this;
        }

        public IdPropertyColumnDescriptor removePropertyId(Object object) {
            this.propertyIds.remove(object);
            return this;
        }

        @Override
        protected IPropertyDescriptor getPropertyDescriptor(IPropertySource iPropertySource) {
            return iPropertySource.getPropertyDescriptors().stream().filter(this::matchPropertyDescriptor).findFirst().orElse(null);
        }

        protected boolean matchPropertyDescriptor(IPropertyDescriptor iPropertyDescriptor) {
            return this.propertyIds.contains(iPropertyDescriptor.getId());
        }
    }

    @Keep
    @KeepPublicProtectedClassMembers
    @KeepImplementations
    public static abstract class PropertyColumnDescriptor
    extends AbstractColumnDescriptor
    implements ITableColumnProvider.IEditableColumnDescriptor {
        protected boolean showImage;

        public boolean isShowImage() {
            return this.showImage;
        }

        public PropertyColumnDescriptor setShowImage(boolean bl) {
            this.showImage = bl;
            return this;
        }

        @Override
        public void updateRowSorter(DefaultRowSorter<TableModel, Object> defaultRowSorter, IInputProvider iInputProvider, IPropertySourceProvider iPropertySourceProvider, int n) {
            super.updateRowSorter(defaultRowSorter, iInputProvider, iPropertySourceProvider, n);
            Comparator<?> comparator = this.getComparator(iInputProvider, iPropertySourceProvider);
            if (comparator != null) {
                defaultRowSorter.setComparator(n, new PropertyComparator(iPropertySourceProvider, comparator));
            }
        }

        @Override
        public Object getColumnValue(IPropertySourceProvider iPropertySourceProvider, Object object) {
            IPropertyDescriptor iPropertyDescriptor;
            IPropertySource iPropertySource = iPropertySourceProvider.getPropertySource(object);
            if (iPropertySource != null && (iPropertyDescriptor = this.getPropertyDescriptor(iPropertySource)) != null) {
                return iPropertySource.getPropertyValue(iPropertyDescriptor.getId());
            }
            return null;
        }

        @Override
        public String getColumnTextValue(IPropertySourceProvider iPropertySourceProvider, Object object) {
            Object object2 = this.getColumnValue(iPropertySourceProvider, object);
            IPropertySource iPropertySource = iPropertySourceProvider.getPropertySource(object2);
            if (iPropertySource != null && (object2 = iPropertySource.getEditableValue()) instanceof List) {
                object2 = ((List)object2).stream().map(iPropertySourceProvider::getPropertySource).filter(Objects::nonNull).map(IPropertySource::getEditableValue).map(Object::toString).collect(Collectors.joining("\n"));
            }
            return Objects.toString(object2, null);
        }

        @Override
        public void setColumnValue(IPropertySourceProvider iPropertySourceProvider, Object object, Object object2) {
            IPropertyDescriptor iPropertyDescriptor;
            IPropertySource iPropertySource = iPropertySourceProvider.getPropertySource(object);
            if (iPropertySource != null && (iPropertyDescriptor = this.getPropertyDescriptor(iPropertySource)) != null) {
                if (object2 != null) {
                    iPropertySource.setPropertyValue(iPropertyDescriptor.getId(), object2);
                } else {
                    iPropertySource.resetPropertyValue(iPropertyDescriptor.getId());
                }
            }
        }

        public boolean canSetProperty(IPropertySourceProvider iPropertySourceProvider, Object object) {
            IPropertyDescriptor iPropertyDescriptor;
            IPropertySource iPropertySource = iPropertySourceProvider.getPropertySource(object);
            if (iPropertySource != null && (iPropertyDescriptor = this.getPropertyDescriptor(iPropertySource)) != null) {
                return iPropertyDescriptor.createPropertyEditor() != null;
            }
            return true;
        }

        public boolean isLineWrap(Object object, int n) {
            return this.isLineWrap();
        }

        protected abstract IPropertyDescriptor getPropertyDescriptor(IPropertySource var1);

        @Override
        protected TableCellRenderer createCellRenderer(IPropertySourceProvider iPropertySourceProvider) {
            return new UndoSafeColumnCellRenderer(this, iPropertySourceProvider);
        }

        @Override
        protected TableCellEditor createCellEditor(IPropertySourceProvider iPropertySourceProvider) {
            return new ColumnCellEditor(this, iPropertySourceProvider);
        }

        protected int compare(IPropertySourceProvider iPropertySourceProvider, Comparator<Object> comparator, Object object, Object object2) {
            IPropertySource iPropertySource = iPropertySourceProvider.getPropertySource(object);
            IPropertySource iPropertySource2 = iPropertySourceProvider.getPropertySource(object2);
            if (iPropertySource != null && iPropertySource2 != null) {
                Object object3 = iPropertySource.getEditableValue();
                Object object4 = iPropertySource2.getEditableValue();
                return comparator.compare(object3, object4);
            }
            return comparator.compare(object, object2);
        }

        @Keep
        @KeepPublicClassMembers
        static class PropertyComparator
        implements Comparator<Object> {
            final IPropertySourceProvider a;
            final Comparator<Object> b;

            PropertyComparator(IPropertySourceProvider iPropertySourceProvider, Comparator<?> comparator) {
                Comparator<?> comparator2 = comparator;
                this.a = Objects.requireNonNull(iPropertySourceProvider, "provider");
                this.b = Objects.requireNonNull(comparator2, "comparator");
            }

            @Override
            public int compare(Object object, Object object2) {
                IPropertySource iPropertySource = this.a.getPropertySource(object);
                IPropertySource iPropertySource2 = this.a.getPropertySource(object2);
                if (iPropertySource != null && iPropertySource2 != null) {
                    Object object3 = iPropertySource.getEditableValue();
                    Object object4 = iPropertySource2.getEditableValue();
                    return this.b.compare(object3, object4);
                }
                return this.b.compare(object, object2);
            }
        }
    }

    @Keep
    @KeepPublicProtectedClassMembers
    @KeepImplementations
    public static class LabelColumnDescriptor
    extends AbstractColumnDescriptor {
        protected ILabelProvider labelProvider;
        protected Function<Object, Object> valueMapper = Function.identity();

        protected LabelColumnDescriptor(ILabelProvider iLabelProvider) {
            this.labelProvider = Objects.requireNonNull(iLabelProvider, "labelProvider");
        }

        @Override
        public Object getColumnValue(IPropertySourceProvider iPropertySourceProvider, Object object) {
            return this.valueMapper.apply(object);
        }

        @Override
        public String getColumnTextValue(IPropertySourceProvider iPropertySourceProvider, Object object) {
            Object object2 = this.getColumnValue(iPropertySourceProvider, object);
            return this.labelProvider.getText(object2);
        }

        public ILabelProvider getLabelProvider() {
            return this.labelProvider;
        }

        public LabelColumnDescriptor setLabelProvider(ILabelProvider iLabelProvider) {
            this.labelProvider = Objects.requireNonNull(iLabelProvider, "labelProvider");
            return this;
        }

        public Function<Object, Object> getValueMapper() {
            return this.valueMapper;
        }

        public LabelColumnDescriptor setValueMapper(Function<Object, Object> function) {
            this.valueMapper = Objects.requireNonNull(function, "valueMapper");
            return this;
        }

        public <T> LabelColumnDescriptor setValueMapper(Class<T> clazz, Function<T, Object> function) {
            Objects.requireNonNull(function, "valueMapper");
            return this.setValueMapper(object -> this.mapTypedValue(clazz, function, object));
        }

        @Override
        protected TableCellRenderer createCellRenderer(IPropertySourceProvider iPropertySourceProvider) {
            LabelProviderTableCellRenderer labelProviderTableCellRenderer = new LabelProviderTableCellRenderer(this.labelProvider);
            labelProviderTableCellRenderer.setLineWrap(this.isLineWrap());
            return labelProviderTableCellRenderer;
        }

        protected <T> Object mapTypedValue(Class<T> clazz, Function<T, Object> function, Object object) {
            return clazz.isInstance(object) ? function.apply(clazz.cast(object)) : object;
        }
    }

    @Keep
    @KeepPublicProtectedClassMembers
    @KeepImplementations
    public static abstract class AbstractColumnDescriptor
    implements ITableColumnProvider.IColumnDescriptor {
        private static final int SET_WIDTH = 1;
        private static final int SET_PREFERRED_WIDTH = 2;
        private static final int SET_MIN_WIDTH = 4;
        private static final int SET_MAX_WIDTH = 8;
        private static final int SET_RESIZABLE = 16;
        protected Object headerValue;
        protected Class<?> columnClass = Object.class;
        protected boolean lineWrap;
        protected SortOrder sortOrder;
        protected int sortPriority;
        protected Comparator<?> comparator;
        protected int width;
        protected int preferredWidth;
        protected int minWidth;
        protected int maxWidth;
        protected boolean resizable;
        protected int clickCountToStart;
        private int flags;

        @Override
        public void updateColumn(TableColumn tableColumn, IInputProvider iInputProvider, IPropertySourceProvider iPropertySourceProvider) {
            TableCellEditor tableCellEditor;
            TableCellRenderer tableCellRenderer;
            tableColumn.setIdentifier(this);
            tableColumn.setHeaderValue(this.getHeaderValue(iInputProvider));
            TableCellRenderer tableCellRenderer2 = this.createHeaderRenderer(iPropertySourceProvider);
            if (tableCellRenderer2 != null) {
                tableColumn.setHeaderRenderer(tableCellRenderer2);
            }
            if ((tableCellRenderer = this.createCellRenderer(iPropertySourceProvider)) != null) {
                tableColumn.setCellRenderer(tableCellRenderer);
            }
            if ((tableCellEditor = this.createCellEditor(iPropertySourceProvider)) != null) {
                tableColumn.setCellEditor(tableCellEditor);
                if (tableCellEditor instanceof ColumnCellEditor && this.clickCountToStart > 0) {
                    ((ColumnCellEditor)tableCellEditor).setClickCountToStart(this.clickCountToStart);
                }
            }
            if ((this.flags & 1) != 0) {
                tableColumn.setWidth(this.getWidth());
            }
            if ((this.flags & 2) != 0) {
                tableColumn.setPreferredWidth(this.getPreferredWidth());
            }
            if ((this.flags & 4) != 0) {
                tableColumn.setMinWidth(this.getMinWidth());
            }
            if ((this.flags & 8) != 0) {
                tableColumn.setMaxWidth(this.getMaxWidth());
            }
            if ((this.flags & 0x10) != 0) {
                tableColumn.setResizable(this.isResizable());
            }
        }

        @Override
        public void updateRowSorter(DefaultRowSorter<TableModel, Object> defaultRowSorter, IInputProvider iInputProvider, IPropertySourceProvider iPropertySourceProvider, int n) {
            defaultRowSorter.setSortable(n, true);
            Comparator<?> comparator = this.getComparator(iInputProvider, iPropertySourceProvider);
            if (comparator != null) {
                defaultRowSorter.setComparator(n, comparator);
            }
        }

        @Override
        public Object getHeaderValue(IInputProvider iInputProvider) {
            return this.getHeaderValue();
        }

        @Override
        public Class<?> getColumnClass(IInputProvider iInputProvider) {
            return this.columnClass;
        }

        @Override
        public ITableColumnProvider.PrioritySortKey getSortKey(IInputProvider iInputProvider, int n) {
            if (this.sortOrder != null) {
                return new ITableColumnProvider.PrioritySortKey(n, this.sortOrder, this.sortPriority);
            }
            return null;
        }

        public Comparator<?> getComparator(IInputProvider iInputProvider) {
            return this.comparator;
        }

        public Object getHeaderValue() {
            return this.headerValue;
        }

        public AbstractColumnDescriptor setHeaderValue(Object object) {
            this.headerValue = object;
            return this;
        }

        public Class<?> getColumnClass() {
            return this.columnClass;
        }

        public AbstractColumnDescriptor setColumnClass(Class<?> clazz) {
            this.columnClass = Objects.requireNonNull(clazz, "columnClass");
            return this;
        }

        public boolean isLineWrap() {
            return this.lineWrap;
        }

        public AbstractColumnDescriptor setLineWrap(boolean bl) {
            this.lineWrap = bl;
            return this;
        }

        public SortOrder getSortOrder() {
            return this.sortOrder;
        }

        public AbstractColumnDescriptor setSortOrder(SortOrder sortOrder) {
            this.sortOrder = Objects.requireNonNull(sortOrder, "sortOrder");
            return this;
        }

        public int getSortPriority() {
            return this.sortPriority;
        }

        public AbstractColumnDescriptor setSortPriority(int n) {
            this.sortPriority = n;
            return this;
        }

        public Comparator<?> getComparator(IInputProvider iInputProvider, IPropertySourceProvider iPropertySourceProvider) {
            return this.comparator;
        }

        public AbstractColumnDescriptor setComparator(Comparator<?> comparator) {
            this.comparator = comparator;
            return this;
        }

        public int getWidth() {
            return this.width;
        }

        public AbstractColumnDescriptor setWidth(int n) {
            this.width = n;
            this.flags |= 1;
            return this;
        }

        public int getMinWidth() {
            return this.minWidth;
        }

        public AbstractColumnDescriptor setMinWidth(int n) {
            this.minWidth = n;
            this.flags |= 4;
            return this;
        }

        public int getPreferredWidth() {
            return this.preferredWidth;
        }

        public AbstractColumnDescriptor setPreferredWidth(int n) {
            this.preferredWidth = n;
            this.flags |= 2;
            return this;
        }

        public int getMaxWidth() {
            return this.maxWidth;
        }

        public AbstractColumnDescriptor setMaxWidth(int n) {
            this.maxWidth = n;
            this.flags |= 8;
            return this;
        }

        public boolean isResizable() {
            return this.resizable;
        }

        public AbstractColumnDescriptor setResizable(boolean bl) {
            this.resizable = bl;
            this.flags |= 0x10;
            return this;
        }

        public int getClickCountToStart() {
            return this.clickCountToStart;
        }

        public AbstractColumnDescriptor setClickCountToStart(int n) {
            this.clickCountToStart = n;
            return this;
        }

        protected TableCellRenderer createHeaderRenderer(IPropertySourceProvider iPropertySourceProvider) {
            return null;
        }

        protected TableCellRenderer createCellRenderer(IPropertySourceProvider iPropertySourceProvider) {
            return null;
        }

        protected TableCellEditor createCellEditor(IPropertySourceProvider iPropertySourceProvider) {
            return null;
        }
    }

    @Keep
    @KeepPublicProtectedClassMembers
    @KeepImplementations
    protected static class TableRowSorter<M extends TableModel>
    extends DefaultRowSorter<M, Object> {
        protected TableRowSorter() {
        }

        public void setModel(M m) {
            this.setModelWrapper(new TableModelWrapper<M>(m));
        }

        @Override
        public Comparator<?> getComparator(int n) {
            Comparator<?> comparator = super.getComparator(n);
            if (comparator != null) {
                return comparator;
            }
            Class<?> clazz = ((TableModel)this.getModel()).getColumnClass(n);
            if (clazz == String.class) {
                return Collator.getInstance();
            }
            if (Comparable.class.isAssignableFrom(clazz)) {
                return Comparator.naturalOrder();
            }
            return Collator.getInstance();
        }

        @Override
        protected boolean useToString(int n) {
            Comparator<?> comparator = super.getComparator(n);
            if (comparator != null) {
                return false;
            }
            Class<?> clazz = ((TableModel)this.getModel()).getColumnClass(n);
            if (clazz == String.class) {
                return false;
            }
            return !Comparable.class.isAssignableFrom(clazz);
        }

        @Keep
        @KeepPublicProtectedClassMembers
        protected static class TableModelWrapper<M extends TableModel>
        extends DefaultRowSorter.ModelWrapper<M, Object> {
            private final M a;

            public TableModelWrapper(M m) {
                this.a = (TableModel)Objects.requireNonNull(m, "tableModel");
            }

            @Override
            public M getModel() {
                return this.a;
            }

            @Override
            public int getColumnCount() {
                return this.a.getColumnCount();
            }

            @Override
            public int getRowCount() {
                return this.a.getRowCount();
            }

            @Override
            public Object getValueAt(int n, int n2) {
                return this.a.getValueAt(n, n2);
            }

            @Override
            public String getStringValueAt(int n, int n2) {
                if (this.a instanceof TextAwareTableModel) {
                    return ((TextAwareTableModel)this.a).getTextValueAt(n, n2);
                }
                return super.getStringValueAt(n, n2);
            }

            @Override
            public Object getIdentifier(int n) {
                if (this.a instanceof ContentTableModel) {
                    return ((ContentTableModel)this.a).getRowAt(n);
                }
                return n;
            }
        }
    }
}

