/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.view.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import net.astah.golf.widget.swing.SwingIconRegistry;
import net.astah.jomt.jutil.SwingInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class SwingFontChooser
extends JComponent {
    private static final Logger a = LoggerFactory.getLogger(SwingFontChooser.class);
    private static final long serialVersionUID = 1888473582855156672L;
    public static final int OK = 0;
    public static final int CANCEL = 1;
    public static final int ERROR = -1;
    private static final int[] b = new int[]{0, 1, 2, 3};
    private static final Font c = new Font("Dialog", 0, (int)Math.ceil(10.0 * SwingIconRegistry.getDefaultScale()));
    private static final String[] d = new String[]{"6", "8", "9", "10", "12", "14", "16", "18", "20", "24", "26", "28", "32", "36", "40", "44", "48", "54", "60", "66", "72", "80", "88", "96"};
    public static final int MIN_SIZE = 6;
    public static final int MAX_SIZE = 96;
    private int minSize = 6;
    private int maxSize = 96;
    private static final String[] e = new String[]{"Dialog", "DialogInput", "Serif", "SansSerif", "Monospaced"};
    private static ResourceBundle f;
    private static String[] g;
    protected int dialogResultValue = -1;
    private JTextField fontNameTextField = null;
    private JTextField fontStyleTextField = null;
    private JTextField fontSizeTextField = null;
    private JList fontNameList = null;
    private JList leastFontNameList = null;
    private JList fontStyleList = null;
    private JList fontSizeList = null;
    private JPanel fontNamePanel = null;
    private JPanel fontStylePanel = null;
    private JPanel fontSizePanel = null;
    private JPanel samplePanel = null;
    private JPanel contentsPanel = null;
    private JCheckBox underlinedCheckBox = null;
    private JCheckBox struckThroughCheckBox = null;
    private JPanel fontNameListPanel = null;
    private JPanel fontStyleListPanel = null;
    private JPanel fontSizeListPanel = null;
    private JTextField fontNameListTextField = null;
    private JScrollPane fontNameListScrollPane = null;
    private JScrollPane leastFontNameListScrollPane = null;
    private JScrollPane fontStyleListScrollPane = null;
    private JScrollPane fontSizeListScrollPane = null;
    private JPanel fontNameLabelPanel = null;
    private JPanel fontStyleLabelPanel = null;
    private JPanel fontSizeLabelPanel = null;
    private JCheckBox allAvailableFontsCheckBox = null;
    private JCheckBox autoNameCheckBox = null;
    private JCheckBox autoStyleCheckBox = null;
    private JCheckBox autoSizeCheckBox = null;
    private boolean showAutoNameCheckBox = true;
    private boolean showAutoStyleCheckBox = true;
    private boolean showAutoSizeCheckBox = true;
    private JTextField sampleText = null;
    private boolean withoutStyle = false;
    private boolean withLines = false;
    private boolean underlined = false;
    private boolean struckthrough = false;
    private static boolean h;
    private boolean autoName = false;
    private boolean autoStyle = false;
    private boolean autoSize = false;
    private String selectedFontName = "Serif";
    private String autoFontName = "Dialog";
    private String autoFontStyle = "PLAIN";
    private int autoFontSize = 12;
    private boolean showInitialValue = false;
    private String sampleString = SwingFontChooser.getResourceStr("font_chooser.sample_string.label");
    private SwingFontChooser thisFontChooser = null;
    JPanel selectPanel = null;
    private String[] fontFamilyNames = null;
    private static Map i;

    public int getCancel() {
        return 1;
    }

    public int getError() {
        return -1;
    }

    protected static String getResourceStr(String string) {
        String string2;
        if (f == null) {
            f = ResourceBundle.getBundle("net.astah.jomt.resource.FontChooser");
        }
        if ((string2 = f.getString(string)) == null) {
            return string;
        }
        return string2;
    }

    protected String[] getFontStyleNames() {
        if (g == null) {
            int n = 0;
            g = new String[4];
            SwingFontChooser.g[n++] = SwingFontChooser.getResourceStr("font_chooser.plain.label");
            SwingFontChooser.g[n++] = SwingFontChooser.getResourceStr("font_chooser.bold.label");
            SwingFontChooser.g[n++] = SwingFontChooser.getResourceStr("font_chooser.italic.label");
            SwingFontChooser.g[n++] = SwingFontChooser.getResourceStr("font_chooser.bolditalic.label");
        }
        return g;
    }

    public void setAllAvailableFonts(boolean bl) {
        h = bl;
        this.updateFontNameListPanelForSet();
    }

    public void setAutoName(boolean bl) {
        this.autoName = bl;
        this.updateFontNameListPanel();
    }

    public boolean isAutoName() {
        return this.autoName;
    }

    public void setAutoStyle(boolean bl) {
        this.autoStyle = bl;
        this.c();
    }

    public boolean isAutoStyle() {
        return this.autoStyle;
    }

    public void setAutoSize(boolean bl) {
        this.autoSize = bl;
        this.d();
    }

    public boolean isAutoSize() {
        return this.autoSize;
    }

    public void setWithLines(boolean bl) {
        this.withLines = bl;
    }

    public void setAutoFontName(String string) {
        this.autoFontName = string;
    }

    public void setAutoFontStyle(String string) {
        this.autoFontStyle = string;
    }

    public void setAutoFontSize(int n) {
        this.autoFontSize = n;
    }

    public void setWithoutStyle(boolean bl) {
        this.withoutStyle = bl;
    }

    public void initialize(int n, int n2) {
        this.minSize = n;
        this.maxSize = n2;
        this.selectPanel = new JPanel();
        this.selectPanel.setLayout(new BoxLayout(this.selectPanel, 0));
        this.selectPanel.add(this.getFontNamePanel());
        this.selectPanel.add(this.getFontStylePanel());
        this.selectPanel.add(this.getFontSizePanel());
        if (this.withLines) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.add(this.i());
            jPanel.add(this.j());
            this.selectPanel.add(jPanel);
        }
        this.selectPanel.setEnabled(true);
        if (this.contentsPanel == null) {
            this.contentsPanel = new JPanel();
            this.contentsPanel.setLayout(new GridLayout(2, 1));
            this.contentsPanel.add((Component)this.selectPanel, "North");
            this.contentsPanel.add((Component)this.getSamplePanel(), "Center");
        }
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.contentsPanel);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.thisFontChooser = this;
    }

    public void initialize() {
        this.initialize(6, 96);
    }

    public JTextField getFontNameTextField() {
        if (this.fontNameTextField == null) {
            this.fontNameTextField = new JTextField();
            this.fontNameTextField.setEditable(false);
            this.fontNameTextField.addFocusListener(new e(this.fontNameTextField));
            this.fontNameTextField.addKeyListener(new f(this.getFontNameList()));
            this.fontNameTextField.getDocument().addDocumentListener(new c(this.getFontNameList()));
        }
        return this.fontNameTextField;
    }

    public JTextField getFontStyleTextField() {
        if (this.fontStyleTextField == null) {
            this.fontStyleTextField = new JTextField();
            this.fontStyleTextField.setEditable(false);
            this.fontStyleTextField.addFocusListener(new e(this.fontStyleTextField));
            this.fontStyleTextField.addKeyListener(new f(this.getFontStyleList()));
            this.fontStyleTextField.getDocument().addDocumentListener(new c(this.getFontStyleList()));
        }
        return this.fontStyleTextField;
    }

    public JTextField getFontSizeTextField() {
        if (this.fontSizeTextField == null) {
            this.fontSizeTextField = new JTextField();
            this.fontSizeTextField.addFocusListener(new e(this.fontSizeTextField));
            this.fontSizeTextField.addKeyListener(new f(this.getFontSizeList()));
            this.fontSizeTextField.getDocument().addDocumentListener(new c(this.getFontSizeList()));
        }
        return this.fontSizeTextField;
    }

    public JList getFontNameList() {
        if (this.fontNameList == null) {
            String[] stringArray = this.getDomesticFontFamilyNames();
            this.fontNameList = new JList<String>(stringArray);
            this.fontNameList.setSelectionMode(0);
            this.fontNameList.addListSelectionListener(new d(this.getFontNameTextField()));
            if (this.selectedFontName != null) {
                String[] stringArray2 = this.getFontFamilyNames();
                block0: for (int k = 0; k < stringArray2.length; ++k) {
                    if (stringArray2[k].toLowerCase().equals(this.selectedFontName.toLowerCase())) {
                        this.fontNameList.setSelectedIndex(k);
                        break;
                    }
                    if (k != stringArray2.length - 1) continue;
                    this.selectedFontName = "Dialog";
                    for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                        if (!stringArray2[i2].toLowerCase().equals(this.selectedFontName.toLowerCase())) continue;
                        this.fontNameList.setSelectedIndex(i2);
                        continue block0;
                    }
                }
            } else {
                this.fontNameList.setSelectedIndex(0);
            }
            this.fontNameList.setFont(c);
            this.fontNameList.setFocusable(false);
        }
        return this.fontNameList;
    }

    public JList getLeastFontNameList() {
        if (this.leastFontNameList == null) {
            this.leastFontNameList = new JList<String>(this.getLeastFontNames());
            this.leastFontNameList.setSelectionMode(0);
            this.leastFontNameList.addListSelectionListener(new d(this.getFontNameTextField()));
            if (this.autoName) {
                String[] stringArray = this.getLeastFontNames();
                for (int k = 0; k < stringArray.length; ++k) {
                    if (!stringArray[k].toLowerCase().equals(this.autoFontName.toLowerCase())) continue;
                    this.leastFontNameList.setSelectedIndex(k);
                    break;
                }
            } else if (this.selectedFontName != null) {
                String[] stringArray = this.getLeastFontNames();
                for (int k = 0; k < stringArray.length; ++k) {
                    if (!stringArray[k].toLowerCase().equals(this.selectedFontName.toLowerCase())) continue;
                    this.leastFontNameList.setSelectedIndex(k);
                    break;
                }
            } else {
                this.leastFontNameList.setSelectedIndex(0);
            }
            this.leastFontNameList.setFont(c);
            this.leastFontNameList.setFocusable(false);
        }
        return this.leastFontNameList;
    }

    public JList getFontStyleList() {
        if (this.fontStyleList == null) {
            this.fontStyleList = new JList<String>(this.getFontStyleNames());
            this.fontStyleList.setSelectionMode(0);
            this.fontStyleList.addListSelectionListener(new d(this.getFontStyleTextField()));
            this.fontStyleList.setSelectedIndex(0);
            this.fontStyleList.setFont(c);
            this.fontStyleList.setFocusable(false);
        }
        return this.fontStyleList;
    }

    public JList getFontSizeList() {
        if (this.fontSizeList == null) {
            this.fontSizeList = new JList<String>(this.a());
            this.fontSizeList.setSelectionMode(0);
            this.fontSizeList.addListSelectionListener(new d(this.getFontSizeTextField()));
            this.fontSizeList.setSelectedIndex(0);
            this.fontSizeList.setFont(c);
            this.fontSizeList.setFocusable(false);
        }
        return this.fontSizeList;
    }

    public String getSelectedFontName() {
        String string = null;
        int n = this.getFontNameList().getSelectedIndex();
        String[] stringArray = this.getFontFamilyNames();
        string = stringArray[n];
        return string;
    }

    public int getSelectedFontStyle() {
        int n = this.getFontStyleList().getSelectedIndex();
        return b[n];
    }

    public int getSelectedFontSize() {
        int n = 1;
        String string = this.getFontSizeTextField().getText();
        while (true) {
            try {
                n = Integer.parseInt(string);
                if (n > 0) break;
                string = (String)this.getFontSizeList().getSelectedValue();
                this.getFontSizeTextField().setText(string);
                n = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                string = (String)this.getFontSizeList().getSelectedValue();
                this.getFontSizeTextField().setText(string);
                continue;
            }
            break;
        }
        return n;
    }

    public Font getSelectedFont() {
        String string = this.getSelectedFontName();
        int n = this.getSelectedFontStyle();
        int n2 = this.getSelectedFontSize();
        String string2 = string + "," + String.valueOf(n) + "," + String.valueOf(n2);
        Font font = (Font)i.get(string2);
        if (font == null) {
            font = new Font(string, n, n2);
            i.put(string2, font);
        }
        return font;
    }

    public boolean isUnderlined() {
        if (this.withLines) {
            return this.underlinedCheckBox.isSelected();
        }
        return false;
    }

    public boolean isStruckThrough() {
        if (this.withLines) {
            return this.struckThroughCheckBox.isSelected();
        }
        return false;
    }

    public void setSelectedFontName(String string) {
        String[] stringArray;
        this.selectedFontName = string;
        JList jList = null;
        if (!this.a(string) && !h) {
            this.setAllAvailableFonts(true);
            this.e().setSelected(true);
        }
        if (h) {
            stringArray = this.getFontFamilyNames();
            jList = this.getFontNameList();
        } else {
            stringArray = this.getLeastFontNames();
            jList = this.getLeastFontNameList();
        }
        for (int k = 0; k < stringArray.length; ++k) {
            if (!stringArray[k].toLowerCase().equals(string.toLowerCase())) continue;
            jList.setSelectedIndex(k);
            break;
        }
        this.updateSampleFont();
    }

    private boolean a(String string) {
        String[] stringArray = this.getLeastFontNames();
        for (int k = 0; k < stringArray.length; ++k) {
            if (!stringArray[k].toLowerCase().equals(string.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public void setSelectedFontStyle(int n) {
        for (int k = 0; k < b.length; ++k) {
            if (b[k] != n) continue;
            this.getFontStyleList().setSelectedIndex(k);
            break;
        }
        this.updateSampleFont();
    }

    public void setSelectedFontStyle(String string) {
        int n = 0;
        if (string.equalsIgnoreCase("PLAIN")) {
            n = 0;
        } else if (string.equalsIgnoreCase("BOLD")) {
            n = 1;
        } else if (string.equalsIgnoreCase("ITALIC")) {
            n = 2;
        } else if (string.equalsIgnoreCase("BOLDITALIC")) {
            n = 3;
        }
        this.setSelectedFontStyle(n);
    }

    public void setSelectedFontSize(int n) {
        String string = String.valueOf(n);
        String[] stringArray = this.a();
        for (int k = 0; k < stringArray.length; ++k) {
            if (!stringArray[k].equals(string)) continue;
            this.getFontSizeList().setSelectedIndex(k);
            break;
        }
        this.getFontSizeTextField().setText(string);
        this.updateSampleFont();
    }

    public void setUnderlined(boolean bl) {
        this.underlined = bl;
        this.updateSampleFont();
    }

    public void setStruckthrough(boolean bl) {
        this.struckthrough = bl;
        this.updateSampleFont();
    }

    public void setSelectedFont(Font font) {
        this.setSelectedFontName(font.getFamily(Locale.ENGLISH));
        this.setSelectedFontStyle(font.getStyle());
        this.setSelectedFontSize(font.getSize());
    }

    public int showDialog(Component component, String string) {
        this.dialogResultValue = -1;
        JDialog jDialog = this.createDialog(component, string);
        jDialog.addWindowListener(new b());
        jDialog.show();
        jDialog.dispose();
        jDialog = null;
        return this.dialogResultValue;
    }

    protected JDialog createDialog(Component component, String string) {
        Frame frame = component instanceof Frame ? (Frame)component : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, component);
        JDialog jDialog = new JDialog(frame, SwingFontChooser.getResourceStr("font_chooser.select_font.label"), true);
        DialogOKAction dialogOKAction = new DialogOKAction(jDialog, string);
        DialogCancelAction dialogCancelAction = new DialogCancelAction(jDialog);
        JButton jButton = new JButton(dialogOKAction);
        jButton.setFont(c);
        JButton jButton2 = new JButton(dialogCancelAction);
        jButton2.setFont(c);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.setBorder(BorderFactory.createEmptyBorder(25, 0, 10, 10));
        ActionMap actionMap = jPanel.getActionMap();
        actionMap.put(dialogCancelAction.getValue("Default"), dialogCancelAction);
        actionMap.put(dialogOKAction.getValue("Default"), dialogOKAction);
        InputMap inputMap = jPanel.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), dialogCancelAction.getValue("Default"));
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), dialogOKAction.getValue("Default"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        jDialog.getContentPane().add((Component)this, "Center");
        jDialog.getContentPane().add((Component)jPanel2, "East");
        jDialog.pack();
        jDialog.setLocationRelativeTo(frame);
        jDialog.setResizable(true);
        return jDialog;
    }

    protected void updateSampleFont() {
        if (!this.b()) {
            return;
        }
        Font font = this.getSelectedFont();
        Font font2 = new Font(font.getName(), font.getStyle(), (int)Math.ceil(font.getSize()));
        this.getSampleTextField().setFont(font2);
    }

    private String[] a() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int k = 0; k < d.length; ++k) {
            String string = d[k];
            if (!this.b(string)) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }

    private boolean b() {
        return this.b(this.getFontSizeTextField().getText());
    }

    private boolean b(String string) {
        try {
            int n = Integer.parseInt(string);
            if (n >= this.minSize && n <= this.maxSize) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    protected JPanel getFontNamePanel() {
        if (this.fontNamePanel == null) {
            this.fontNamePanel = new JPanel();
            this.fontNamePanel.setLayout(new BorderLayout());
            this.fontNamePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            if (this.fontNameListScrollPane == null) {
                this.fontNameListScrollPane = new JScrollPane();
                this.fontNameListScrollPane.setViewportView(this.getFontNameList());
            }
            this.fontNameListScrollPane.getVerticalScrollBar().setFocusable(false);
            this.fontNameListScrollPane.setVerticalScrollBarPolicy(22);
            if (this.leastFontNameListScrollPane == null) {
                this.leastFontNameListScrollPane = new JScrollPane();
                this.leastFontNameListScrollPane.setViewportView(this.getLeastFontNameList());
            }
            this.leastFontNameListScrollPane.getVerticalScrollBar().setFocusable(false);
            this.leastFontNameListScrollPane.setVerticalScrollBarPolicy(22);
            JLabel jLabel = new JLabel(SwingFontChooser.getResourceStr("font_chooser.font_name.label"));
            jLabel.setHorizontalAlignment(2);
            jLabel.setHorizontalTextPosition(2);
            jLabel.setLabelFor(this.getFontNameTextField());
            jLabel.setDisplayedMnemonic('F');
            JCheckBox jCheckBox = null;
            if (this.showAutoNameCheckBox) {
                jCheckBox = this.f();
            }
            if (this.fontNameLabelPanel == null) {
                this.fontNameLabelPanel = new JPanel();
                this.fontNameLabelPanel.setLayout(new BoxLayout(this.fontNameLabelPanel, 0));
                if (this.showAutoNameCheckBox) {
                    this.fontNameLabelPanel.add((Component)jLabel, "West");
                    this.fontNameLabelPanel.add((Component)jCheckBox, "East");
                } else {
                    this.fontNameLabelPanel.add(jLabel);
                }
            }
            if (this.fontNameListPanel == null) {
                this.fontNameListPanel = new JPanel();
                this.fontNameListPanel.setLayout(new BorderLayout());
                if (this.fontNameListTextField == null) {
                    this.fontNameListTextField = this.getFontNameTextField();
                }
                this.fontNameListPanel.add((Component)this.fontNameListTextField, "North");
                if (h) {
                    this.fontNameListPanel.add((Component)this.fontNameListScrollPane, "Center");
                } else {
                    this.fontNameListPanel.add((Component)this.leastFontNameListScrollPane, "Center");
                }
            }
            this.a(this.fontNameListPanel, this.autoName);
            JCheckBox jCheckBox2 = this.e();
            this.fontNamePanel.add((Component)this.fontNameLabelPanel, "North");
            this.fontNamePanel.add((Component)this.fontNameListPanel, "Center");
            this.fontNamePanel.add((Component)jCheckBox2, "South");
        }
        return this.fontNamePanel;
    }

    protected void updateFontNameListPanel() {
        if (this.fontNameListPanel != null) {
            if (this.autoName || this.showInitialValue) {
                this.setSelectedFontName(this.autoFontName);
            }
            this.a(this.fontNameListPanel, this.autoName);
            this.fontNameListPanel.updateUI();
        }
    }

    protected void updateFontNameListPanelForSet() {
        if (this.fontNameListPanel != null) {
            if (h) {
                this.fontNameListPanel.remove(this.leastFontNameListScrollPane);
                this.fontNameListPanel.add((Component)this.fontNameListScrollPane, "Center");
                if (this.autoName) {
                    this.setSelectedFontName(this.autoFontName);
                } else {
                    this.setSelectedFontName(this.selectedFontName);
                }
            } else {
                this.fontNameListPanel.remove(this.fontNameListScrollPane);
                this.fontNameListPanel.add((Component)this.leastFontNameListScrollPane, "Center");
                if (this.a(this.selectedFontName)) {
                    this.setSelectedFontName(this.selectedFontName);
                } else {
                    this.setSelectedFontName("Dialog");
                }
            }
            this.a(this.fontNameListPanel, this.autoName);
            this.fontNameListPanel.updateUI();
        }
    }

    protected JPanel getFontStylePanel() {
        if (this.fontStylePanel == null) {
            this.fontStylePanel = new JPanel();
            this.fontStylePanel.setLayout(new BorderLayout());
            this.fontStylePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            if (this.fontStyleListScrollPane == null) {
                this.fontStyleListScrollPane = new JScrollPane(this.getFontStyleList());
                this.fontStyleListScrollPane.getVerticalScrollBar().setFocusable(false);
                this.fontStyleListScrollPane.setVerticalScrollBarPolicy(22);
            }
            JLabel jLabel = new JLabel(SwingFontChooser.getResourceStr("font_chooser.font_style.label"));
            jLabel.setHorizontalAlignment(2);
            jLabel.setHorizontalTextPosition(2);
            jLabel.setLabelFor(this.getFontStyleTextField());
            jLabel.setDisplayedMnemonic('Y');
            JCheckBox jCheckBox = null;
            if (this.showAutoStyleCheckBox) {
                jCheckBox = this.g();
            }
            if (this.fontStyleLabelPanel == null) {
                this.fontStyleLabelPanel = new JPanel();
                this.fontStyleLabelPanel.setLayout(new BoxLayout(this.fontStyleLabelPanel, 0));
                if (this.showAutoStyleCheckBox) {
                    this.fontStyleLabelPanel.add((Component)jLabel, "West");
                    this.fontStyleLabelPanel.add((Component)jCheckBox, "East");
                } else {
                    this.fontStyleLabelPanel.add(jLabel);
                }
            }
            if (this.fontStyleListPanel == null) {
                this.fontStyleListPanel = new JPanel();
                this.fontStyleListPanel.setLayout(new BorderLayout());
                this.fontStyleListPanel.add((Component)this.getFontStyleTextField(), "North");
                this.fontStyleListPanel.add((Component)this.fontStyleListScrollPane, "Center");
            }
            this.fontStylePanel.add((Component)this.fontStyleLabelPanel, "North");
            this.fontStylePanel.add((Component)this.fontStyleListPanel, "Center");
        }
        this.a(this.fontStylePanel, this.withoutStyle);
        this.a(this.fontStyleListPanel, this.autoStyle);
        return this.fontStylePanel;
    }

    private void c() {
        if (this.fontStyleListPanel != null) {
            this.a(this.fontStyleListPanel, this.autoStyle);
            if (this.showInitialValue) {
                this.setSelectedFontStyle(this.autoFontStyle);
            }
            this.fontStyleListPanel.updateUI();
        }
    }

    private void a(JComponent jComponent, boolean bl) {
        Component[] componentArray = jComponent.getComponents();
        for (int k = 0; k < componentArray.length; ++k) {
            Component component = componentArray[k];
            if (bl) {
                component.setEnabled(false);
                if (component instanceof JScrollPane) {
                    ((JScrollPane)component).setWheelScrollingEnabled(false);
                }
            } else {
                component.setEnabled(true);
                if (component instanceof JScrollPane) {
                    ((JScrollPane)component).setWheelScrollingEnabled(true);
                }
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent2 = (JComponent)component;
            this.a(jComponent2, bl);
        }
    }

    protected JPanel getFontSizePanel() {
        if (this.fontSizePanel == null) {
            this.fontSizePanel = new JPanel();
            this.fontSizePanel.setLayout(new BorderLayout());
            this.fontSizePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            if (this.fontSizeListScrollPane == null) {
                this.fontSizeListScrollPane = new JScrollPane(this.getFontSizeList());
                this.fontSizeListScrollPane.getVerticalScrollBar().setFocusable(false);
                this.fontSizeListScrollPane.setVerticalScrollBarPolicy(22);
            }
            JLabel jLabel = new JLabel(SwingFontChooser.getResourceStr("font_chooser.font_size.label"));
            jLabel.setHorizontalAlignment(2);
            jLabel.setHorizontalTextPosition(2);
            jLabel.setLabelFor(this.getFontSizeTextField());
            jLabel.setDisplayedMnemonic('S');
            JCheckBox jCheckBox = null;
            if (this.showAutoSizeCheckBox) {
                jCheckBox = this.h();
            }
            if (this.fontSizeLabelPanel == null) {
                this.fontSizeLabelPanel = new JPanel();
                this.fontSizeLabelPanel.setLayout(new BoxLayout(this.fontSizeLabelPanel, 0));
                if (this.showAutoSizeCheckBox) {
                    this.fontSizeLabelPanel.add((Component)jLabel, "West");
                    this.fontSizeLabelPanel.add((Component)jCheckBox, "East");
                } else {
                    this.fontSizeLabelPanel.add(jLabel);
                }
            }
            if (this.fontSizeListPanel == null) {
                this.fontSizeListPanel = new JPanel();
                this.fontSizeListPanel.setLayout(new BorderLayout());
                this.fontSizeListPanel.add((Component)this.getFontSizeTextField(), "North");
                this.fontSizeListPanel.add((Component)this.fontSizeListScrollPane, "Center");
            }
            this.a(this.fontSizeListPanel, this.autoSize);
            this.fontSizePanel.add((Component)this.fontSizeLabelPanel, "North");
            this.fontSizePanel.add((Component)this.fontSizeListPanel, "Center");
        }
        int n = this.getSelectedFontSize();
        this.getFontSizeList().setListData(this.a());
        this.setSelectedFontSize(n);
        return this.fontSizePanel;
    }

    private void d() {
        if (this.fontSizeListPanel != null) {
            this.a(this.fontSizeListPanel, this.autoSize);
            if (this.showInitialValue) {
                this.setSelectedFontSize(this.autoFontSize);
            }
            this.fontSizeListPanel.updateUI();
        }
    }

    private JCheckBox e() {
        if (this.allAvailableFontsCheckBox == null) {
            this.allAvailableFontsCheckBox = new JCheckBox(SwingFontChooser.getResourceStr("font_chooser.allfont.label"), h);
            this.allAvailableFontsCheckBox.addItemListener(new a());
        }
        return this.allAvailableFontsCheckBox;
    }

    private JCheckBox f() {
        if (this.autoNameCheckBox == null) {
            this.autoNameCheckBox = new JCheckBox(SwingFontChooser.getResourceStr("font_chooser.auto.label"), this.autoName);
            this.autoNameCheckBox.addItemListener(new a());
        }
        return this.autoNameCheckBox;
    }

    private JCheckBox g() {
        if (this.autoStyleCheckBox == null) {
            this.autoStyleCheckBox = new JCheckBox(SwingFontChooser.getResourceStr("font_chooser.auto.label"), this.autoStyle);
            this.autoStyleCheckBox.addItemListener(new a());
        }
        return this.autoStyleCheckBox;
    }

    private JCheckBox h() {
        if (this.autoSizeCheckBox == null) {
            this.autoSizeCheckBox = new JCheckBox(SwingFontChooser.getResourceStr("font_chooser.auto.label"), this.autoSize);
            this.autoSizeCheckBox.addItemListener(new a());
        }
        return this.autoSizeCheckBox;
    }

    private JCheckBox i() {
        if (this.underlinedCheckBox == null) {
            this.underlinedCheckBox = new JCheckBox(SwingFontChooser.getResourceStr("font_chooser.underlined.label"), this.underlined);
        }
        return this.underlinedCheckBox;
    }

    private JCheckBox j() {
        if (this.struckThroughCheckBox == null) {
            this.struckThroughCheckBox = new JCheckBox(SwingFontChooser.getResourceStr("font_chooser.struckThrough.label"), this.struckthrough);
        }
        return this.struckThroughCheckBox;
    }

    protected JPanel getSamplePanel() {
        if (this.samplePanel == null) {
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), SwingFontChooser.getResourceStr("font_chooser.sample.label"));
            Border border = BorderFactory.createEmptyBorder(5, 10, 10, 10);
            CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(titledBorder, border);
            this.samplePanel = new JPanel();
            this.samplePanel.setLayout(new BorderLayout());
            this.samplePanel.setBorder(compoundBorder);
            this.samplePanel.add((Component)this.getSampleTextField(), "Center");
        }
        return this.samplePanel;
    }

    public void setSampleString(String string) {
        this.sampleString = string != null && !string.trim().equals("") ? string : SwingFontChooser.getResourceStr("font_chooser.sample_string.label");
        if (this.sampleText != null) {
            this.sampleText.setText(this.sampleString);
        }
    }

    private String k() {
        if (this.sampleString != null) {
            return this.sampleString;
        }
        return SwingFontChooser.getResourceStr("font_chooser.sample_string.label");
    }

    protected JTextField getSampleTextField() {
        if (this.sampleText == null) {
            Border border = BorderFactory.createLoweredBevelBorder();
            this.sampleText = new JTextField(this.k());
            this.sampleText.setBorder(border);
            this.sampleText.setEditable(true);
        }
        return this.sampleText;
    }

    protected String[] getFontFamilyNames() {
        if (this.fontFamilyNames == null) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.fontFamilyNames = graphicsEnvironment.getAvailableFontFamilyNames(Locale.ENGLISH);
        }
        return this.fontFamilyNames;
    }

    protected String[] getDomesticFontFamilyNames() {
        String[] stringArray = this.getFontFamilyNames();
        Locale locale = Locale.getDefault();
        if (locale.getLanguage().equals(new Locale(Locale.ENGLISH.getLanguage(), "", "").getLanguage())) {
            return stringArray;
        }
        String[] stringArray2 = (String[])stringArray.clone();
        for (int k = 0; k < stringArray.length; ++k) {
            String string;
            String string2 = stringArray[k];
            Font font = new Font(string2, 0, (int)Math.ceil(12.0 * SwingIconRegistry.getDefaultScale()));
            stringArray2[k] = string = font.getFamily();
        }
        return stringArray2;
    }

    protected String[] getLeastFontNames() {
        return e;
    }

    public void finalizeChooser() {
        if (this.showAutoNameCheckBox) {
            this.fontNameLabelPanel.remove(this.autoNameCheckBox);
        }
        this.autoNameCheckBox = null;
        this.fontNamePanel.remove(this.fontNameLabelPanel);
        this.fontNameLabelPanel = null;
        this.fontNamePanel.remove(this.allAvailableFontsCheckBox);
        this.allAvailableFontsCheckBox = null;
        if (this.showAutoStyleCheckBox) {
            this.fontStyleLabelPanel.remove(this.autoStyleCheckBox);
        }
        this.autoStyleCheckBox = null;
        this.fontStylePanel.remove(this.fontStyleLabelPanel);
        this.fontStyleLabelPanel = null;
        if (this.showAutoSizeCheckBox) {
            this.fontSizeLabelPanel.remove(this.autoSizeCheckBox);
        }
        this.autoSizeCheckBox = null;
        this.fontSizePanel.remove(this.fontSizeLabelPanel);
        this.fontSizeLabelPanel = null;
        this.selectPanel.remove(this.fontNamePanel);
        this.fontNamePanel = null;
        this.selectPanel.remove(this.fontStylePanel);
        this.fontStylePanel = null;
        this.selectPanel.remove(this.fontSizePanel);
        this.fontSizePanel = null;
        this.contentsPanel.remove(this.selectPanel);
        this.selectPanel = null;
        this.thisFontChooser.remove(this.contentsPanel);
        this.contentsPanel = null;
        this.sampleText = null;
        this.samplePanel = null;
        this.sampleString = null;
    }

    public void setShowAutoNameCheckBox(boolean bl) {
        this.showAutoNameCheckBox = bl;
    }

    public void setShowAutoSizeCheckBox(boolean bl) {
        this.showAutoSizeCheckBox = bl;
    }

    public void setShowAutoStyleCheckBox(boolean bl) {
        this.showAutoStyleCheckBox = bl;
    }

    public void setShowInitialValue(boolean bl) {
        this.showInitialValue = bl;
    }

    static {
        g = null;
        h = false;
        i = new HashMap();
    }

    protected class a
    implements ItemListener {
        protected a() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            if (itemSelectable == SwingFontChooser.this.autoNameCheckBox) {
                SwingFontChooser.this.setAutoName(SwingFontChooser.this.autoNameCheckBox.isSelected());
            } else if (itemSelectable == SwingFontChooser.this.autoStyleCheckBox) {
                SwingFontChooser.this.setAutoStyle(SwingFontChooser.this.autoStyleCheckBox.isSelected());
            } else if (itemSelectable == SwingFontChooser.this.autoSizeCheckBox) {
                SwingFontChooser.this.setAutoSize(SwingFontChooser.this.autoSizeCheckBox.isSelected());
            } else if (itemSelectable == SwingFontChooser.this.allAvailableFontsCheckBox) {
                SwingFontChooser.this.setAllAvailableFonts(SwingFontChooser.this.allAvailableFontsCheckBox.isSelected());
            }
        }
    }

    protected class DialogCancelAction
    extends AbstractAction {
        private static final long serialVersionUID = -1167059794022710195L;
        private JDialog dialog;

        protected DialogCancelAction(JDialog jDialog) {
            this.dialog = jDialog;
            this.putValue("Default", "Cancel");
            this.putValue("Name", SwingFontChooser.getResourceStr("font_chooser.cancel.label"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SwingFontChooser.this.dialogResultValue = 1;
            this.dialog.hide();
            SwingFontChooser.this.finalizeChooser();
        }
    }

    protected class DialogOKAction
    extends AbstractAction {
        private static final long serialVersionUID = 6642837116372216373L;
        private String errorMsg;
        private JDialog dialog;

        protected DialogOKAction(JDialog jDialog, String string) {
            this.dialog = jDialog;
            this.errorMsg = string;
            this.putValue("Default", "OK");
            this.putValue("Name", SwingFontChooser.getResourceStr("font_chooser.ok.label"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!SwingFontChooser.this.b()) {
                MessageFormat messageFormat = new MessageFormat(this.errorMsg);
                String string = messageFormat.format(new String[]{String.valueOf(SwingFontChooser.this.minSize), String.valueOf(SwingFontChooser.this.maxSize)});
                JOptionPane.showMessageDialog(this.dialog, string, "Alert", 0);
                return;
            }
            SwingFontChooser.this.dialogResultValue = 0;
            this.dialog.hide();
            SwingFontChooser.this.finalizeChooser();
        }
    }

    protected class c
    implements DocumentListener {
        JList a;

        public c(JList jList) {
            this.a = jList;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.a(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.a(documentEvent);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.a(documentEvent);
        }

        private void a(DocumentEvent documentEvent) {
            String string = "";
            try {
                Document document = documentEvent.getDocument();
                string = document.getText(0, document.getLength());
            }
            catch (BadLocationException badLocationException) {
                a.error("error has occurred", (Throwable)badLocationException);
            }
            if (string.length() > 0) {
                int n = this.a.getNextMatch(string, 0, Position.Bias.Forward);
                if (n < 0) {
                    n = 0;
                }
                this.a.ensureIndexIsVisible(n);
                String string2 = this.a.getModel().getElementAt(n).toString();
                if (string.equalsIgnoreCase(string2) && n != this.a.getSelectedIndex()) {
                    a a2 = new a(n);
                    SwingInvoker.runInEDT(a2);
                }
            }
        }

        public class a
        implements Runnable {
            private int b;

            public a(int n) {
                this.b = n;
            }

            @Override
            public void run() {
                c.this.a.setSelectedIndex(this.b);
            }
        }
    }

    protected class f
    extends KeyAdapter {
        private JList b;

        public f(JList jList) {
            this.b = jList;
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n = this.b.getSelectedIndex();
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    n = this.b.getSelectedIndex() - 1;
                    if (n < 0) {
                        n = 0;
                    }
                    this.b.setSelectedIndex(n);
                    break;
                }
                case 40: {
                    int n2 = this.b.getModel().getSize();
                    n = this.b.getSelectedIndex() + 1;
                    if (n >= n2) {
                        n = n2 - 1;
                    }
                    this.b.setSelectedIndex(n);
                    break;
                }
            }
        }
    }

    protected class e
    extends FocusAdapter {
        private JTextComponent b;

        public e(JTextComponent jTextComponent) {
            this.b = jTextComponent;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.b.selectAll();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.b.select(0, 0);
            SwingFontChooser.this.updateSampleFont();
        }
    }

    protected class d
    implements ListSelectionListener {
        private JTextComponent b;

        d(JTextComponent jTextComponent) {
            this.b = jTextComponent;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                Object object;
                JList jList = (JList)listSelectionEvent.getSource();
                String string = (String)jList.getSelectedValue();
                if (jList == SwingFontChooser.this.fontNameList) {
                    object = new Font(string, 0, (int)Math.ceil(12.0 * SwingIconRegistry.getDefaultScale()));
                    SwingFontChooser.this.selectedFontName = ((Font)object).getFamily(Locale.ENGLISH);
                }
                if (!((String)(object = this.b.getText())).equalsIgnoreCase(string)) {
                    this.b.setText(string);
                    this.b.selectAll();
                    this.b.requestFocus();
                }
                SwingFontChooser.this.updateSampleFont();
            }
        }
    }

    class b
    extends WindowAdapter {
        b() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            SwingFontChooser.this.dialogResultValue = 1;
            SwingFontChooser.this.finalizeChooser();
        }
    }
}

