/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.view.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import net.astah.golf.view.swing.IPropertyDescriptor;
import net.astah.golf.view.swing.IPropertySource;
import net.astah.golf.view.swing.IPropertySourceProvider;
import net.astah.golf.view.swing.LineWrappingTableCellRenderer;
import net.astah.golf.widget.swing.IColorProvider;
import net.astah.golf.widget.swing.IFontProvider;
import net.astah.golf.widget.swing.ILabelProvider;
import proguard.annotation.Keep;
import proguard.annotation.KeepImplementations;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
@KeepImplementations
public abstract class PropertySourceCellRenderer
extends LineWrappingTableCellRenderer {
    private static final long serialVersionUID = 1L;
    protected IPropertySourceProvider propertySourceProvider;
    protected boolean showImage = true;

    public PropertySourceCellRenderer(IPropertySourceProvider iPropertySourceProvider) {
        this.propertySourceProvider = iPropertySourceProvider;
    }

    public boolean isShowImage() {
        return this.showImage;
    }

    public void setShowImage(boolean bl) {
        boolean bl2 = this.showImage;
        this.showImage = bl;
        this.firePropertyChange("showImage", bl2, bl);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Object object2 = this.getRowValue(jTable, n);
        return this.getTableCellRendererComponent(jTable, object2, object, bl, bl2, n, n2);
    }

    protected Component getTableCellRendererComponent(JTable jTable, Object object, Object object2, boolean bl, boolean bl2, int n, int n2) {
        Object object3;
        Object object4;
        IPropertyDescriptor iPropertyDescriptor = this.getPropertyDescriptor(object);
        Object object5 = null;
        ILabelProvider iLabelProvider = null;
        if (iPropertyDescriptor != null) {
            object4 = this.getPropertySource(object2);
            if (object4 != null) {
                object5 = object4.getEditableValue();
                iLabelProvider = iPropertyDescriptor.getLabelProvider();
                object2 = this.isLineWrap() ? object5 : iLabelProvider.getText(object5);
            }
            if (this.isShowImage()) {
                this.setIcon(iLabelProvider.getImage(object5));
            }
        }
        object4 = super.getTableCellRendererComponent(jTable, object2, bl, bl2, n, n2);
        if (!bl && !bl2 && iLabelProvider instanceof IColorProvider) {
            Color color;
            object3 = (IColorProvider)((Object)iLabelProvider);
            Color color2 = object3.getForeground(object5);
            if (color2 != null) {
                this.setForeground(color2);
            }
            if ((color = object3.getBackground(object5)) != null) {
                this.setBackground(color);
            }
        }
        if (iLabelProvider instanceof IFontProvider && (object3 = ((IFontProvider)((Object)iLabelProvider)).getFont(object5)) != null) {
            this.setFont((Font)object3);
        }
        return object4;
    }

    protected abstract Object getRowValue(JTable var1, int var2);

    protected abstract IPropertyDescriptor getPropertyDescriptor(Object var1);

    protected IPropertySource getPropertySource(Object object) {
        return this.propertySourceProvider.getPropertySource(object);
    }
}

