/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.view.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Objects;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import net.astah.golf.view.swing.ElasticTextArea;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class LineWrappingTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -7848379802602162692L;
    private static final Color TRANSPARENT_COLOR = new Color(0, true);
    private boolean lineWrap;
    private JPanel panel;
    protected ElasticTextArea label;

    public boolean isLineWrap() {
        return this.lineWrap;
    }

    public void setLineWrap(boolean bl) {
        boolean bl2 = this.lineWrap;
        this.lineWrap = bl;
        if (bl2 != bl) {
            if (bl) {
                if (this.label == null) {
                    this.label = new ElasticTextArea();
                    this.label.setOpaque(false);
                    this.label.setBorder(null);
                    this.label.setLineWrap(true);
                    this.label.setWrapStyleWord(true);
                    this.label.setFont(null);
                    this.label.setForeground(null);
                    this.label.setBackground(TRANSPARENT_COLOR);
                    this.panel = new JPanel(new FlowLayout(0, 0, 0)){
                        private static final long serialVersionUID = 1L;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        protected void paintComponent(Graphics graphics) {
                            Color color = this.getBackground();
                            if (color != null && color.getAlpha() > 0 && color.getRGB() != Color.white.getRGB() && this.isOpaque() && graphics != null) {
                                Graphics graphics2 = graphics.create();
                                try {
                                    graphics2.setColor(color);
                                    graphics2.fillRect(0, 0, this.getWidth(), this.getHeight());
                                }
                                finally {
                                    graphics2.dispose();
                                }
                            }
                        }
                    };
                    this.panel.setFont(super.isFontSet() ? super.getFont() : null);
                    this.panel.setForeground(super.isForegroundSet() ? super.getForeground() : null);
                    this.panel.setBackground(super.isBackgroundSet() ? super.getBackground() : null);
                    this.panel.removeAll();
                    this.panel.add(this);
                    this.panel.add(this.label);
                }
                this.label.setText(this.getText());
                this.setText("");
            } else {
                this.setText(this.label.getText());
                this.label.setText("");
                this.label = null;
                this.panel = null;
            }
        }
        this.firePropertyChange("lineWrap", bl2, bl);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.label != null) {
            int n = this.getLabelWidth(dimension.width);
            if (this.label.getWidth() != n) {
                this.label.setSize(n, 0);
            }
        }
        return dimension;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (this.isLineWrap()) {
            if (jTable != null) {
                this.panel.setOpaque(super.isOpaque());
                this.panel.setBorder(super.getBorder());
                super.setBorder(null);
                int n3 = jTable.convertColumnIndexToView(n2);
                TableColumn tableColumn = jTable.getColumnModel().getColumn(n3);
                this.panel.setSize(tableColumn.getWidth(), 0);
            }
            return this.panel;
        }
        return component;
    }

    @Override
    protected void setValue(Object object) {
        String string = Objects.toString(object, "");
        if (this.isLineWrap()) {
            this.label.setText(string);
        } else {
            this.setText(string);
        }
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
        if ("font".equals(string)) {
            if (this.panel != null) {
                this.panel.setFont((Font)object2);
            }
        } else if ("foreground".equals(string)) {
            if (this.panel != null) {
                this.panel.setForeground((Color)object2);
            }
        } else if ("background".equals(string) && this.panel != null) {
            this.panel.setBackground((Color)object2);
        }
        super.firePropertyChange(string, object, object2);
    }

    protected int getLabelWidth(int n) {
        Insets insets = this.panel.getInsets();
        int n2 = this.panel.getWidth() - insets.left - insets.right;
        return Math.max(n2 - n, n);
    }
}

