/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class JudeGridLayout
implements LayoutManager,
Serializable {
    private static final long serialVersionUID = -7936495981866139332L;
    int rows = 2;
    int columns = 2;
    int xGap = 2;
    int yGap = 2;
    int componentCount = 0;
    Component[][] layoutGrid;

    public JudeGridLayout(int n, int n2) {
        this.rows = n2;
        this.columns = n;
        this.layoutGrid = new Component[n][n2];
    }

    @Override
    public void layoutContainer(Container container) {
        int n;
        this.a(container);
        int[] nArray = new int[this.rows];
        int[] nArray2 = new int[this.columns];
        for (n = 0; n < this.rows; ++n) {
            nArray[n] = this.b(n);
        }
        for (n = 0; n < this.columns; ++n) {
            nArray2[n] = this.a(n);
        }
        Insets insets = container.getInsets();
        if (container.getComponentOrientation().isLeftToRight()) {
            int n2 = insets.left;
            for (int k = 0; k < this.columns; ++k) {
                int n3 = insets.top;
                for (int i2 = 0; i2 < this.rows; ++i2) {
                    Component component = this.layoutGrid[k][i2];
                    component.setBounds(n2, n3, nArray2[k], nArray[i2]);
                    n3 += nArray[i2] + this.yGap;
                }
                n2 += nArray2[k] + this.xGap;
            }
        } else {
            int n4 = container.getWidth() - insets.right;
            for (int k = 0; k < this.columns; ++k) {
                int n5 = insets.top;
                n4 -= nArray2[k];
                for (int i3 = 0; i3 < this.rows; ++i3) {
                    Component component = this.layoutGrid[k][i3];
                    component.setBounds(n4, n5, nArray2[k], nArray[i3]);
                    n5 += nArray[i3] + this.yGap;
                }
                n4 -= this.xGap;
            }
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        int n;
        this.a(container);
        Insets insets = container.getInsets();
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.rows; ++n) {
            n2 += this.b(n);
        }
        for (n = 0; n < this.columns; ++n) {
            n3 += this.a(n);
        }
        return new Dimension(n3 += this.xGap * (this.columns - 1) + insets.right + insets.left, n2 += this.yGap * (this.rows - 1) + insets.top + insets.bottom);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.minimumLayoutSize(container);
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    private void a(Container container) {
        Component[] componentArray = container.getComponents();
        for (int k = 0; k < componentArray.length; ++k) {
            int n = 0;
            int n2 = 0;
            if (k != 0) {
                n2 = k % this.columns;
                n = (k - n2) / this.columns;
            }
            this.layoutGrid[n2][n] = componentArray[k];
        }
    }

    private int a(int n) {
        int n2 = 1;
        for (int k = 0; k < this.rows; ++k) {
            int n3 = this.layoutGrid[n][k].getPreferredSize().width;
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    private int b(int n) {
        int n2 = 1;
        for (int k = 0; k < this.columns; ++k) {
            int n3 = this.layoutGrid[k][n].getPreferredSize().height;
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }
}

