/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.view;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.astah.golf.draw.GCanvasSelectionEvent;
import net.astah.golf.draw.GCanvasSelectionListener;
import net.astah.golf.draw.GNode;
import net.astah.golf.view.ModelUIView;
import net.astah.golf.view.j;
import net.astah.golf.view.swing.UIViewPeer;
import net.astah.golf.widget.CCanvas;
import net.astah.golf.widget.CComponent;
import net.astah.golf.widget.ISelection;
import net.astah.golf.widget.ISelectionChangedListener;
import net.astah.golf.widget.SelectionSupport;
import net.astah.golf.widget.StructuredSelection;
import net.astah.golf.widget.swing.Selections;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class CanvasUIView
extends ModelUIView
implements GCanvasSelectionListener {
    private final SelectionSupport a = new SelectionSupport(this, this::createSelection);

    @Override
    public void addComponent(CComponent cComponent) {
        if (cComponent != this.component) {
            this.removeComponent();
            super.addComponent(cComponent);
            CCanvas cCanvas = this.getCanvas();
            if (cCanvas != null) {
                cCanvas.addGCanvasSelectionListener(this);
            }
        }
    }

    @Override
    public void removeComponent() {
        CCanvas cCanvas = this.getCanvas();
        if (cCanvas != null) {
            cCanvas.removeGCanvasSelectionListener(this);
        }
        super.removeComponent();
    }

    @Override
    public Object[] getSelectedModels() {
        CCanvas cCanvas = this.getCanvas();
        if (cCanvas != null) {
            return cCanvas.getSelectedNodes().toArray();
        }
        return null;
    }

    @Override
    public void selectionChanged(GCanvasSelectionEvent gCanvasSelectionEvent) {
        this.a.update();
    }

    @Override
    protected UIViewPeer createUIPeer() {
        return j.instance().createCanvasUIViewPeer();
    }

    @Override
    public ISelection getSelection() {
        return this.a.getSelection();
    }

    @Override
    public void setSelection(ISelection iSelection) {
        CCanvas cCanvas = this.getCanvas();
        if (Selections.isEmpty(iSelection)) {
            cCanvas.unselect();
        } else {
            Stream<GNode> stream = Selections.stream(iSelection, GNode.class);
            List<GNode> list = stream.collect(Collectors.toList());
            cCanvas.select(list);
        }
    }

    @Override
    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.a.addSelectionChangedListener(iSelectionChangedListener);
    }

    @Override
    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.a.removeSelectionChangedListener(iSelectionChangedListener);
    }

    protected ISelection createSelection() {
        List<GNode> list;
        CCanvas cCanvas = this.getCanvas();
        if (cCanvas != null && (list = cCanvas.getSelectedNodes()) != null && !list.isEmpty()) {
            return new StructuredSelection(list);
        }
        return StructuredSelection.empty();
    }

    protected CCanvas getCanvas() {
        if (this.component instanceof CCanvas) {
            return (CCanvas)this.component;
        }
        return null;
    }
}

