/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;
import org.xml.sax.helpers.XMLFilterImpl;
import proguard.annotation.Keep;

@Keep
public class XMLWriter
extends XMLFilterImpl {
    private final Attributes EMPTY_ATTS = new AttributesImpl();
    private Hashtable prefixTable;
    private Hashtable forcedDeclTable;
    private Hashtable doneDeclTable;
    private int elementLevel = 0;
    private Writer output;
    private NamespaceSupport nsSupport;
    private int prefixCounter = 0;

    public XMLWriter() throws UnsupportedEncodingException {
        this.init(null);
    }

    public XMLWriter(Writer writer) throws UnsupportedEncodingException {
        this.init(writer);
    }

    public XMLWriter(XMLReader xMLReader) throws UnsupportedEncodingException {
        super(xMLReader);
        this.init(null);
    }

    public XMLWriter(XMLReader xMLReader, Writer writer) throws UnsupportedEncodingException {
        super(xMLReader);
        this.init(writer);
    }

    private void init(Writer writer) throws UnsupportedEncodingException {
        this.setOutput(writer);
        this.nsSupport = new NamespaceSupport();
        this.prefixTable = new Hashtable();
        this.forcedDeclTable = new Hashtable();
        this.doneDeclTable = new Hashtable();
    }

    public void reset() {
        this.elementLevel = 0;
        this.prefixCounter = 0;
        this.nsSupport.reset();
    }

    public void flush() throws IOException {
        this.output.flush();
    }

    public void setOutput(Writer writer) throws UnsupportedEncodingException {
        this.output = writer == null ? new OutputStreamWriter((OutputStream)System.out, "UTF-8") : writer;
    }

    public void setPrefix(String string, String string2) {
        this.prefixTable.put(string, string2);
    }

    public String getPrefix(String string) {
        return (String)this.prefixTable.get(string);
    }

    public void forceNSDecl(String string) {
        this.forcedDeclTable.put(string, Boolean.TRUE);
    }

    public void forceNSDecl(String string, String string2) {
        this.setPrefix(string, string2);
        this.forceNSDecl(string);
    }

    @Override
    public void startDocument() throws SAXException {
        this.reset();
        this.write("<?xml version = \"1.0\" encoding = \"ISO-8859-1\" standalone = \"yes\"?>\r\n");
        super.startDocument();
    }

    public void startDocument(String string) throws SAXException {
        this.reset();
        this.write("<?xml version = \"1.0\" encoding = \"" + string + "\" standalone = \"yes\"?>\r\n");
        super.startDocument();
    }

    public void startDocumentAsShift_JIS() throws SAXException {
        this.write("<?xml version = \"1.0\" encoding = \"Shift_JIS\" standalone = \"yes\"?>\r\n");
        super.startDocument();
    }

    public void startDocumentAsUTF_8() throws SAXException {
        this.write("<?xml version = \"1.0\" encoding = \"UTF-8\" standalone = \"yes\"?>\r\n");
        super.startDocument();
    }

    public void writeDocType(String string, String string2) throws SAXException {
        this.write("<!DOCTYPE " + string + " \"" + string2 + "\">\r\n");
    }

    @Override
    public void endDocument() throws SAXException {
        this.write("\r\n");
        super.endDocument();
        try {
            this.flush();
            this.output.close();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        ++this.elementLevel;
        this.nsSupport.pushContext();
        this.write('<');
        this.writeName(string, string2, string3, true);
        this.writeAttributes(attributes);
        if (this.elementLevel == 1) {
            this.forceNSDecls();
        }
        this.writeNSDecls();
        this.write('>');
        super.startElement(string, string2, string3, attributes);
    }

    public void writeComment(String string) throws SAXException {
        String string2 = this.regulateComment(string);
        this.write("<!-- " + string2 + " -->");
    }

    private String regulateComment(String string) {
        int n = string.indexOf("--");
        if (n != -1) {
            String string2 = string.substring(0, n) + string.substring(n + 2);
            return this.regulateComment(string2);
        }
        return string;
    }

    public void startFirstElement(String string, String string2, AttributesImpl attributesImpl) throws SAXException {
        ++this.elementLevel;
        this.nsSupport.pushContext();
        this.write('<');
        this.writeName("", string, string2, true);
        this.writeAttributes(attributesImpl);
        for (int k = 0; k < attributesImpl.getLength(); ++k) {
            String string3 = attributesImpl.getLocalName(k);
            if (string3.indexOf("xmlns:") == -1) continue;
            String string4 = attributesImpl.getValue(k);
            int n = string3.indexOf(":");
            String string5 = string3.substring(n + 1);
            this.setPrefix(string4, string5);
        }
        if (this.elementLevel == 1) {
            this.forceNSDecls();
        }
        this.writeNSDecls();
        this.write('>');
        super.startElement("", string, string2, attributesImpl);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this.write("</");
        this.writeName(string, string2, string3, true);
        this.write('>');
        if (this.elementLevel == 1) {
            this.write("\r\n");
        }
        super.endElement(string, string2, string3);
        this.nsSupport.popContext();
        --this.elementLevel;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.writeEsc(cArray, n, n2, false);
        super.characters(cArray, n, n2);
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.writeEsc(cArray, n, n2, false);
        super.ignorableWhitespace(cArray, n, n2);
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        this.write("<?");
        this.write(string);
        this.write(' ');
        this.write(string2);
        this.write("?>");
        if (this.elementLevel < 1) {
            this.write("\r\n");
        }
        super.processingInstruction(string, string2);
    }

    public void emptyElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.nsSupport.pushContext();
        this.write('<');
        this.writeName(string, string2, string3, true);
        this.writeAttributes(attributes);
        if (this.elementLevel == 1) {
            this.forceNSDecls();
        }
        this.writeNSDecls();
        this.write("/>");
        super.startElement(string, string2, string3, attributes);
        super.endElement(string, string2, string3);
    }

    public void startElement(String string, String string2) throws SAXException {
        this.startElement(string, string2, "", this.EMPTY_ATTS);
    }

    public void startElement(String string) throws SAXException {
        this.startElement("", string, "", this.EMPTY_ATTS);
    }

    public void endElement(String string, String string2) throws SAXException {
        this.endElement(string, string2, "");
    }

    public void endElement(String string) throws SAXException {
        this.endElement("", string, "");
    }

    public void emptyElement(String string, String string2) throws SAXException {
        this.emptyElement(string, string2, "", this.EMPTY_ATTS);
    }

    public void emptyElement(String string) throws SAXException {
        this.emptyElement("", string, "", this.EMPTY_ATTS);
    }

    public void dataElement(String string, String string2, String string3, Attributes attributes, String string4) throws SAXException {
        this.startElement(string, string2, string3, attributes);
        this.characters(string4);
        this.endElement(string, string2, string3);
    }

    public void dataElement(String string, String string2, String string3) throws SAXException {
        this.dataElement(string, string2, "", this.EMPTY_ATTS, string3);
    }

    public void dataElement(String string, String string2) throws SAXException {
        this.dataElement("", string, "", this.EMPTY_ATTS, string2);
    }

    public void characters(String string) throws SAXException {
        char[] cArray = string.toCharArray();
        this.characters(cArray, 0, cArray.length);
    }

    private void forceNSDecls() {
        Enumeration enumeration = this.forcedDeclTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.doPrefix(string, null, true);
        }
    }

    private String doPrefix(String string, String string2, boolean bl) {
        String string3 = this.nsSupport.getURI("");
        if ("".equals(string)) {
            if (bl && string3 != null) {
                this.nsSupport.declarePrefix("", "");
            }
            return null;
        }
        String string4 = bl && string3 != null && string.equals(string3) ? "" : this.nsSupport.getPrefix(string);
        if (string4 != null) {
            return string4;
        }
        string4 = (String)this.doneDeclTable.get(string);
        if (string4 != null && ((!bl || string3 != null) && "".equals(string4) || this.nsSupport.getURI(string4) != null)) {
            string4 = null;
        }
        if (string4 == null && (string4 = (String)this.prefixTable.get(string)) != null && ((!bl || string3 != null) && "".equals(string4) || this.nsSupport.getURI(string4) != null)) {
            string4 = null;
        }
        if (string4 == null && string2 != null && !"".equals(string2)) {
            int n = string2.indexOf(58);
            if (n == -1) {
                if (bl && string3 == null) {
                    string4 = "";
                }
            } else {
                string4 = string2.substring(0, n);
            }
        }
        while (string4 == null || this.nsSupport.getURI(string4) != null) {
            string4 = "__NS" + ++this.prefixCounter;
        }
        this.nsSupport.declarePrefix(string4, string);
        this.doneDeclTable.put(string, string4);
        return string4;
    }

    private void write(char c2) throws SAXException {
        try {
            this.output.write(c2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    private void write(String string) throws SAXException {
        try {
            this.output.write(string);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    private void writeAttributes(Attributes attributes) throws SAXException {
        int n = attributes.getLength();
        for (int k = 0; k < n; ++k) {
            char[] cArray = attributes.getValue(k).toCharArray();
            this.write(' ');
            this.writeName(attributes.getURI(k), attributes.getLocalName(k), attributes.getQName(k), false);
            this.write("=\"");
            this.writeEsc(cArray, 0, cArray.length, true);
            this.write('\"');
        }
    }

    private void writeEsc(char[] cArray, int n, int n2, boolean bl) throws SAXException {
        int n3 = n + n2;
        StringBuilder stringBuilder = new StringBuilder();
        block6: for (int k = n; k < n3; ++k) {
            switch (cArray[k]) {
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block6;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    if (bl) {
                        stringBuilder.append("&quot;");
                        continue block6;
                    }
                    stringBuilder.append('\"');
                    continue block6;
                }
                default: {
                    stringBuilder.append(cArray[k]);
                }
            }
        }
        this.write(stringBuilder.toString());
    }

    private void writeNSDecls() throws SAXException {
        Enumeration<String> enumeration = this.nsSupport.getDeclaredPrefixes();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            String string2 = this.nsSupport.getURI(string);
            if (string2 == null) {
                string2 = "";
            }
            char[] cArray = string2.toCharArray();
            this.write(' ');
            if ("".equals(string)) {
                this.write("xmlns=\"");
            } else {
                this.write("xmlns:");
                this.write(string);
                this.write("=\"");
            }
            this.writeEsc(cArray, 0, cArray.length, true);
            this.write('\"');
        }
    }

    private void writeName(String string, String string2, String string3, boolean bl) throws SAXException {
        String string4 = this.doPrefix(string, string3, bl);
        if (string4 != null && !"".equals(string4)) {
            this.write(string4);
            this.write(':');
        }
        this.write(string2);
    }

    public void close() throws IOException {
        if (this.output != null) {
            this.output.close();
        }
    }
}

