/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.util;

import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Stack;
import net.astah.golf.util.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class XMLDataWriter
extends XMLWriter {
    private boolean enableComment = false;
    private char[] spaces = "                              ".toCharArray();
    private static final Object SEEN_NOTHING = new Object();
    private static final Object SEEN_ELEMENT = new Object();
    private static final Object SEEN_DATA = new Object();
    private Object state = SEEN_NOTHING;
    private Stack stateStack = new Stack();
    private int indentStep = 0;
    private int depth = 0;

    public XMLDataWriter() throws UnsupportedEncodingException {
    }

    public XMLDataWriter(XMLReader xMLReader) throws UnsupportedEncodingException {
        super(xMLReader);
    }

    public XMLDataWriter(Writer writer) throws UnsupportedEncodingException {
        super(writer);
    }

    public XMLDataWriter(XMLReader xMLReader, Writer writer) throws UnsupportedEncodingException {
        super(xMLReader, writer);
    }

    public int getIndentStep() {
        return this.indentStep;
    }

    public void setIndentStep(int n) {
        this.indentStep = n;
    }

    @Override
    public void reset() {
        this.depth = 0;
        this.state = SEEN_NOTHING;
        this.stateStack = new Stack();
        super.reset();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4;
        this.stateStack.push(SEEN_ELEMENT);
        this.state = SEEN_NOTHING;
        if (this.depth > 0) {
            super.characters("\r\n");
        }
        if (this.enableComment && (string4 = this.getNameForComment(attributes)) != null && string4.length() > 0) {
            this.doIndent();
            super.writeComment(string4);
            if (this.depth > 0) {
                super.characters("\r\n");
            }
        }
        this.doIndent();
        super.startElement(string, string2, string3, attributes);
        ++this.depth;
    }

    @Override
    public void startFirstElement(String string, String string2, AttributesImpl attributesImpl) throws SAXException {
        this.stateStack.push(SEEN_ELEMENT);
        this.state = SEEN_NOTHING;
        this.doIndent();
        super.startFirstElement(string, string2, attributesImpl);
        ++this.depth;
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        --this.depth;
        if (this.state == SEEN_ELEMENT) {
            super.characters("\r\n");
            this.doIndent();
        }
        super.endElement(string, string2, string3);
        this.state = this.stateStack.pop();
    }

    @Override
    public void emptyElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.stateStack.push(SEEN_ELEMENT);
        this.state = SEEN_NOTHING;
        if (this.depth > 0) {
            super.characters("\r\n");
        }
        this.doIndent();
        super.emptyElement(string, string2, string3, attributes);
        this.state = this.stateStack.pop();
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.state = SEEN_DATA;
        super.characters(cArray, n, n2);
    }

    public void setEnableComment() {
        this.enableComment = true;
    }

    public void resetEnableComment() {
        this.enableComment = false;
    }

    private String getNameForComment(Attributes attributes) {
        String string;
        int n;
        String string2 = null;
        for (n = 0; n < attributes.getLength(); ++n) {
            string = attributes.getLocalName(n);
            if (!string.equalsIgnoreCase("name")) continue;
            string2 = attributes.getValue(n);
            break;
        }
        if (string2 == null || string2.length() == 0) {
            for (n = 0; n < attributes.getLength(); ++n) {
                string = attributes.getLocalName(n);
                if (!string.equalsIgnoreCase("label")) continue;
                string2 = attributes.getValue(n);
                break;
            }
        }
        return string2;
    }

    private void doIndent() throws SAXException {
        if (this.indentStep > 0 && this.depth > 0) {
            int n = this.indentStep * this.depth;
            if (n < this.spaces.length) {
                this.characters(this.spaces, 0, n);
            } else {
                while (n > 0) {
                    this.characters(this.spaces, 0, n < this.spaces.length ? n : this.spaces.length);
                    n -= this.spaces.length;
                }
            }
        }
    }
}

