/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MenuListener;
import net.astah.golf.control.GolfAction;
import net.astah.golf.draw.UnderLineIcon;
import net.astah.golf.util.ButtonStateChanger;
import net.astah.golf.util.Debug;
import net.astah.golf.util.GolfUtilities;
import net.astah.golf.util.LookAndFeelFinder;
import net.astah.golf.util.ResourceBundleList;
import net.astah.golf.util.UIFactoryConstants;
import net.astah.golf.widget.CIcon;
import net.astah.golf.widget.CPopupMenu;
import net.astah.golf.widget.CToolBar;
import net.astah.golf.widget.swing.DropDownJButton;
import net.astah.golf.widget.swing.RepeatJButton;
import net.astah.golf.widget.swing.SwingComponent;
import net.astah.golf.widget.swing.SwingIcon;
import net.astah.golf.widget.swing.SwingIconRegistry;
import net.astah.golf.widget.swing.SwingPopupMenu;
import net.astah.golf.widget.swing.SwingToolBar;
import org.eclipse.emf.common.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIFactory
implements UIFactoryConstants {
    private ResourceBundleList resources;
    private Map<? super String, Action> commands = new HashMap<String, Action>();
    private static boolean isMacOs = false;
    private static final Border EMPTY_BORDER = new EmptyBorder(4, 4, 4, 4);
    private static final Logger logger = LoggerFactory.getLogger(UIFactory.class);

    public UIFactory(ResourceBundleList resourceBundleList) {
        this.setResource(resourceBundleList);
    }

    public void setResource(ResourceBundleList resourceBundleList) {
        this.resources = resourceBundleList;
    }

    public void setActionTable(Map<? super String, Action> map) {
        this.commands = map;
    }

    public JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        String[] stringArray = GolfUtilities.tokenize(this.getResourceString("managementview.menubar"));
        for (int k = 0; k < stringArray.length; ++k) {
            JMenu jMenu = this.createMenu(stringArray[k]);
            jMenu.setOpaque(false);
            jMenuBar.add(jMenu);
        }
        return jMenuBar;
    }

    private JMenu createMenu(String string) {
        Object object;
        Object object2;
        HashMap<String, ButtonGroup> hashMap = new HashMap<String, ButtonGroup>();
        String[] stringArray = GolfUtilities.tokenize(this.getResourceString(string));
        String string2 = this.getResourceString(string + ".label");
        if (string2 == null) {
            return null;
        }
        int n = string2.indexOf(36);
        String string3 = UIFactory.getLabelWithoutMnemonicInfo(string2);
        JMenu jMenu = new JMenu(string3);
        jMenu.setName(string);
        this.setMnemonic(jMenu, n);
        jMenu.setActionCommand(string);
        String string4 = this.getResourceString(string + ".menu_listener");
        if (string4 != null) {
            try {
                object2 = Class.forName(string4);
                object = (MenuListener)((Class)object2).newInstance();
                if (object != null) {
                    jMenu.addMenuListener((MenuListener)object);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((object2 = this.getResourceString(string + ".menu_listener2")) != null) {
            try {
                object = Class.forName((String)object2);
                MenuListener menuListener = (MenuListener)((Class)object).newInstance();
                if (menuListener != null) {
                    jMenu.addMenuListener(menuListener);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((object = this.getResourceImageIcon(string)) != null) {
            jMenu.setHorizontalTextPosition(4);
            jMenu.setIcon((Icon)object);
        }
        for (int k = 0; k < stringArray.length; ++k) {
            if (stringArray[k].equals("-")) {
                jMenu.addSeparator();
                continue;
            }
            String string5 = stringArray[k];
            String string6 = null;
            String string7 = null;
            int n2 = string5.indexOf(64);
            if (n2 != -1 && string5.length() - n2 > 1) {
                string6 = string5.substring(0, n2);
                string7 = string5.substring(n2 + 1);
            } else {
                string6 = string5;
            }
            Component component = this.createMenuComponent(string6);
            if (component == null) {
                logger.error("UIFactory#createMenu: faied to create menu for <<{}>>", (Object)string6);
            }
            jMenu.add(component);
            if (string7 == null || !(component instanceof AbstractButton)) continue;
            ButtonGroup buttonGroup = (ButtonGroup)hashMap.get(string7);
            if (buttonGroup == null) {
                buttonGroup = new ButtonGroup();
                hashMap.put(string7, buttonGroup);
            }
            buttonGroup.add((AbstractButton)component);
        }
        return jMenu;
    }

    private static int getIndexOfMnemonic(String string) {
        return string.indexOf(36);
    }

    public static String getLabelWithoutMnemonicInfo(String string) {
        int n = UIFactory.getIndexOfMnemonic(string);
        if (n != -1 && string.length() - n > 1) {
            if (isMacOs && n > 0 && string.charAt(n - 1) == '(' && n < string.length() - 2 && string.charAt(n + 2) == ')') {
                return string.substring(0, n - 1).concat(string.substring(n + 3));
            }
            return string.substring(0, n).concat(string.substring(++n));
        }
        return string;
    }

    private void setMnemonic(JMenuItem jMenuItem, int n) {
        if (isMacOs) {
            return;
        }
        if (n >= 0 && n < jMenuItem.getText().length()) {
            char c2 = Character.toLowerCase(jMenuItem.getText().charAt(n));
            jMenuItem.setMnemonic(c2);
            jMenuItem.setDisplayedMnemonicIndex(n);
        }
    }

    private Component createMenuComponent(String string) {
        String string2;
        Object object;
        String string3;
        if (string.startsWith("%")) {
            return this.createMenu(string.substring(1));
        }
        JMenuItem jMenuItem = null;
        String string4 = this.getResourceString(string + ".label");
        if (string4 == null) {
            return null;
        }
        int n = string4.indexOf(36);
        if (!(string4 = UIFactory.getLabelWithoutMnemonicInfo(string4)).startsWith("*") || string4.equals("*")) {
            string3 = string4;
            jMenuItem = new JMenuItem(string3);
        } else {
            string3 = string4.substring(1, 2);
            object = string4.substring(3);
            n -= 3;
            if (string3.equals("c")) {
                jMenuItem = new JCheckBoxMenuItem((String)object);
            } else {
                if (string3.equals("t")) {
                    return this.createPanel(string);
                }
                if (string3.equals("r")) {
                    jMenuItem = new JRadioButtonMenuItem((String)object);
                } else if (string3.equals("p")) {
                    jMenuItem = new JMenuItem((String)object);
                } else {
                    Debug.impossible("impossible action. syntax error in resource file");
                }
            }
            string2 = string4.substring(2, 3);
            if (string2.equals("1")) {
                jMenuItem.setSelected(true);
            } else if (string2.equals("0")) {
                jMenuItem.setSelected(false);
            } else {
                Debug.impossible("impossible action. syntax error in resource file");
            }
        }
        if (jMenuItem == null) {
            logger.debug("UIFactory: failed to create a MenuItem. key = {}", (Object)string);
        }
        this.setupButton(string, jMenuItem);
        string3 = this.getResourceString(string + ".key");
        if (string3 != null) {
            logger.debug("keyString = {}", (Object)string3);
            if (isMacOs) {
                string3 = string3.replaceFirst("control", "meta");
                if (logger.isDebugEnabled()) {
                    int n2 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
                    string2 = InputEvent.getModifiersExText(n2);
                    logger.debug("shortcutKeyMask = {}", (Object)string2);
                }
            }
            if ((object = KeyStroke.getKeyStroke(string3)) != null) {
                jMenuItem.setAccelerator((KeyStroke)object);
            } else {
                logger.debug("KeyStr = {} is invalid", (Object)string3);
            }
        }
        jMenuItem.setName(string);
        this.setMnemonic(jMenuItem, n);
        object = this.getResourceString(string + ".tooltip");
        if (object != null) {
            if (isMacOs) {
                object = ((String)object).replaceFirst("<html>", "");
                object = ((String)object).replaceFirst("</html>", "");
                object = ((String)object).replaceAll("<br>", "");
            }
            jMenuItem.setToolTipText((String)object);
        }
        return jMenuItem;
    }

    private void setupButton(String string, AbstractButton abstractButton) {
        String string2;
        Icon icon;
        Icon icon2;
        Icon icon3 = this.getResourceImageIcon(string, Status.NORMAL);
        if (icon3 != null) {
            abstractButton.setHorizontalTextPosition(4);
            abstractButton.setIcon(icon3);
        }
        if ((icon2 = this.getResourceImageIcon(string, Status.DISABLED)) != null) {
            abstractButton.setDisabledIcon(icon2);
        }
        if ((icon = this.getResourceImageIcon(string, Status.ROLLOVER)) != null) {
            abstractButton.setRolloverIcon(icon);
        }
        if ((string2 = this.getResourceString(string + ".action")) == null) {
            string2 = string;
        }
        String string3 = this.getResourceString(string + ".action_name");
        this.setupButton(abstractButton, string3, string2, icon3);
    }

    private Component createPanel(String string) {
        String[] stringArray = GolfUtilities.tokenize(this.getResourceString(string));
        JPanel jPanel = new JPanel();
        jPanel.setName(string);
        jPanel.setLayout(new GridLayout(this.getRowCount(stringArray), this.getColumnCount(stringArray)));
        for (int k = 0; k < stringArray.length; ++k) {
            if (stringArray[k].equals("-")) continue;
            String string2 = this.getResourceString(stringArray[k] + ".label");
            String string3 = this.getResourceString(stringArray[k] + ".color");
            JButton jButton = null;
            if (string3 != null) {
                jButton = this.createColorButton(string2, GolfUtilities.createColor(string3));
            } else {
                jButton = new JButton();
                jButton.setMargin(new Insets(0, 0, 0, 0));
                String string4 = this.getResourceString(stringArray[k] + ".tooltip");
                if (string4 != null) {
                    jButton.setToolTipText(string4);
                }
            }
            jButton.setName(stringArray[k]);
            this.setupButton(stringArray[k], jButton);
            jPanel.add(jButton);
        }
        return jPanel;
    }

    private JButton createColorButton(String string, Color color) {
        JButton jButton = new JButton();
        jButton.setBorder(BorderFactory.createRaisedBevelBorder());
        if (string != null) {
            jButton.setText(string);
        }
        if (color != null) {
            jButton.setBackground(color);
            jButton.setForeground(color);
            jButton.setContentAreaFilled(false);
            jButton.setOpaque(true);
        }
        jButton.setPreferredSize(new Dimension(20, 20));
        return jButton;
    }

    private int getColumnCount(String[] stringArray) {
        int n = 0;
        if (stringArray != null) {
            int n2 = 0;
            for (int k = 0; k < stringArray.length; ++k) {
                if (stringArray[k].equals("-")) {
                    n = Math.max(n, n2);
                    n2 = 0;
                }
                ++n2;
            }
        }
        return n;
    }

    private int getRowCount(String[] stringArray) {
        if (stringArray == null) {
            return 0;
        }
        int n = 1;
        for (int k = 0; k < stringArray.length; ++k) {
            if (k == stringArray.length - 1 || !stringArray[k].equals("-")) continue;
            ++n;
        }
        return n;
    }

    public JToolBar createToolBar(String string) {
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        JToolBar jToolBar = new JToolBar();
        jToolBar.setOpaque(false);
        String[] stringArray = GolfUtilities.tokenize(this.getResourceString(string));
        boolean bl = this.isButtonOfOpaque();
        for (int k = 0; k < stringArray.length; ++k) {
            Serializable serializable;
            if (stringArray[k].equals("-")) {
                jToolBar.add(Box.createHorizontalStrut(5));
                continue;
            }
            String string2 = stringArray[k];
            String string3 = null;
            String string4 = null;
            int n = string2.indexOf(64);
            if (n != -1 && string2.length() - n > 1) {
                string3 = string2.substring(0, n);
                string4 = string2.substring(n + 1);
            } else {
                string3 = string2;
            }
            AbstractButton abstractButton = this.createToolbarButton(string3);
            if (this.isButtonWithEmptyBorder(abstractButton)) {
                abstractButton.setBorder(EMPTY_BORDER);
            }
            abstractButton.setOpaque(bl);
            if (abstractButton instanceof DropDownJButton) {
                serializable = (DropDownJButton)DropDownJButton.class.cast(abstractButton);
                ((DropDownJButton)serializable).getArrowButton().setBorderPainted(false);
                ((DropDownJButton)serializable).addToToolBar(jToolBar);
            } else {
                jToolBar.add(abstractButton);
            }
            if (string4 == null) continue;
            serializable = (ButtonGroup)hashMap.get(string4);
            if (serializable == null) {
                serializable = new ButtonGroup();
                hashMap.put(string4, serializable);
            }
            ((ButtonGroup)serializable).add(abstractButton);
        }
        jToolBar.add(Box.createHorizontalGlue());
        return jToolBar;
    }

    private boolean isButtonWithEmptyBorder(AbstractButton abstractButton) {
        return !LookAndFeelFinder.isMacLookAndFeel() || !(abstractButton instanceof JToggleButton);
    }

    private boolean isButtonOfOpaque() {
        return LookAndFeelFinder.isMetalLookAndFeel();
    }

    public void changePicture(CToolBar cToolBar, String string, String string2) {
        if (!(cToolBar instanceof SwingToolBar)) {
            return;
        }
        for (int k = 0; k < cToolBar.getComponentCount(); ++k) {
            Component component = ((SwingComponent)cToolBar.getComponentAtIndex(k)).getComponent();
            AbstractButton abstractButton = null;
            if (!(component instanceof AbstractButton) || (abstractButton = (AbstractButton)component) == null || abstractButton.getIcon() == null || !abstractButton.getIcon().equals(this.getResourceImageIcon(string))) continue;
            abstractButton.setIcon(this.getResourceImageIcon(string2));
            break;
        }
    }

    private AbstractButton createToolbarButton(String string) {
        String string2;
        Object object;
        Object object2;
        AbstractButton abstractButton;
        Object object3;
        String string3;
        Icon icon = this.getResourceImageIcon(string);
        String string4 = this.getResourceString(string + ".action");
        if (string4 == null) {
            string4 = string;
        }
        if ((string3 = this.getResourceString(string + ".label")) == null) {
            return null;
        }
        if (!string3.startsWith("*")) {
            object3 = string3;
            abstractButton = icon != null ? new JButton(icon) : new JButton((String)object3);
        } else {
            object3 = string3.substring(1, 2);
            object2 = string3.substring(3);
            if (((String)object3).equals("c")) {
                abstractButton = icon != null ? new JCheckBox(icon) : (object2 != null ? new JCheckBox((String)object2) : new JCheckBox(string4));
            } else if (((String)object3).equals("t")) {
                abstractButton = icon != null ? new JToggleButton(icon) : (object2 != null ? new JToggleButton((String)object2) : new JToggleButton(string4));
            } else if (((String)object3).equals("r")) {
                abstractButton = icon != null ? new JRadioButton(icon) : (object2 != null ? new JRadioButton((String)object2) : new JRadioButton(string4));
            } else if (((String)object3).equals("p")) {
                abstractButton = icon != null ? new RepeatJButton(icon) : (object2 != null ? new RepeatJButton((String)object2) : new RepeatJButton(string4));
            } else if (((String)object3).equals("d")) {
                abstractButton = icon != null ? new DropDownJButton(icon) : (object2 != null ? new DropDownJButton((String)object2) : new DropDownJButton(string4));
                ((DropDownJButton)abstractButton).setKey(string);
            } else {
                Debug.impossible("impossible action. syntax error in resource file");
                return null;
            }
            object = string3.substring(2, 3);
            if (((String)object).equals("1")) {
                abstractButton.setSelected(true);
            } else if (((String)object).equals("0")) {
                abstractButton.setSelected(false);
            } else {
                Debug.impossible("impossible action. syntax error in resource file");
                return null;
            }
        }
        abstractButton.setRequestFocusEnabled(false);
        abstractButton.setFocusable(false);
        abstractButton.setMargin(new Insets(1, 1, 1, 1));
        object3 = this.getResourceImageIcon(string, Status.DISABLED);
        if (object3 != null) {
            abstractButton.setDisabledIcon((Icon)object3);
        }
        if ((object2 = this.getResourceImageIcon(string, Status.ROLLOVER)) != null) {
            abstractButton.setRolloverIcon((Icon)object2);
        }
        object = this.getAction(string4);
        abstractButton.setName(string);
        abstractButton.setActionCommand(string4);
        if (object == null) {
            string2 = this.getResourceString(string + ".action_name");
            if (string2 != null && !string2.equals("")) {
                object = new GolfAction(string2, string4);
                this.commands.put(string2, (Action)object);
                abstractButton.setActionCommand(string2);
            } else {
                object = new GolfAction(string4);
                this.commands.put(string4, (Action)object);
            }
        }
        abstractButton.addActionListener((ActionListener)object);
        object.addPropertyChangeListener(this.createButtonStateChanger(abstractButton));
        string2 = this.getResourceString(string + ".tooltip");
        if (string2 != null) {
            if (string2.startsWith("*c") && abstractButton instanceof DropDownJButton) {
                ((DropDownJButton)abstractButton).setEnableChangeTip(true);
                string2 = string2.substring(2);
            }
            abstractButton.setToolTipText(string2);
        }
        return abstractButton;
    }

    public JPopupMenu createPopupMenu(String string) {
        String string2 = this.getResourceString(string);
        if (string2 == null) {
            return null;
        }
        String[] stringArray = GolfUtilities.tokenize(string2);
        JPopupMenu jPopupMenu = new JPopupMenu(this.getResourceString(string + ".label"));
        for (int k = 0; k < stringArray.length; ++k) {
            String string3 = stringArray[k];
            logger.trace("itemKey:'{}'", (Object)string3);
            if (string3.equals("-")) {
                jPopupMenu.addSeparator();
                continue;
            }
            Component component = this.createMenuComponent(string3);
            if (component == null) continue;
            jPopupMenu.add(component);
        }
        return jPopupMenu;
    }

    public CPopupMenu createCPopupMenu(String string) {
        JPopupMenu jPopupMenu = this.createPopupMenu(string);
        if (jPopupMenu == null) {
            return null;
        }
        return new SwingPopupMenu(jPopupMenu);
    }

    protected ButtonStateChanger createButtonStateChanger(AbstractButton abstractButton) {
        return new ButtonStateChanger(abstractButton);
    }

    private Action getAction(String string) {
        if (this.commands != null) {
            return this.commands.get(string);
        }
        return null;
    }

    public String getResourceString(String string) {
        return this.resources.getString(string);
    }

    protected URL getResource(String string) {
        String string2 = this.getResourceString(string);
        if (string2 != null) {
            URL uRL = this.getClass().getResource(string2);
            return uRL;
        }
        return null;
    }

    private Icon getResourceImageIcon(String string, Status status, boolean bl) {
        boolean bl2;
        Icon icon = SwingIconRegistry.INSTANCE.getIcon(URI.createURI((String)string));
        if (icon != null) {
            return icon;
        }
        String string2 = this.getResourceString(string + ".image");
        if (string2 == null) {
            return null;
        }
        if (status == Status.DISABLED) {
            string2 = string2.replace(".png", "_d.png");
        }
        if (status == Status.ROLLOVER) {
            string2 = string2.replace(".png", "_r.png");
        }
        if (bl2 = this.hasUnderline(string2)) {
            string2 = string2.substring(2);
        }
        Icon icon2 = SwingIconRegistry.INSTANCE.getIcon(URI.createURI((String)string2));
        if (bl2) {
            icon2 = this.decorateUnderline(icon2, string, status);
        }
        return icon2;
    }

    private boolean hasUnderline(String string) {
        return string.startsWith("*u");
    }

    private Icon decorateUnderline(Icon icon, String string, Status status) {
        if (icon == null) {
            return null;
        }
        Color color = this.getUnderlineColor(this.resources, string, status);
        return new UnderLineIcon(icon, color);
    }

    private Color getUnderlineColor(ResourceBundleList resourceBundleList, String string, Status status) {
        String string2;
        if (status == Status.DISABLED) {
            return Color.LIGHT_GRAY;
        }
        String string3 = resourceBundleList.getString(string + ".action");
        String string4 = string2 = string3.substring(string3.indexOf("%") + 1);
        if (string2.indexOf("|") != -1) {
            string4 = string2.substring(string2.indexOf("|") + 1);
        }
        return GolfUtilities.createColor(string4);
    }

    private Icon getResourceImageIcon(String string, Status status) {
        return this.getResourceImageIcon(string, status, false);
    }

    public Icon getResourceImageIcon(String string) {
        return this.getResourceImageIcon(string, Status.NORMAL);
    }

    public Icon getResourceImageIconWithDefaultIcon(String string) {
        return this.getResourceImageIcon(string, Status.NORMAL, true);
    }

    public static JMenu searchMenu(MenuElement[] menuElementArray, String string) {
        for (int k = 0; k < menuElementArray.length; ++k) {
            MenuElement menuElement = menuElementArray[k];
            if (!(menuElement instanceof JMenu) || !((JMenu)menuElement).getActionCommand().equals(string)) continue;
            return (JMenu)menuElement;
        }
        return null;
    }

    public static JMenuItem searchMenuItem(MenuElement[] menuElementArray, String string) {
        for (int k = 0; k < menuElementArray.length; ++k) {
            MenuElement menuElement = menuElementArray[k];
            if (!(menuElement instanceof JMenuItem) || !((JMenuItem)menuElement).getActionCommand().equals(string)) continue;
            return (JMenuItem)menuElement;
        }
        return null;
    }

    public static JMenuItem createMenuItem(String string, String string2, CIcon cIcon) {
        JMenuItem jMenuItem = new JMenuItem(string);
        GolfAction golfAction = new GolfAction(string2);
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(golfAction);
        if (cIcon != null) {
            jMenuItem.setIcon(((SwingIcon)cIcon).getComponent());
        }
        jMenuItem.setEnabled(true);
        return jMenuItem;
    }

    public void setupButton(AbstractButton abstractButton, String string, String string2, Icon icon) {
        if (icon != null) {
            abstractButton.setIcon(icon);
        }
        abstractButton.setActionCommand(string2);
        String string3 = string2.startsWith("*c") ? string2.substring(2) : string2;
        Action action = this.getAction(string3);
        if (action == null) {
            if (string != null && !string.equals("")) {
                action = new GolfAction(string, string3);
                this.commands.put(string, action);
                abstractButton.setActionCommand(string);
            } else {
                action = new GolfAction(string3);
                this.commands.put(string3, action);
            }
        }
        abstractButton.addActionListener(action);
        action.addPropertyChangeListener(this.createButtonStateChanger(abstractButton));
        abstractButton.setEnabled(action.isEnabled());
    }

    static {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.indexOf("windows") == -1 && string.indexOf("mac") != -1) {
            isMacOs = true;
        }
    }

    public static enum Status {
        NORMAL,
        DISABLED,
        ROLLOVER;

    }
}

