/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.util;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.lang.reflect.Field;
import net.astah.jomt.jsystem.JVMInfo;

public class ScreenDeviceSupport {
    private static Window mainWindow = null;

    public static void setMainWindow(Window window) {
        mainWindow = window;
    }

    public static boolean isMacRetina() {
        if (mainWindow == null) {
            return ScreenDeviceSupport.isDefaultScreenRetina();
        }
        return ScreenDeviceSupport.isCurrentScreenRetina(mainWindow);
    }

    private static boolean isCurrentScreenRetina(Window window) {
        GraphicsConfiguration graphicsConfiguration = window.getGraphicsConfiguration();
        GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
        return ScreenDeviceSupport.isRetinaScale(graphicsDevice);
    }

    private static boolean isDefaultScreenRetina() {
        if (GraphicsEnvironment.isHeadless()) {
            return false;
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        return ScreenDeviceSupport.isRetinaScale(graphicsDevice);
    }

    private static boolean isRetinaScale(GraphicsDevice graphicsDevice) {
        if (!JVMInfo.isOracleVmVendor() || JVMInfo.getJavaVersion().compareTo("1.7.0_40") < 0) {
            return false;
        }
        try {
            Field field = graphicsDevice.getClass().getDeclaredField("scale");
            if (field != null) {
                field.setAccessible(true);
                Object object = field.get(graphicsDevice);
                if (object instanceof Integer && (Integer)object == 2) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

