/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import net.astah.golf.util.GolfUtilities;

public class ResourceBundleList {
    List<ResourceBundle> resourceBundleList = new ArrayList<ResourceBundle>();
    Map<String, Object> cacheGetObject = new WeakHashMap<String, Object>(2000);
    public static ResourceBundle externalGuiResource;
    public static ResourceBundle externalKeyResource;
    private static final String CACHEKEY_COMMA = ",";

    public void addResourceBundle(ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            return;
        }
        this.resourceBundleList.add(resourceBundle);
        this.cacheGetObject.clear();
    }

    public void mergeResourceBundles(ResourceBundleList resourceBundleList) {
        for (ResourceBundle resourceBundle : resourceBundleList.getResourceBundleList()) {
            this.addResourceBundle(resourceBundle);
        }
        this.cacheGetObject.clear();
    }

    private List<ResourceBundle> getResourceBundleList() {
        return Collections.unmodifiableList(this.resourceBundleList);
    }

    public String getString(String string) {
        return this.getString(string, true);
    }

    public String getString(String string, boolean bl) {
        return (String)this.getObject(string, bl);
    }

    public String[] getStrings(String string) {
        return this.getStrings(string, true);
    }

    public String[] getStrings(String string, boolean bl) {
        String string2 = this.getString(string, bl);
        return string2 != null ? GolfUtilities.tokenize(string2) : new String[]{};
    }

    public final Object getObject(String string) {
        return this.getObject(string, true);
    }

    public final Object getObject(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(CACHEKEY_COMMA);
        stringBuilder.append(bl);
        String string2 = stringBuilder.toString();
        if (this.cacheGetObject.containsKey(string2)) {
            return this.cacheGetObject.get(string2);
        }
        Object object = null;
        for (int k = this.resourceBundleList.size() - 1; k > -1; --k) {
            ResourceBundle resourceBundle = this.resourceBundleList.get(k);
            if (!bl && (resourceBundle == externalGuiResource || resourceBundle == externalKeyResource)) continue;
            try {
                object = resourceBundle.getObject(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (object == null) continue;
            if (resourceBundle == externalGuiResource) {
                if (string.endsWith(".label") || string.endsWith(".tooltip") || string.endsWith(".message") || string.endsWith(".key") || string.endsWith(".title") || string.equals("emf.font.sequence") || string.equals("url.manual") || string.equals("managementview.menu.help.jude_home.action") || string.equals("managementview.menu.edit.copys") || string.equals("managementview.menu.tool.export_image") || string.equals("diagramview.popupmenu.copys") || string.equals("ui.export_rtf.group.diagram.image_format") || string.equals("ui.export_rtf.group.diagram.add_image_link")) break;
                object = null;
                continue;
            }
            if (resourceBundle != externalKeyResource || string.endsWith(".key")) break;
            object = null;
        }
        this.cacheGetObject.put(string2, object);
        return object;
    }

    public List<String> getKeies() {
        return this.getKeies(true);
    }

    public List<String> getKeies(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int k = this.resourceBundleList.size() - 1; k > -1; --k) {
            ResourceBundle resourceBundle = this.resourceBundleList.get(k);
            if (!bl && (resourceBundle == externalGuiResource || resourceBundle == externalKeyResource)) continue;
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }
}

