/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.ProgressMonitor;
import javax.swing.Timer;
import net.astah.golf.util.LongTask;

public class ProgressView {
    public static final int ONE_SECOND = 1000;
    private ProgressMonitor progressMonitor;
    private Timer timer;
    private LongTask task;
    private Component parentComponent;
    private JDialog dummyModalDialog;

    public ProgressView(Component component, LongTask longTask) {
        this.parentComponent = component;
        this.task = longTask;
        this.timer = new Timer(1000, new TimerListener());
    }

    public void start() {
        this.start(0);
    }

    public void start(int n) {
        this.progressMonitor = new ProgressMonitor(this.parentComponent, "Running a Long Task", "", 0, 100);
        this.progressMonitor.setProgress(0);
        this.progressMonitor.setMillisToDecideToPopup(n * 1000);
        this.timer.start();
        this.task.go();
        this.startModal();
    }

    protected void startModal() {
        this.dummyModalDialog = new JDialog(){
            private static final long serialVersionUID = -7654470505161258569L;

            public Dimension getPrefferedSize() {
                return new Dimension(0, 0);
            }

            @Override
            public int getWidth() {
                return 0;
            }

            @Override
            public int getHeight() {
                return 0;
            }
        };
        this.dummyModalDialog.setModal(true);
        this.dummyModalDialog.setVisible(true);
    }

    protected void endModal() {
        this.dummyModalDialog.setVisible(false);
        this.dummyModalDialog.dispose();
    }

    class TimerListener
    implements ActionListener {
        TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ProgressView.this.progressMonitor.isCanceled()) {
                ProgressView.this.timer.stop();
                ProgressView.this.task.cancel();
                ProgressView.this.progressMonitor.close();
                ProgressView.this.endModal();
            } else if (ProgressView.this.task.getProgress().done() || ProgressView.this.task.getProgress().canceled()) {
                ProgressView.this.timer.stop();
                ProgressView.this.progressMonitor.close();
                ProgressView.this.endModal();
            } else {
                int n = ProgressView.this.task.getProgress().getGlobalProgress();
                ProgressView.this.progressMonitor.setProgress(n);
                ProgressView.this.progressMonitor.setNote("Completed " + n + "%.");
            }
        }
    }
}

