/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import net.astah.golf.util.LongTask;
import net.astah.golf.widget.swing.AdjustFontSizeTextArea;

public class ProgressDialog
extends JDialog {
    private static final long serialVersionUID = -2890812087428004259L;
    public static final int ONE_SECOND = 1000;
    private JProgressBar progressBar;
    private Timer timer;
    private JButton startButton;
    private JButton cancelButton;
    private JButton closeButton;
    private LongTask task;
    private JTextArea taskOutput;
    private boolean isRunningTask = false;
    private WindowAdapter progressDialogListener;

    public ProgressDialog(Frame frame, boolean bl, LongTask longTask, boolean bl2) throws HeadlessException {
        super(frame, "ProgressDialog", bl);
        this.task = longTask;
        this.startButton = new JButton("Start");
        this.startButton.setActionCommand("start");
        this.startButton.addActionListener(new ButtonListener());
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(new ButtonListener());
        this.cancelButton.setEnabled(false);
        this.closeButton = new JButton("Close");
        this.closeButton.setActionCommand("close");
        this.closeButton.addActionListener(new ButtonListener());
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.taskOutput = new AdjustFontSizeTextArea(5, 10);
        if (!bl2) {
            this.taskOutput.setText("Push [Start] Button...");
        }
        this.taskOutput.setEditable(false);
        JPanel jPanel = new JPanel();
        jPanel.add(this.startButton);
        jPanel.add(this.progressBar);
        if (longTask.canCancel()) {
            jPanel.add(this.cancelButton);
        }
        jPanel.add(this.closeButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)new JScrollPane(this.taskOutput), "Center");
        this.setContentPane(jPanel2);
        this.addWindowListener(this.progressDialogListener);
        this.timer = new Timer(1000, new TimerListener());
        if (bl2) {
            this.start();
        }
    }

    public boolean isRunningTask() {
        if (!this.isRunningTask) {
            return false;
        }
        return !this.task.getProgress().done() && !this.task.isFinishedCancel();
    }

    public ProgressDialog(Frame frame, boolean bl, LongTask longTask) throws HeadlessException {
        this(frame, bl, longTask, false);
    }

    private void start() {
        this.isRunningTask = true;
        this.startButton.setEnabled(false);
        this.closeButton.setEnabled(false);
        this.task.go();
        this.timer.start();
        this.cancelButton.setEnabled(true);
    }

    private void cancel() {
        this.cancelButton.setEnabled(false);
        this.task.cancel();
    }

    private void close() {
        if (!this.isRunningTask) {
            this.setVisible(false);
            this.dispose();
            this.task.postOperation();
        }
    }

    public void setProgressDialogListener(WindowAdapter windowAdapter) {
        this.progressDialogListener = windowAdapter;
    }

    class TimerListener
    implements ActionListener {
        TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProgressDialog.this.progressBar.setValue(ProgressDialog.this.task.getProgress().getGlobalProgress());
            ProgressDialog.this.taskOutput.setText(ProgressDialog.this.task.getProgress().getMessage());
            if (ProgressDialog.this.task.isAutoCloseProgressAfterFinishSucessfully() && ProgressDialog.this.task.getProgress().done()) {
                ProgressDialog.this.timer.stop();
                ProgressDialog.this.isRunningTask = false;
                ProgressDialog.this.close();
            } else if (ProgressDialog.this.task.getProgress().done() || ProgressDialog.this.task.isFinishedCancel()) {
                ProgressDialog.this.cancelButton.setEnabled(false);
                ProgressDialog.this.timer.stop();
                ProgressDialog.this.isRunningTask = false;
                ProgressDialog.this.closeButton.setEnabled(true);
            }
        }
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("start")) {
                ProgressDialog.this.start();
            } else if (actionEvent.getActionCommand().equals("cancel")) {
                ProgressDialog.this.cancel();
            } else if (actionEvent.getActionCommand().equals("close")) {
                ProgressDialog.this.close();
            }
        }
    }
}

