/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.util;

import java.util.Enumeration;
import java.util.Stack;
import net.astah.golf.util.CancelException;

public class Progress {
    private int local = 0;
    private int global = 0;
    private boolean canceled = false;
    private Stack rangeStack = new Stack();
    private StringBuilder message = new StringBuilder();

    public void setLocalProgress(int n) throws CancelException {
        this.cancelCheck();
        this.local = n;
        this.setGlobalFromLocal();
    }

    protected void setGlobalFromLocal() {
        int n = this.local;
        Enumeration enumeration = this.rangeStack.elements();
        while (enumeration.hasMoreElements()) {
            LocalRange localRange = (LocalRange)enumeration.nextElement();
            n = localRange.project(n);
        }
        this.global = n;
    }

    public int getLocalProgress() {
        return this.local;
    }

    public int getGlobalProgress() {
        return this.global;
    }

    public void pushLocalRange(int n, int n2) throws CancelException {
        this.setLocalProgress(n);
        this.rangeStack.push(new LocalRange(n, n2));
    }

    public void popLocalRange() throws CancelException {
        this.cancelCheck();
        LocalRange localRange = (LocalRange)this.rangeStack.pop();
        this.setLocalProgress(localRange.getEnd());
    }

    public void setCanceled(boolean bl) {
        this.canceled = bl;
    }

    public boolean canceled() {
        return this.canceled;
    }

    public void cancelCheck() throws CancelException {
        if (this.canceled) {
            throw new CancelException();
        }
    }

    public boolean done() {
        return this.global >= 100;
    }

    public synchronized String getMessage() {
        return this.message.toString();
    }

    public synchronized void appendMessage(String string) {
        this.message.append(string);
    }

    class LocalRange {
        private int start;
        private int end;

        public LocalRange(int n, int n2) {
            this.start = n;
            this.end = n2;
        }

        public int project(int n) {
            return this.start + (this.end - this.start) * n / 100;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }
}

