/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.util;

public class Metrognome {
    String name;
    long startTime = 0L;
    int count;
    long min;
    long max;
    long latency;
    long total;

    public Metrognome(String string) {
        this.name = string;
        this.initialize();
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    public void stop() {
        this.latency = System.currentTimeMillis() - this.startTime;
        if (this.latency < this.min) {
            this.min = this.latency;
        }
        if (this.max < this.latency) {
            this.max = this.latency;
        }
        this.total += this.latency;
        ++this.count;
    }

    public String getSummary() {
        String string = Double.toString((double)this.getMean() / 1000.0);
        String string2 = this.name + ": count= " + this.count + " Latency(s) latency = " + this.latency + " min = " + (double)this.min / 1000.0 + " mean= " + string + " max= " + (double)this.max / 1000.0 + " total " + (double)this.total / 1000.0;
        return string2;
    }

    public String getName() {
        return this.name;
    }

    public int getCount() {
        return this.count;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public long getTotal() {
        return this.total;
    }

    public float getMean() {
        return (float)this.total / (float)this.count;
    }

    public void initialize() {
        this.count = 0;
        this.min = Long.MAX_VALUE;
        this.total = 0L;
        this.max = 0L;
    }

    public static void main(String[] stringArray) {
        Metrognome metrognome = new Metrognome("Test");
        for (int k = 0; k < 10; ++k) {
            metrognome.start();
            try {
                Thread.sleep((long)(Math.random() * 100.0));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            metrognome.stop();
        }
    }
}

