/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.util;

import java.util.Arrays;
import java.util.List;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookAndFeelFinder {
    private static final Logger logger = LoggerFactory.getLogger(LookAndFeelFinder.class);
    private static final String METAL_LOOK_AND_FEEL = "javax.swing.plaf.metal.MetalLookAndFeel";
    private static final String MOTIF_LOOK_AND_FEEL = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    private static final String WINDOWS_LOOK_AND_FEEL = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    private static final String WINDOWS_CLASSIC_LOOK_AND_FEEL = "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel";
    private static final String MAC_LOOK_AND_FEEL = "com.apple.laf.AquaLookAndFeel";
    private static final String GTK_LOOK_AND_FEEL = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
    private static final String NIMBUS_LOOK_AND_FEEL = "javax.swing.plaf.nimbus.NimbusLookAndFeel";
    private static final List<String> DEFAULT_FONT_SIZE_LOOK_AND_FEELS = Arrays.asList("javax.swing.plaf.nimbus.NimbusLookAndFeel");
    private static final List<String> AUTO_ADJUST_SCALE_LOOK_AND_FEELS = Arrays.asList("com.sun.java.swing.plaf.windows.WindowsLookAndFeel", "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel", "com.sun.java.swing.plaf.gtk.GTKLookAndFeel");

    public static boolean isDefaultFontSizeLookAndFeels() {
        return DEFAULT_FONT_SIZE_LOOK_AND_FEELS.contains(LookAndFeelFinder.getLookAndFeelClassName());
    }

    public static boolean isAutoAdjustScaleLookAndFeels() {
        return AUTO_ADJUST_SCALE_LOOK_AND_FEELS.contains(LookAndFeelFinder.getLookAndFeelClassName());
    }

    public static boolean isWindowsLookAndFeel() {
        return WINDOWS_LOOK_AND_FEEL.equals(LookAndFeelFinder.getLookAndFeelClassName());
    }

    public static boolean isWindowsClassicLookAndFeel() {
        return WINDOWS_CLASSIC_LOOK_AND_FEEL.equals(LookAndFeelFinder.getLookAndFeelClassName());
    }

    public static boolean isNimbusLookAndFeel() {
        return NIMBUS_LOOK_AND_FEEL.equals(LookAndFeelFinder.getLookAndFeelClassName());
    }

    public static boolean isMetalLookAndFeel() {
        return METAL_LOOK_AND_FEEL.equals(LookAndFeelFinder.getLookAndFeelClassName());
    }

    public static boolean isMotifLookAndFeel() {
        return MOTIF_LOOK_AND_FEEL.equals(LookAndFeelFinder.getLookAndFeelClassName());
    }

    public static boolean isMacLookAndFeel() {
        return MAC_LOOK_AND_FEEL.equals(LookAndFeelFinder.getLookAndFeelClassName());
    }

    public static boolean isGtkLookAndFeel() {
        return GTK_LOOK_AND_FEEL.equals(LookAndFeelFinder.getLookAndFeelClassName());
    }

    private static String getLookAndFeelClassName() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel == null) {
            logger.debug("lookAndFeel is null.");
            return "";
        }
        String string = lookAndFeel.getName();
        logger.debug("This look and feel name is {}.", (Object)string);
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
            String string2 = lookAndFeelInfo.getName();
            String string3 = lookAndFeelInfo.getClassName();
            logger.trace("{} : {}", (Object)string2, (Object)string3);
            if (string.equals(string2)) {
                return lookAndFeelInfo.getClassName();
            }
            if (string.equals("GTK look and feel") && string2.equals("GTK+")) {
                return string3;
            }
            if (!string.equals("Motif") && !string.equals("CDE") || !string2.equals("CDE/Motif")) continue;
            return string3;
        }
        logger.debug("LookAndFeelClassName is empty.");
        return "";
    }
}

