/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.util;

import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;
import net.astah.golf.util.Debug;
import net.astah.golf.util.ResourceBundleList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyUtil {
    private static final Logger logger = LoggerFactory.getLogger(KeyUtil.class);

    public static boolean isCursor(KeyEvent keyEvent) {
        return KeyUtil.isUpKey(keyEvent) || KeyUtil.isDownKey(keyEvent) || KeyUtil.isLeftKey(keyEvent) || KeyUtil.isRightKey(keyEvent);
    }

    public static boolean isUpKey(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 38 || keyEvent.getKeyChar() == '\u00e0';
    }

    public static boolean isDownKey(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 40 || keyEvent.getKeyChar() == '\u00e1';
    }

    public static boolean isLeftKey(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 37 || keyEvent.getKeyChar() == '\u00e2';
    }

    public static boolean isRightKey(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 39 || keyEvent.getKeyChar() == '\u00e3';
    }

    public static int getKeyCode(ResourceBundleList resourceBundleList, String string) {
        String string2 = resourceBundleList.getString(string);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(string2);
        if (keyStroke != null) {
            return keyStroke.getKeyCode();
        }
        String string3 = resourceBundleList.getString(string, false);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(string3);
        if (keyStroke2 == null) {
            Debug.impossible(string + " defined wrong key");
        }
        return keyStroke2.getKeyCode();
    }

    public static int getKeyModifiers(ResourceBundleList resourceBundleList, String string) {
        String string2 = resourceBundleList.getString(string);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(string2);
        if (keyStroke != null) {
            return keyStroke.getModifiers();
        }
        String string3 = resourceBundleList.getString(string, false);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(string3);
        if (keyStroke2 == null) {
            Debug.impossible(string + " defined wrong key");
        }
        return keyStroke2.getModifiers();
    }
}

