/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class InputStreamWithProgress
extends FilterInputStream {
    private final IProgressMonitor monitor;
    private boolean begun;
    private long worked;
    private long count;
    private long mark = -1L;

    public InputStreamWithProgress(InputStream inputStream, IProgressMonitor iProgressMonitor) {
        super(inputStream);
        this.monitor = iProgressMonitor != null ? iProgressMonitor : new NullProgressMonitor();
    }

    public InputStreamWithProgress(InputStream inputStream, IProgressMonitor iProgressMonitor, String string, long l) {
        this(inputStream, iProgressMonitor);
        this.begin(string, l);
    }

    public void begin(String string, long l) {
        Assert.isTrue((!this.begun ? 1 : 0) != 0, (String)"The monitor has already begun");
        this.monitor.beginTask(string, (int)Math.min(l, Integer.MAX_VALUE));
        this.begun = true;
    }

    public long getCount() {
        return this.count;
    }

    @Override
    public int read() throws IOException {
        this.checkCancel();
        int n = this.in.read();
        if (n >= 0) {
            ++this.count;
            this.worked();
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.checkCancel();
        int n3 = this.in.read(byArray, n, n2);
        if (n3 >= 0) {
            this.count += (long)n3;
            this.worked();
        }
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        this.checkCancel();
        long l2 = this.in.skip(l);
        this.count += l2;
        this.worked();
        return l2;
    }

    @Override
    public synchronized void mark(int n) {
        this.in.mark(n);
        this.mark = this.count;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.in.markSupported()) {
            throw new IOException("Mark not supported");
        }
        if (this.mark == -1L) {
            throw new IOException("Mark not set");
        }
        this.in.reset();
        this.count = this.mark;
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            if (this.begun) {
                this.monitor.done();
            }
        }
    }

    private void worked() {
        Assert.isTrue((boolean)this.begun, (String)"The monitor has not begun");
        if (this.count > this.worked) {
            int n = (int)(this.count - this.worked);
            this.monitor.worked(Math.max(n, 0));
            this.worked = this.count;
        }
    }

    private void checkCancel() throws InterruptedIOException {
        if (this.monitor.isCanceled()) {
            throw new InterruptedIOException("Canceled");
        }
    }
}

