/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.astah.golf.util.Debug;

public class ImageUtilities {
    private static final Map<String, Image> imageMap = new HashMap<String, Image>();

    private ImageUtilities() {
    }

    public static RenderedImage createRenderedImage(Image image, ImageObserver imageObserver, Color color) {
        if (color == null && image instanceof RenderedImage) {
            return (RenderedImage)((Object)image);
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(imageObserver), image.getHeight(imageObserver), color == null ? 2 : 1);
        Graphics graphics = bufferedImage.getGraphics();
        if (color == null) {
            graphics.drawImage(image, 0, 0, imageObserver);
        } else {
            graphics.drawImage(image, 0, 0, color, imageObserver);
        }
        return bufferedImage;
    }

    public static RenderedImage createRenderedImage(RenderedImage renderedImage, Color color) {
        if (color == null) {
            return renderedImage;
        }
        BufferedImage bufferedImage = new BufferedImage(renderedImage.getWidth(), renderedImage.getHeight(), 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setBackground(color);
        graphics2D.clearRect(0, 0, renderedImage.getWidth(), renderedImage.getHeight());
        graphics2D.drawRenderedImage(renderedImage, new AffineTransform());
        return bufferedImage;
    }

    public static byte[] getBytes(Image image, Color color, String string, int n, ImageObserver imageObserver) {
        return ImageUtilities.getBytes(ImageUtilities.createRenderedImage(image, imageObserver, color), color, string, n);
    }

    public static byte[] getBytes(RenderedImage renderedImage, Color color, String string, int n) {
        boolean bl;
        if (n < 1) {
            n = 1;
        }
        Raster raster = renderedImage.getData();
        int n2 = renderedImage.getWidth();
        int n3 = renderedImage.getHeight();
        boolean bl2 = bl = string.charAt(0) == '*';
        if (bl) {
            string = string.substring(1);
        }
        int n4 = string.length();
        int n5 = n2 * n3 * n4;
        int n6 = 0;
        byte[] byArray = new byte[n5 += n2 % n * n3];
        for (int k = 0; k < n3; ++k) {
            int n7;
            for (n7 = 0; n7 < n2; ++n7) {
                int[] nArray = raster.getPixel(n7, k, (int[])null);
                if (bl && nArray.length > 3) {
                    if (color == null) {
                        color = Color.BLACK;
                    }
                    double d2 = (double)nArray[3] / 255.0;
                    nArray[0] = (int)(d2 * (double)nArray[0] + (1.0 - d2) * (double)color.getRed());
                    nArray[1] = (int)(d2 * (double)nArray[1] + (1.0 - d2) * (double)color.getGreen());
                    nArray[2] = (int)(d2 * (double)nArray[2] + (1.0 - d2) * (double)color.getBlue());
                }
                for (int i2 = 0; i2 < string.length(); ++i2) {
                    switch (string.charAt(i2)) {
                        case 'A': 
                        case 'a': {
                            byArray[n6] = nArray.length > 3 ? (int)nArray[3] : -1;
                            break;
                        }
                        case 'R': 
                        case 'r': {
                            byArray[n6] = (byte)nArray[0];
                            break;
                        }
                        case 'G': 
                        case 'g': {
                            byArray[n6] = (byte)nArray[1];
                            break;
                        }
                        case 'B': 
                        case 'b': {
                            byArray[n6] = (byte)nArray[2];
                            break;
                        }
                        default: {
                            Debug.impossible(ImageUtilities.class.getClass() + ": Invalid code in '" + string + "'");
                        }
                    }
                    ++n6;
                }
            }
            for (n7 = 0; n7 < n2 % n; ++n7) {
                byArray[n6] = 0;
                ++n6;
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image hexToImage(String string) throws IllegalArgumentException {
        if (string == null || string.equals("")) {
            return null;
        }
        Image image = imageMap.get(string);
        if (image != null) {
            return image;
        }
        String[] stringArray = string.split(" ");
        byte[] byArray = new byte[stringArray.length];
        for (int k = 0; k < byArray.length; ++k) {
            String string2 = stringArray[k];
            if (string2.length() == 1) {
                byArray[k] = (byte)Character.digit(string2.charAt(0), 16);
                continue;
            }
            if (string2.length() == 2) {
                byArray[k] = (byte)((Character.digit(string2.charAt(0), 16) << 4) + Character.digit(string2.charAt(1), 16));
                continue;
            }
            throw new IllegalArgumentException("image data is error.");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            image = ImageIO.read(byteArrayInputStream);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                ((InputStream)byteArrayInputStream).close();
            }
            catch (IOException iOException) {}
        }
        imageMap.put(string, image);
        return image;
    }
}

