/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.util;

import java.awt.Image;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageSelection
implements ClipboardOwner,
Transferable {
    private static final Logger logger = LoggerFactory.getLogger(ImageSelection.class);
    private static final int IMAGE = 0;
    private static final int BMP = 1;
    private static final DataFlavor[] flavors = new DataFlavor[]{DataFlavor.imageFlavor, new DataFlavor("image/bmp", "Bitmap")};
    private Image image;

    public ImageSelection(Image image) {
        this.image = image;
    }

    @Override
    public synchronized DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])flavors.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        for (int k = 0; k < flavors.length; ++k) {
            if (!dataFlavor.equals(flavors[k])) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        if (dataFlavor.match(flavors[0])) {
            return this.image;
        }
        if (dataFlavor.match(flavors[1])) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)((Object)this.image), "bmp", byteArrayOutputStream);
                byteArrayOutputStream.close();
                return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            }
            catch (IOException iOException) {
                logger.error("error has occurred", (Throwable)iOException);
                throw new UnsupportedFlavorException(dataFlavor);
            }
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }
}

