/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.util;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.AttributedString;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import net.astah.golf.draw.RenderingHintsHelper;
import net.astah.golf.util.DefaultInstanceChecker;
import net.astah.golf.util.InstanceChecker;
import net.astah.golf.util.ScreenDeviceSupport;
import net.astah.golf.util.StringUtilities;
import net.astah.golf.widget.CColor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GolfUtilities {
    private static final Logger logger = LoggerFactory.getLogger(GolfUtilities.class);
    private static InstanceChecker instanceChecker = new DefaultInstanceChecker();
    private static final Component DEFAULT_COMPONENT = new Canvas();
    private static boolean xmiReading = false;

    public static String[] tokenize(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] tokenize(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static List<String> tokenizeList(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public static Set<String> tokenizeSet(String string, String string2) {
        HashSet<String> hashSet = new HashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(stringTokenizer.nextToken());
        }
        return hashSet;
    }

    public static <T> EList<T> clone(EList<T> eList) {
        return new BasicEList(eList);
    }

    public static <T> List<T> clone(List<T> list) {
        if (list instanceof ArrayList) {
            return new ArrayList<T>(list);
        }
        if (list instanceof Vector) {
            return new Vector<T>(list);
        }
        if (list instanceof LinkedList) {
            return new LinkedList<T>(list);
        }
        return new ArrayList<T>(list);
    }

    public static <T> Set<T> clone(Set<T> set) {
        if (set instanceof HashSet) {
            return new HashSet<T>(set);
        }
        if (set instanceof TreeSet) {
            return new TreeSet<T>(set);
        }
        return new HashSet<T>(set);
    }

    public static <K, V> Map<K, V> clone(Map<K, V> map) {
        if (map instanceof HashMap) {
            return new HashMap<K, V>(map);
        }
        if (map instanceof Hashtable) {
            return new Hashtable<K, V>(map);
        }
        return new HashMap<K, V>(map);
    }

    public static String decode(String string) {
        if (string == null) {
            return null;
        }
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.getMessage() != null && illegalArgumentException.getMessage().equals("URLDecoder: Incomplete trailing escape (%) pattern")) {
                return string;
            }
            return null;
        }
    }

    public static String encode(String string) {
        if (string == null) {
            return null;
        }
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static void setInstanceChecker(InstanceChecker instanceChecker) {
        GolfUtilities.instanceChecker = instanceChecker;
    }

    public static boolean isInstanceOf(Object object, Class<?> clazz) {
        return instanceChecker.isInstanceOf(object, clazz);
    }

    public static Class<?> getClass(Object object) {
        return instanceChecker.getClass(object);
    }

    public static Color createColor(String string) {
        String[] stringArray;
        if (string != null && (stringArray = string.split(",")) != null && stringArray.length == 3) {
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            int n3 = Integer.parseInt(stringArray[2]);
            return new Color(n, n2, n3);
        }
        return null;
    }

    public static String getColorString(Color color) {
        return GolfUtilities.getColorString(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static String getColorString(CColor cColor) {
        return GolfUtilities.getColorString(cColor.getRed(), cColor.getGreen(), cColor.getBlue());
    }

    private static String getColorString(int n, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n);
        stringBuilder.append(",");
        stringBuilder.append(n2);
        stringBuilder.append(",");
        stringBuilder.append(n3);
        return stringBuilder.toString();
    }

    public static String convertColorToHex(Color color) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("#");
        stringBuilder.append(GolfUtilities.convertIntToHex(color.getRed()));
        stringBuilder.append(GolfUtilities.convertIntToHex(color.getGreen()));
        stringBuilder.append(GolfUtilities.convertIntToHex(color.getBlue()));
        return stringBuilder.toString();
    }

    public static String convertIntToHex(int n) {
        int n2 = 16;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 1;
        while (true) {
            int n4 = n % n2;
            stringBuilder.insert(0, GolfUtilities.getHexChar(n4));
            n -= n4;
            if ((n /= n2 * n3) == 0) break;
            ++n3;
        }
        String string = stringBuilder.toString();
        if (string.length() == 1) {
            return "0" + string;
        }
        return string;
    }

    private static char getHexChar(int n) {
        char c2 = '0';
        if (n >= 0 && n <= 9) {
            c2 = (char)(n + 48);
        } else if (n <= 15) {
            c2 = (char)(n + 65 - 10);
        }
        return c2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String string, String string2) {
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            inputStream = Object.class.getResourceAsStream(string);
            if (inputStream != null) {
                int n;
                fileOutputStream = new FileOutputStream(string2);
                byte[] byArray = new byte[1024];
                while ((n = inputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
            }
        }
        catch (IOException iOException) {
            logger.error("error has occurred", (Throwable)iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    logger.error("error has occurred", (Throwable)iOException);
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    logger.error("error has occurred", (Throwable)iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileNormaly(String string, String string2) {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            if (fileInputStream != null) {
                int n;
                fileOutputStream = new FileOutputStream(string2);
                byte[] byArray = new byte[1024];
                while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
            }
        }
        catch (IOException iOException) {
            logger.error("error has occurred", (Throwable)iOException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {
                    logger.error("error has occurred", (Throwable)iOException);
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    logger.error("error has occurred", (Throwable)iOException);
                }
            }
        }
    }

    public static boolean isXMIReading() {
        return xmiReading;
    }

    public static void setXMIReading(boolean bl) {
        xmiReading = bl;
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean bl = GolfUtilities.hasAlpha(image);
        BufferedImage bufferedImage = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int n = 1;
            if (bl) {
                n = 2;
            }
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            bufferedImage = graphicsConfiguration.createCompatibleImage(image.getWidth(null), image.getHeight(null), n);
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        if (bufferedImage == null) {
            int n = 1;
            if (bl) {
                n = 2;
            }
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), n);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            return bufferedImage.getColorModel().hasAlpha();
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel colorModel = pixelGrabber.getColorModel();
        return colorModel.hasAlpha();
    }

    public static void writeImage(Image image, String string, String string2) {
        File file = new File(string);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        BufferedImage bufferedImage = GolfUtilities.toBufferedImage(image);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ImageIO.write((RenderedImage)bufferedImage, string2, fileOutputStream);
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.error("error has occurred", (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            logger.error("error has occurred", (Throwable)iOException);
        }
        catch (Error error) {
            logger.error("error has occurred", (Throwable)error);
        }
    }

    public static double computeStringWidth(Graphics graphics, Font font, String string) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.getRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHintsHelper.isTextAntiAliasing ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setTransform(new AffineTransform());
        graphics.setFont(font);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
        return Math.max(rectangle2D.getWidth(), GolfUtilities.computeStringWidth(font, string));
    }

    public static double computeStringWidth(Font font, String string) {
        return SwingUtilities.computeStringWidth(GolfUtilities.defaultFontMetrics(font), string);
    }

    public static double computeStringHeight(Graphics graphics, Font font, String string) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setTransform(new AffineTransform());
        graphics.setFont(font);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHintsHelper.isTextAntiAliasing ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
        return rectangle2D.getHeight();
    }

    public static double computeStringHeight(Font font, String string) {
        FontMetrics fontMetrics = GolfUtilities.defaultFontMetrics(font);
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, DEFAULT_COMPONENT.getGraphics());
        return rectangle2D.getHeight();
    }

    public static FontMetrics defaultFontMetrics(Font font) {
        FontMetrics fontMetrics = DEFAULT_COMPONENT.getFontMetrics(font);
        return fontMetrics;
    }

    private static boolean getOSMatches(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        String string2 = System.getProperty("os.name");
        return (string2 = string2.toLowerCase()).startsWith(string.toLowerCase());
    }

    public static boolean isWindowsOS() {
        return GolfUtilities.getOSMatches("Windows");
    }

    public static boolean isMacOS() {
        return GolfUtilities.getOSMatches("Mac");
    }

    public static boolean isLinuxOS() {
        return GolfUtilities.getOSMatches("Linux");
    }

    public static void deleteDirForced(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int k = 0; k < fileArray.length; ++k) {
                GolfUtilities.deleteDirForced(fileArray[k]);
            }
        }
        file.delete();
    }

    public static void copyDirectory(File file, File file2) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            if (!file2.exists()) {
                file2.mkdir();
            }
            String[] stringArray = file.list();
            for (int k = 0; k < stringArray.length; ++k) {
                GolfUtilities.copyDirectory(new File(file, stringArray[k]), new File(file2, stringArray[k]));
            }
        } else {
            int n;
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            ((InputStream)fileInputStream).close();
            ((OutputStream)fileOutputStream).close();
        }
    }

    public static boolean isMacRetina() {
        if (!GolfUtilities.isMacOS()) {
            return false;
        }
        return ScreenDeviceSupport.isMacRetina();
    }

    public static String normalizeToNFC(String string) {
        if (!Normalizer.isNormalized(string, Normalizer.Form.NFC)) {
            string = Normalizer.normalize(string, Normalizer.Form.NFC);
        }
        return string;
    }

    public static double computeMultiLineStringHeight(Font font, String string, double d2, double d3) {
        double d4 = GolfUtilities.computeStringHeight(font, "m");
        if (d2 <= 0.0) {
            return d4;
        }
        String[] stringArray = StringUtilities.splitMultiLineString(string);
        FontRenderContext fontRenderContext = new FontRenderContext(null, RenderingHintsHelper.isTextAntiAliasing, true);
        Map map = GolfUtilities.getAttributeMap(font);
        double d5 = 0.0;
        for (int k = 0; k < stringArray.length; ++k) {
            String string2 = stringArray[k];
            if (string2.length() == 0) {
                d5 += d4;
                continue;
            }
            AttributedString attributedString = new AttributedString(string2, map);
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), fontRenderContext);
            while (lineBreakMeasurer.getPosition() < string2.length()) {
                TextLayout textLayout = lineBreakMeasurer.nextLayout((float)d2);
                d5 += (double)textLayout.getAscent();
                d5 += (double)(textLayout.getDescent() + textLayout.getLeading());
            }
        }
        return d5;
    }

    public static Map getAttributeMap(Font font) {
        Map<Object, Object> map = font == null ? new HashMap() : font.getAttributes();
        return map;
    }

    public static BufferedImage toBufferedImage(ImageIcon imageIcon) {
        BufferedImage bufferedImage = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setBackground(Color.WHITE);
        graphics2D.clearRect(0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight());
        imageIcon.paintIcon(null, graphics2D, 0, 0);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static byte[] encodeImage(BufferedImage bufferedImage) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)bufferedImage, "jpg", byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    public static BufferedImage decodeImage(byte[] byArray) throws IOException {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
            BufferedImage bufferedImage = ImageIO.read(byteArrayInputStream);
            return bufferedImage;
        }
    }
}

