/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.util;

import net.astah.golf.geom2D.Line2d;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.util.Debug;

public class Geometry {
    public static final int SOURCE = 0;
    public static final int TARGET = 1;
    public static final double epsFactor = 14.0;
    private static final int RECT_WIDTH = 10;
    private static final double IS_STRAIGHT_VALUE = 0.2;

    public static Pnt2d getIntersectPnt(Rectangle2d rectangle2d, Pnt2d pnt2d) {
        return Geometry.getIntersectPnt(rectangle2d, rectangle2d.getCenterX(), rectangle2d.getCenterY(), pnt2d);
    }

    public static Pnt2d getIntersectPnt(Rectangle2d rectangle2d, Pnt2d[] pnt2dArray) {
        Pnt2d pnt2d = null;
        for (int k = 0; k < pnt2dArray.length - 1; ++k) {
            if (!rectangle2d.intersectsLine(pnt2dArray[k].x, pnt2dArray[k].y, pnt2dArray[k + 1].x, pnt2dArray[k + 1].y)) continue;
            pnt2d = Geometry.getIntersectPnt(rectangle2d, pnt2dArray[k], pnt2dArray[k + 1]);
            break;
        }
        return pnt2d;
    }

    public static Pnt2d getIntersectPnt(Rectangle2d rectangle2d, Pnt2d[] pnt2dArray, boolean bl) {
        Pnt2d pnt2d = null;
        if (bl) {
            pnt2d = Geometry.getIntersectPnt(rectangle2d, pnt2dArray);
        } else {
            for (int k = pnt2dArray.length - 1; k > 0; --k) {
                if (!rectangle2d.intersectsLine(pnt2dArray[k].x, pnt2dArray[k].y, pnt2dArray[k - 1].x, pnt2dArray[k - 1].y)) continue;
                pnt2d = Geometry.getIntersectPnt(rectangle2d, pnt2dArray[k], pnt2dArray[k - 1]);
                break;
            }
        }
        return pnt2d;
    }

    public static Pnt2d[] getOuterPnts(Rectangle2d rectangle2d, Rectangle2d rectangle2d2, Pnt2d[] pnt2dArray) {
        Pnt2d[] pnt2dArray2 = null;
        if (rectangle2d != null && rectangle2d2 != null && pnt2dArray != null) {
            Pnt2d pnt2d = Geometry.getIntersectPnt1(rectangle2d, pnt2dArray);
            int n = Geometry.getIndex1(rectangle2d, pnt2dArray);
            if (pnt2d == null) {
                pnt2d = pnt2dArray[0];
                n = 1;
            }
            Pnt2d pnt2d2 = Geometry.getIntersectPnt2(rectangle2d2, pnt2dArray);
            int n2 = Geometry.getIndex2(rectangle2d2, pnt2dArray);
            if (pnt2d2 == null) {
                pnt2d2 = pnt2dArray[pnt2dArray.length - 1];
                n2 = pnt2dArray.length - 1 - 1;
            }
            if (pnt2d != null && pnt2d2 != null && n2 - n + 1 >= 0) {
                pnt2dArray2 = new Pnt2d[1 + (n2 - n + 1) + 1];
                pnt2dArray2[0] = pnt2d;
                pnt2dArray2[pnt2dArray2.length - 1] = pnt2d2;
                int n3 = n;
                int n4 = 1;
                while (n3 < n2 + 1) {
                    pnt2dArray2[n4] = pnt2dArray[n3];
                    ++n3;
                    ++n4;
                }
            }
        }
        return pnt2dArray2;
    }

    private static int getIndex2(Rectangle2d rectangle2d, Pnt2d[] pnt2dArray) {
        for (int k = pnt2dArray.length - 1; k > 0; --k) {
            if (!rectangle2d.contains(pnt2dArray[k]) || rectangle2d.contains(pnt2dArray[k - 1])) continue;
            return k - 1;
        }
        return 0;
    }

    private static Pnt2d getIntersectPnt2(Rectangle2d rectangle2d, Pnt2d[] pnt2dArray) {
        for (int k = pnt2dArray.length - 1; k > 0; --k) {
            if (!rectangle2d.contains(pnt2dArray[k]) || rectangle2d.contains(pnt2dArray[k - 1])) continue;
            return Geometry.getIntersectPnt(rectangle2d, pnt2dArray[k], pnt2dArray[k - 1]);
        }
        return null;
    }

    private static Pnt2d getIntersectPnt1(Rectangle2d rectangle2d, Pnt2d[] pnt2dArray) {
        for (int k = 0; k < pnt2dArray.length - 1; ++k) {
            if (!rectangle2d.contains(pnt2dArray[k]) || rectangle2d.contains(pnt2dArray[k + 1])) continue;
            return Geometry.getIntersectPnt(rectangle2d, pnt2dArray[k], pnt2dArray[k + 1]);
        }
        return null;
    }

    private static int getIndex1(Rectangle2d rectangle2d, Pnt2d[] pnt2dArray) {
        for (int k = 0; k < pnt2dArray.length - 1; ++k) {
            if (!rectangle2d.contains(pnt2dArray[k]) || rectangle2d.contains(pnt2dArray[k + 1])) continue;
            return k + 1;
        }
        return 0;
    }

    private static Pnt2d getIntersectPnt(Rectangle2d rectangle2d, Pnt2d pnt2d, Pnt2d pnt2d2) {
        return Geometry.getIntersectPnt(rectangle2d, pnt2d.x, pnt2d.y, pnt2d2);
    }

    private static Pnt2d getIntersectPnt(Rectangle2d rectangle2d, double d2, double d3, Pnt2d pnt2d) {
        Pnt2d pnt2d2 = null;
        double d4 = rectangle2d.x;
        double d5 = rectangle2d.y;
        double d6 = rectangle2d.width;
        double d7 = rectangle2d.height;
        if (d4 - d2 == 0.0 || d5 - d3 == 0.0) {
            return new Pnt2d(d2, d3);
        }
        double d8 = Math.atan2(d5 - d3, d4 - d2);
        double d9 = Math.atan2(d5 - d3, d4 + d6 - d2);
        double d10 = Math.atan2(d5 + d7 - d3, d4 + d6 - d2);
        double d11 = Math.atan2(d5 + d7 - d3, d4 - d2);
        double d12 = pnt2d.y - d3;
        double d13 = pnt2d.x - d2;
        double d14 = Math.atan2(d12, d13);
        if (-Math.PI <= d14 && d14 < d8 || d11 <= d14 && d14 <= Math.PI) {
            double d15 = d2 - d4;
            double d16 = 0.0;
            d16 = d13 == 0.0 ? d5 : d12 * d15 / d13;
            pnt2d2 = new Pnt2d(d4, d3 - d16);
        } else if (d8 <= d14 && d14 < d9) {
            double d17 = d3 - d5;
            double d18 = d13 * d17 / d12;
            pnt2d2 = new Pnt2d(d2 - d18, d5);
        } else if (d9 <= d14 && d14 < d10) {
            double d19 = d4 + d6 - d2;
            double d20 = d12 * d19 / d13;
            pnt2d2 = new Pnt2d(d4 + d6, d3 + d20);
        } else if (d10 <= d14 && d14 < d11) {
            double d21 = d5 + d7 - d3;
            double d22 = d13 * d21 / d12;
            pnt2d2 = new Pnt2d(d2 + d22, d5 + d7);
        } else {
            Debug.impossible();
        }
        return pnt2d2;
    }

    public static boolean isOnBoundary(Pnt2d pnt2d, Rectangle2d rectangle2d) {
        return (pnt2d.x == rectangle2d.x || pnt2d.x == rectangle2d.getMaxX()) && pnt2d.y >= rectangle2d.y && pnt2d.y <= rectangle2d.getMaxY() || (pnt2d.y == rectangle2d.y || pnt2d.y == rectangle2d.getMaxY()) && pnt2d.x >= rectangle2d.x && pnt2d.x <= rectangle2d.getMaxX();
    }

    public static int getClickedKnobIndex(Pnt2d pnt2d, Pnt2d[] pnt2dArray, double d2) {
        int n = -1;
        double d3 = d2 * d2 + 1.0;
        if (pnt2dArray != null) {
            double d4 = d3;
            for (int k = 0; k < pnt2dArray.length; ++k) {
                double d5 = pnt2dArray[k].distanceSq(pnt2d);
                if (!(d5 < d3) || !(d5 < d4)) continue;
                d4 = d5;
                n = k;
            }
        }
        return n;
    }

    public static int getClickedKnobIndex(Pnt2d pnt2d, Pnt2d[] pnt2dArray) {
        return Geometry.getClickedKnobIndex(pnt2d, pnt2dArray, 14.0);
    }

    public static int getClickedLineIndex(Pnt2d pnt2d, Pnt2d[] pnt2dArray) {
        Rectangle2d rectangle2d = new Rectangle2d(pnt2d.x - 5.0, pnt2d.y - 5.0, 10.0, 10.0);
        for (int k = 0; k < pnt2dArray.length - 1; ++k) {
            Line2d line2d = new Line2d(pnt2dArray[k], pnt2dArray[k + 1]);
            if (!line2d.intersects(rectangle2d)) continue;
            return k;
        }
        return -1;
    }

    public static boolean isStraightLine(Pnt2d[] pnt2dArray) {
        if (pnt2dArray.length == 3) {
            double d2 = pnt2dArray[0].x - pnt2dArray[1].x;
            double d3 = pnt2dArray[0].y - pnt2dArray[1].y;
            double d4 = pnt2dArray[1].x - pnt2dArray[2].x;
            double d5 = pnt2dArray[1].y - pnt2dArray[2].y;
            double d6 = Math.atan2(d3, d2);
            double d7 = Math.atan2(d5, d4);
            if (!(d6 <= 0.0 && d7 > 0.0 || d6 > 0.0 && d7 <= 0.0 || !(Math.abs(Math.abs(d6) - Math.abs(d7)) < 0.2))) {
                return true;
            }
        }
        return false;
    }

    public static int getIconLineIndex(Pnt2d pnt2d, Pnt2d[] pnt2dArray) {
        for (int k = 0; k < pnt2dArray.length - 1; ++k) {
            Line2d line2d = new Line2d(pnt2dArray[k], pnt2dArray[k + 1]);
            if (!line2d.intersectsLine(pnt2d.getX(), pnt2d.getY(), pnt2d.getX(), pnt2d.getY())) continue;
            return k;
        }
        return -1;
    }

    public static int getClickedCurveLineIndex(Pnt2d pnt2d, Pnt2d[] pnt2dArray) {
        int n = 0;
        double d2 = new Line2d(pnt2dArray[0], pnt2dArray[1]).ptLineDist(pnt2d);
        for (int k = 1; k < pnt2dArray.length - 1; ++k) {
            Line2d line2d = new Line2d(pnt2dArray[k], pnt2dArray[k + 1]);
            if (!(line2d.ptLineDist(pnt2d) < d2)) continue;
            n = k;
        }
        return n;
    }

    public static Rectangle2d getIntersectRect(Rectangle2d rectangle2d, Rectangle2d rectangle2d2) {
        double d2;
        double d3;
        double d4;
        Rectangle2d rectangle2d3 = new Rectangle2d();
        double d5 = Math.max(rectangle2d.getMinX(), rectangle2d2.getMinX());
        if (d5 <= (d4 = Math.min(rectangle2d.getMaxX(), rectangle2d2.getMaxX()))) {
            if (rectangle2d.getMinY() >= rectangle2d2.getMaxY()) {
                rectangle2d3 = new Rectangle2d(d5, rectangle2d2.getMaxY(), d4 - d5, rectangle2d.getMinY() - rectangle2d2.getMaxY());
            } else if (rectangle2d.getMaxY() <= rectangle2d2.getMinY()) {
                rectangle2d3 = new Rectangle2d(d5, rectangle2d.getMaxY(), d4 - d5, rectangle2d2.getMinY() - rectangle2d.getMaxY());
            }
        }
        if ((d3 = Math.max(rectangle2d.getMinY(), rectangle2d2.getMinY())) <= (d2 = Math.min(rectangle2d.getMaxY(), rectangle2d2.getMaxY()))) {
            if (rectangle2d.getMinX() >= rectangle2d2.getMaxX()) {
                rectangle2d3 = new Rectangle2d(rectangle2d2.getMaxX(), d3, rectangle2d.getMinX() - rectangle2d2.getMaxX(), d2 - d3);
            } else if (rectangle2d.getMaxX() <= rectangle2d2.getMinX()) {
                rectangle2d3 = new Rectangle2d(rectangle2d.getMaxX(), d3, rectangle2d2.getMinX() - rectangle2d.getMaxX(), d2 - d3);
            }
        }
        return rectangle2d3;
    }

    public static boolean isOnBorder(Rectangle2d rectangle2d, Pnt2d pnt2d) {
        if ((rectangle2d.getMinX() == pnt2d.x || rectangle2d.getMaxX() == pnt2d.x) && rectangle2d.getMinY() <= pnt2d.y && rectangle2d.getMaxY() >= pnt2d.y) {
            return true;
        }
        return (rectangle2d.getMinY() == pnt2d.y || rectangle2d.getMaxY() == pnt2d.y) && rectangle2d.getMinX() <= pnt2d.x && rectangle2d.getMaxX() >= pnt2d.x;
    }

    public static int inqSourceOrTarget(Pnt2d pnt2d, Pnt2d pnt2d2, Pnt2d pnt2d3) {
        double d2 = pnt2d.distanceSq(pnt2d2);
        double d3 = pnt2d.distanceSq(pnt2d3);
        int n = -1;
        n = d2 < d3 ? 0 : 1;
        return n;
    }

    public static int getNearestPointOnLine(Pnt2d[] pnt2dArray, Pnt2d pnt2d, Pnt2d pnt2d2) {
        double d2 = Double.MAX_VALUE;
        int n = 0;
        for (int k = 0; k < pnt2dArray.length - 1; ++k) {
            double d3 = Geometry.getDistance(pnt2d, pnt2dArray[k], pnt2dArray[k + 1]);
            if (!(d3 < d2)) continue;
            d2 = d3;
            n = k;
        }
        Pnt2d pnt2d3 = pnt2dArray[n];
        Pnt2d pnt2d4 = pnt2dArray[n + 1];
        double d4 = pnt2d.distance(pnt2d3);
        double d5 = d2;
        double d6 = d4 * Math.cos(Math.asin(d5 / d4));
        double d7 = pnt2d3.distance(pnt2d4);
        double d8 = d6 / d7;
        Pnt2d pnt2d5 = new Pnt2d();
        if (d6 < d7) {
            pnt2d5.interpolate(pnt2d3, pnt2d4, d8);
            pnt2d2.setLocation(pnt2d5);
        } else {
            pnt2d2.setLocation(pnt2d4);
        }
        return n;
    }

    private static double getDistance(Pnt2d pnt2d, Pnt2d pnt2d2, Pnt2d pnt2d3) {
        Line2d line2d = new Line2d(pnt2d2, pnt2d3);
        return line2d.ptSegDist(pnt2d);
    }
}

