/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.util;

import java.io.PrintWriter;
import javax.swing.JOptionPane;
import net.astah.golf.util.AssertionFailError;

public class Debug {
    private static PrintWriter writer = new PrintWriter(System.err);
    public static boolean debug = false;
    public static boolean taskOver = false;

    public static void setPrintWriter(PrintWriter printWriter) {
        if (printWriter != null) {
            writer = printWriter;
        }
    }

    public static void printMessage(String string) {
        writer.println(string);
        writer.flush();
    }

    public static void trace(String string) {
        if (debug) {
            Debug.printMessage(string);
        }
    }

    public static void abort() throws AssertionFailError {
        if (debug) {
            throw new AssertionFailError();
        }
        String string = "Exception occurred. This is a tool's bug. \nWe hope you report this bug. \nThank you.";
        JOptionPane.showMessageDialog(null, string, "Alert", 0);
        AssertionFailError assertionFailError = new AssertionFailError();
        writer.println("----------------------------------------------------------");
        writer.println("                      Error Trace                          ");
        writer.println("----------------------------------------------------------");
        assertionFailError.printStackTrace(writer);
        writer.flush();
        writer.close();
    }

    public static void abort(String string) throws AssertionFailError {
        if (debug) {
            throw new AssertionFailError(string);
        }
        String string2 = "Exception occurred. This is a tool's bug. \nWe hope you report this bug. \nThank you.";
        JOptionPane.showMessageDialog(null, string2, "Alert", 0);
        AssertionFailError assertionFailError = new AssertionFailError();
        writer.println("----------------------------------------------------------");
        writer.println("                      Error Trace                          ");
        writer.println("----------------------------------------------------------");
        assertionFailError.printStackTrace(writer);
        writer.flush();
        writer.close();
    }

    public static void methodNotYet() {
        if (debug) {
            Debug.printMessage("Method not yet implemented: ");
        }
    }

    public static void methodNotYet(String string) {
        if (debug) {
            Debug.printMessage("Method not yet implemented: " + string);
        }
    }

    public static void classNotYet() {
        if (debug) {
            Debug.printMessage("Class not yet implemented: ");
        }
    }

    public static void classNotYet(String string) {
        if (debug) {
            Debug.printMessage("Class not yet implemented: " + string);
        }
    }

    public static void notYet() {
        if (debug) {
            Debug.printMessage("Code not yet implemented: ");
        }
    }

    public static void notYet(String string) {
        Debug.printMessage("Code not yet implemented: ");
    }

    public static void impossible() throws AssertionFailError {
        Debug.abort("impossible action. maybe a bug.");
    }

    public static void impossible(String string) throws AssertionFailError {
        Debug.abort("impossible action. " + string);
    }

    public static void assertTrue(boolean bl) throws AssertionFailError {
        if (!bl) {
            Debug.abort();
        }
    }

    public static void assertTrue(boolean bl, String string) throws AssertionFailError {
        if (!bl) {
            Debug.abort(string);
        }
    }

    public static void waitForTaskOver(int n) {
        long l = System.currentTimeMillis();
        for (int k = 0; k < n && !taskOver; ++k) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        long l2 = System.currentTimeMillis();
        System.out.println("wait for task over costs " + (l2 - l) / 1000L + "seconds");
    }
}

