/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.model;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.List;
import net.astah.golf.model.IExObserver;
import net.astah.golf.model.ObservableAdapter;
import net.astah.golf.model.ObservablesAdapterFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;

public class Observables {
    private static final ObservablesAdapterFactory factory = new ObservablesAdapterFactory();
    public static final Predicate<Object> MODEL_PREDICATE = object -> object instanceof IExObserver && object instanceof EObject;
    public static final Predicate<Object> VIEW_PREDICATE = object -> object instanceof IExObserver && !(object instanceof EObject);

    public static void addObserver(Notifier notifier, IExObserver iExObserver) {
        ObservableAdapter observableAdapter = Observables.getObservable(notifier);
        List<IExObserver> list = observableAdapter.getObservers();
        if (!list.contains(iExObserver)) {
            observableAdapter.addObserver(iExObserver);
        }
    }

    public static void deleteObserver(Notifier notifier, IExObserver iExObserver) {
        ObservableAdapter observableAdapter = Observables.getObservable(notifier);
        if (observableAdapter == null) {
            throw new IllegalArgumentException("Specified Observer is illegal");
        }
        observableAdapter.deleteObserver(iExObserver);
    }

    @Deprecated
    public static void notifyObservers(Notifier notifier) {
        ObservableAdapter observableAdapter = Observables.getObservable(notifier);
        observableAdapter.notifyObservers();
    }

    private static ObservableAdapter getObservable(Notifier notifier) {
        Assert.isNotNull((Object)notifier, (String)"eObject");
        for (Adapter adapter : notifier.eAdapters()) {
            if (!(adapter instanceof ObservableAdapter)) continue;
            return (ObservableAdapter)adapter;
        }
        return (ObservableAdapter)factory.adapt(notifier, ObservableAdapter.class);
    }

    public static void notifyObservers(Notifier notifier, Object object) {
        ObservableAdapter observableAdapter = Observables.getObservable(notifier);
        observableAdapter.notifyObservers(object);
    }

    public static List<IExObserver> getObservers(Notifier notifier) {
        ObservableAdapter observableAdapter = Observables.getObservable(notifier);
        return observableAdapter.getObservers();
    }

    public static Iterable<IExObserver> getViewObservers(Notifier notifier) {
        return Iterables.filter(Observables.getObservers(notifier), VIEW_PREDICATE);
    }

    public static Iterable<IExObserver> getModelObservers(Notifier notifier) {
        return Iterables.filter(Observables.getObservers(notifier), MODEL_PREDICATE);
    }
}

