/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.model;

import java.util.Collection;
import java.util.EventObject;
import net.astah.golf.draw.GNode;
import net.astah.golf.model.IEntityEditUnit;
import net.astah.golf.model.IEntityStore;

public class EntityStoreEvent
extends EventObject {
    private static final long serialVersionUID = -8494178262687878072L;
    public static final int CHANGE = 0;
    public static final int CLEARALL = 1;
    public static final int RELOAD = 2;
    protected int editType = 0;
    protected String[] typeStr = new String[]{"CHANGE", "CLEARALL", "RELOAD"};
    protected IEntityEditUnit[] edit;
    private boolean isEntityEditDoubtful = false;
    private boolean isEntityChangeDoubtful = false;
    private final Collection<GNode> dirtyViewElements;

    public EntityStoreEvent(IEntityStore iEntityStore, IEntityEditUnit[] iEntityEditUnitArray, Collection<GNode> collection) {
        super(iEntityStore);
        this.edit = iEntityEditUnitArray;
        this.dirtyViewElements = collection;
    }

    public EntityStoreEvent(IEntityStore iEntityStore, int n) {
        super(iEntityStore);
        this.editType = n;
        this.edit = null;
        this.dirtyViewElements = null;
    }

    public EntityStoreEvent(IEntityStore iEntityStore, IEntityEditUnit[] iEntityEditUnitArray) {
        this(iEntityStore, iEntityEditUnitArray, null);
    }

    public int getEditType() {
        return this.editType;
    }

    public IEntityEditUnit[] getEntityEditUnit() {
        return this.edit;
    }

    @Override
    public String toString() {
        String string = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("* ");
        stringBuilder.append(this.typeStr[this.editType]);
        stringBuilder.append(" *" + string);
        if (this.edit != null) {
            for (int k = 0; k < this.edit.length; ++k) {
                stringBuilder.append(this.edit[k].toString() + string);
            }
        }
        return stringBuilder.toString();
    }

    public void setEntityEditDoubtful(boolean bl) {
        this.isEntityEditDoubtful = bl;
    }

    public boolean isEntityEditDoubtful() {
        return this.isEntityEditDoubtful;
    }

    public void setEntityChangeDoubtful(boolean bl) {
        this.isEntityChangeDoubtful = bl;
    }

    public boolean isEntityChangeDoubtful() {
        return this.isEntityChangeDoubtful;
    }

    public Collection<GNode> getDirtyViewElements() {
        return this.dirtyViewElements;
    }
}

