/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.model;

import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.astah.golf.model.IEntityContainer;
import org.eclipse.emf.ecore.EObject;

public class EntityClipboard
extends Clipboard
implements ClipboardOwner,
IEntityContainer {
    protected Clipboard systemClipboard;
    protected List<EObject> entities = new ArrayList<EObject>();
    private boolean isNeedFireChange = true;
    private PropertyChangeSupport changeSupport;

    public EntityClipboard() {
        super("Golf clipboard");
        try {
            this.systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
    }

    @Override
    public void empty() {
        this.setContents(null, null);
        this.entities.clear();
    }

    public void clear() {
        this.empty();
    }

    @Override
    public boolean isEmpty() {
        return this.entities.isEmpty();
    }

    @Override
    public void addEntity(EObject eObject) {
        boolean bl;
        boolean bl2 = !this.isEmpty();
        this.entities.add(eObject);
        boolean bl3 = bl = !this.isEmpty();
        if (bl2 == bl) {
            return;
        }
        if (this.isNeedFireChange) {
            this.firePropertyChange("isEntity", bl2, bl);
        }
    }

    public void setSystemClipboard(Transferable transferable) {
        this.systemClipboard.setContents(transferable, this);
    }

    public Transferable getSystemClipboradContent(Object object) {
        return this.systemClipboard.getContents(object);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        this.clear();
    }

    @Override
    public void removeEntity(EObject eObject) {
        boolean bl;
        boolean bl2 = !this.isEmpty();
        this.entities.remove(eObject);
        boolean bl3 = bl = !this.isEmpty();
        if (bl2 == bl) {
            return;
        }
        this.firePropertyChange("isEntity", bl2, bl);
    }

    @Override
    public boolean contains(EObject eObject) {
        return this.entities.contains(eObject);
    }

    @Override
    public Iterator<EObject> entityIterator() {
        return this.entities.iterator();
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, object, object2);
        }
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
        if (this.changeSupport != null && bl != bl2) {
            this.changeSupport.firePropertyChange(string, (Object)bl, (Object)bl2);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[EntityClipboard: size=");
        stringBuilder.append(this.entities.size());
        stringBuilder.append(",entities=\n");
        for (int k = 0; k < this.entities.size(); ++k) {
            stringBuilder.append("> ");
            stringBuilder.append(this.entities.get(k).toString());
            if (k + 1 == this.entities.size()) continue;
            stringBuilder.append("\n,");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public PropertyChangeSupport getChangeSupport() {
        return this.changeSupport;
    }

    public void setChangeSupport(PropertyChangeSupport propertyChangeSupport) {
        this.changeSupport = propertyChangeSupport;
    }

    public void setNeedFireChange(boolean bl) {
        this.isNeedFireChange = bl;
    }
}

