/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.emf;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class EMFOutputStream
extends ByteArrayOutputStream {
    public synchronized void writeByte(int n) {
        this.write(n);
    }

    public void writeByte(boolean bl) {
        this.writeByte(bl ? 1 : 0);
    }

    public synchronized void writeByte(byte[] byArray) throws IOException {
        this.write(byArray);
    }

    public synchronized void writeWord(int n) {
        this.write(n & 0xFF);
        this.write(n >>> 8 & 0xFF);
    }

    public synchronized void writeInt(int n) {
        this.write(n & 0xFF);
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 16 & 0xFF);
        this.write(n >>> 24 & 0xFF);
    }

    public synchronized void writeFloat(float f2) {
        this.writeInt(Math.round(f2));
    }

    public synchronized void writeLong(long l) {
        this.write((int)(l & 0xFFL));
        this.write((int)(l >>> 8 & 0xFFL));
        this.write((int)(l >>> 16 & 0xFFL));
        this.write((int)(l >>> 24 & 0xFFL));
        this.write((int)(l >>> 32 & 0xFFL));
        this.write((int)(l >>> 40 & 0xFFL));
        this.write((int)(l >>> 48 & 0xFFL));
        this.write((int)(l >>> 56 & 0xFFL));
    }

    public void writePoint(Point point) {
        this.writeInt(point.x);
        this.writeInt(point.y);
    }

    public void writeRect(Rectangle rectangle) {
        this.writeInt(rectangle.x);
        this.writeInt(rectangle.y);
        this.writeInt(rectangle.x + rectangle.width);
        this.writeInt(rectangle.y + rectangle.height);
    }

    public synchronized void writeString(String string) throws UnsupportedEncodingException, IOException {
        this.writeByte(string.getBytes("UTF-16LE"));
    }

    public void writeCOLORREF(Color color) {
        this.writeByte(color.getRed());
        this.writeByte(color.getGreen());
        this.writeByte(color.getBlue());
        this.writeByte(0);
    }

    public synchronized void writeTransform(AffineTransform affineTransform) {
        this.writeFloat((float)affineTransform.getScaleX());
        this.writeFloat((float)affineTransform.getShearY());
        this.writeFloat((float)affineTransform.getShearX());
        this.writeFloat((float)affineTransform.getScaleY());
        this.writeFloat((float)affineTransform.getTranslateX());
        this.writeFloat((float)affineTransform.getTranslateY());
    }

    public synchronized void writeModifyTransform(AffineTransform affineTransform) {
        this.writeInt(Float.floatToIntBits((float)affineTransform.getScaleX()));
        this.writeInt(Float.floatToIntBits((float)affineTransform.getShearY()));
        this.writeInt(Float.floatToIntBits((float)affineTransform.getShearX()));
        this.writeInt(Float.floatToIntBits((float)affineTransform.getScaleY()));
        this.writeInt(Float.floatToIntBits((float)affineTransform.getTranslateX()));
        this.writeInt(Float.floatToIntBits((float)affineTransform.getTranslateY()));
    }

    public void writeString(String string, int n) throws UnsupportedEncodingException, IOException {
        this.writeString(string);
        for (int k = n - string.length(); k > 0; --k) {
            this.writeWord(0);
        }
    }
}

