/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.emf;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMFImageSelection
implements ClipboardOwner,
Transferable {
    protected static final DataFlavor emfFlavor;
    protected DataFlavor[] flavors = new DataFlavor[]{emfFlavor};
    protected InputStream emfStream;
    private static final Logger logger;

    public EMFImageSelection(InputStream inputStream) {
        this.emfStream = inputStream;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(emfFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(emfFlavor)) {
            return this.emfStream;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        logger.debug("Lost ownership");
    }

    static {
        logger = LoggerFactory.getLogger(EMFImageSelection.class);
        emfFlavor = new DataFlavor("image/emf", "Enhanced MetaFile");
        SystemFlavorMap systemFlavorMap = (SystemFlavorMap)SystemFlavorMap.getDefaultFlavorMap();
        systemFlavorMap.addUnencodedNativeForFlavor(emfFlavor, "ENHMETAFILE");
    }
}

