/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.emf;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import net.astah.golf.emf.EMFOutputStream;

public class EMFHeader {
    public static final int HEADER_TYPE = 1;
    public static final int SIGNATURE_ID = 1179469088;
    public static final int VERSION = 256;
    public static final int REVERVED = 0;
    private int headerSize = 88;
    private Rectangle bounds;
    private Rectangle frame;
    private int fileSize = 0;
    private int numOfRecords = 2;
    private int numOfHandles = 1;
    private int sizeOfDescrip = 0;
    private int offsOfDescrip = 0;
    private int numPalEntries = 0;
    private int widthDevPixels;
    private int heightDevPixels;
    private int widthDevMM;
    private int heightDevMM;
    private static final int DEF_SCREEN_SIZE_WIDTH = 1280;
    private static final int DEF_SCREEN_SIZE_HEIGHT = 800;
    private static final int DEF_RESOLUTION = 96;
    private static final Dimension screenMM = new Dimension(320, 240);

    public EMFHeader(Rectangle rectangle, int n, int n2, int n3) {
        int n4;
        Dimension dimension;
        if (GraphicsEnvironment.isHeadless()) {
            dimension = new Dimension(1280, 800);
            n4 = 96;
        } else {
            dimension = Toolkit.getDefaultToolkit().getScreenSize();
            n4 = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        this.widthDevMM = (int)Math.round(dimension.getWidth() / (double)n4 * 25.3995);
        this.heightDevMM = (int)Math.round(dimension.getHeight() / (double)n4 * 25.3995);
        double d2 = (double)this.widthDevMM / (double)dimension.width * 100.0;
        this.bounds = rectangle;
        this.frame = new Rectangle((int)Math.round((double)(rectangle.x + rectangle.width) * d2), (int)Math.round((double)(rectangle.y + rectangle.height) * d2), (int)Math.round((double)rectangle.width * d2), (int)Math.round((double)rectangle.height * d2));
        this.numOfRecords = n;
        this.fileSize = n2 + this.headerSize;
        this.numOfHandles = n3 + 1;
        this.widthDevPixels = (int)Math.round(dimension.getWidth());
        this.heightDevPixels = (int)Math.round(dimension.getHeight());
    }

    public void write(EMFOutputStream eMFOutputStream) {
        eMFOutputStream.writeInt(1);
        eMFOutputStream.writeInt(this.headerSize);
        eMFOutputStream.writeInt(this.bounds.x);
        eMFOutputStream.writeInt(this.bounds.y);
        eMFOutputStream.writeInt(this.bounds.x + this.bounds.width);
        eMFOutputStream.writeInt(this.bounds.y + this.bounds.height);
        eMFOutputStream.writeInt(this.frame.x);
        eMFOutputStream.writeInt(this.frame.y);
        eMFOutputStream.writeInt(this.frame.x + this.frame.width);
        eMFOutputStream.writeInt(this.frame.y + this.frame.height);
        eMFOutputStream.writeInt(1179469088);
        eMFOutputStream.writeInt(256);
        eMFOutputStream.writeInt(this.fileSize);
        eMFOutputStream.writeInt(this.numOfRecords);
        eMFOutputStream.writeWord(this.numOfHandles);
        eMFOutputStream.writeWord(0);
        eMFOutputStream.writeInt(this.sizeOfDescrip);
        eMFOutputStream.writeInt(this.offsOfDescrip);
        eMFOutputStream.writeInt(this.numPalEntries);
        eMFOutputStream.writeInt(this.widthDevPixels);
        eMFOutputStream.writeInt(this.heightDevPixels);
        eMFOutputStream.writeInt(this.widthDevMM);
        eMFOutputStream.writeInt(this.heightDevMM);
    }
}

