/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.emf;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMFHandleTable {
    private List handleTable = new ArrayList();
    private int maxHandleNum = 0;
    private static final Logger logger = LoggerFactory.getLogger(EMFHandleTable.class);

    public int getHandle(int n) {
        if (this.handleTable.size() > n - 1 && ((Boolean)this.handleTable.get(n - 1)).booleanValue()) {
            logger.debug("getHandle: handle = {}", (Object)n);
            return n;
        }
        logger.debug("getHandle: handle = -1");
        return -1;
    }

    public int addHandle() {
        for (int k = 0; k < this.handleTable.size(); ++k) {
            if (((Boolean)this.handleTable.get(k)).booleanValue()) continue;
            this.handleTable.set(k, Boolean.TRUE);
            logger.debug("addHandle: handle = " + (k + 1));
            return k + 1;
        }
        this.handleTable.add(Boolean.TRUE);
        ++this.maxHandleNum;
        logger.debug("addHandle: handle = " + this.handleTable.size());
        logger.debug("addHandle: maxHandleNum = " + this.maxHandleNum);
        return this.handleTable.size();
    }

    public void removeHandle(int n) {
        logger.debug("removeHandle: handle = " + n);
        if (this.getHandle(n) != -1) {
            this.handleTable.set(n - 1, Boolean.FALSE);
        }
    }

    public void removeHandles() {
        logger.debug("removeHandles");
        for (int k = 0; k < this.handleTable.size(); ++k) {
            if (this.getHandle(k + 1) == -1) continue;
            this.handleTable.set(k, Boolean.FALSE);
        }
    }

    public int getHandleSize() {
        logger.debug("getHandleSize() = {}", (Object)this.handleTable.size());
        return this.handleTable.size();
    }

    public int getNumOfHandleUsed() {
        logger.debug("getNumOfHandleUsed() = {}", (Object)this.maxHandleNum);
        return this.maxHandleNum;
    }
}

