/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.emf;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.AttributedCharacterIterator;
import net.astah.golf.draw.MultilineTextDrawable;
import net.astah.golf.draw.VectorGraphics2D;
import net.astah.golf.draw.VerticalTextDrawable;
import net.astah.golf.emf.EMF;
import net.astah.golf.emf.EMFConverter;
import net.astah.golf.emf.EMFFontHelper;
import net.astah.golf.emf.EMFOutputStream;
import net.astah.golf.geom2D.Pnt2d;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMFGraphics2D
extends VectorGraphics2D
implements MultilineTextDrawable,
VerticalTextDrawable {
    private EMF emf;
    private Rectangle bounds;
    private EMFConverter emfConverter;
    private int penStyle;
    private int penWidth;
    private int brushStyle;
    private int brushHatch;
    private int fontEscapement;
    private float[] dashArray = null;
    private boolean underlineOn;
    private double translateX;
    private double translateY;
    private int penHandle = -1;
    private int brushHandle = -1;
    private int fontHandle = -1;
    private boolean isShadow = false;
    private boolean isSpecial;
    private Pnt2d anglePoint;
    private String fontValue = "";
    private static final Logger logger = LoggerFactory.getLogger(EMFGraphics2D.class);

    public EMFGraphics2D(Rectangle rectangle, String string) {
        this.bounds = new Rectangle(rectangle);
        this.initEMF();
        this.emfConverter = new EMFConverter(this.emf);
        this.fontValue = string;
    }

    private void initEMF() {
        this.emf = new EMF(this.bounds);
        this.emf.setMapMode(1);
        this.emf.setWindowOrgEx(0, 0);
        this.emf.setWindowExtEx(this.bounds.width, this.bounds.height);
        this.emf.setBkMode(1);
        this.emf.setViewportOrgEx(0, 0);
        this.emf.setViewportExtEx(this.bounds.width, this.bounds.height);
        this.emf.setTextAlign(24);
        this.initGDI();
    }

    private void initGDI() {
        this.penStyle = 0;
        this.brushHatch = 2;
        this.brushStyle = 1;
        this.fontEscapement = 0;
        this.transform = new AffineTransform();
    }

    @Override
    public void draw(Shape shape) {
        if (this.getStroke() instanceof BasicStroke) {
            this.penStyle = 65536;
            BasicStroke basicStroke = (BasicStroke)this.getStroke();
            switch (basicStroke.getEndCap()) {
                case 0: {
                    this.penStyle |= 0x200;
                    break;
                }
                case 1: {
                    this.penStyle |= 0;
                    break;
                }
                case 2: {
                    this.penStyle |= 0x100;
                }
            }
            switch (basicStroke.getLineJoin()) {
                case 0: {
                    this.penStyle |= 0x2000;
                    break;
                }
                case 1: {
                    this.penStyle |= 0;
                    break;
                }
                case 2: {
                    this.penStyle |= 0x1000;
                }
            }
            this.penWidth = EMF.doubleToInt(((BasicStroke)this.getStroke()).getLineWidth());
            this.dashArray = ((BasicStroke)this.getStroke()).getDashArray();
            this.penStyle = this.dashArray == null ? (this.penStyle |= 0) : (this.penStyle |= 1);
            this.resetPenHandle();
            this.emf.setMiterLimit(basicStroke.getMiterLimit());
            if (this.isShadow) {
                this.emf.modifyWorldTransform(this.translateX, this.translateY);
            }
            boolean bl = this.penStyle != 5;
            boolean bl2 = this.brushStyle != 1;
            this.emfConverter.toEMF(shape, bl, bl2);
            if (this.isShadow) {
                this.emf.modifyWorldTransform(-this.translateX, -this.translateY);
            }
            this.brushStyle = 1;
            this.resetBrushHandle();
        }
    }

    @Override
    public void fill(Shape shape) {
        this.brushStyle = 0;
        this.resetBrushHandle();
    }

    @Override
    public void drawString(String string, float f2, float f3) {
        if (this.anglePoint != null) {
            this.emf.modifyWorldTransform(-1.5707963267948966, this.anglePoint.x, this.anglePoint.y);
        }
        this.drawString(string, Math.round(f2), Math.round(f3));
        if (this.anglePoint != null) {
            this.emf.modifyWorldTransform(1.5707963267948966, this.anglePoint.x, this.anglePoint.y);
        }
    }

    @Override
    public void drawString(String string, int n, int n2) {
        Font font = this.getFont();
        this.setTextColor(this.color);
        this.underlineOn = false;
        double d2 = 0.0;
        EMFFontHelper eMFFontHelper = new EMFFontHelper(this.getFont().getName(), this.getFont().getStyle(), this.getFont().getSize(), this.fontValue);
        for (EMFFontHelper.StringWithFontInfo stringWithFontInfo : eMFFontHelper.parseString(string)) {
            n = (int)((double)n + d2);
            this.setFont(stringWithFontInfo.getFont());
            this.resetBrushHandle();
            this.resetPenHandle();
            this.resetFontHandle();
            d2 = stringWithFontInfo.getFont().getStringBounds(stringWithFontInfo.getString(), new FontRenderContext(new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f), true, true)).getWidth();
            try {
                this.emf.textOut(EMF.doubleToInt((double)n + this.translateX), EMF.doubleToInt((double)n2 + this.translateY), stringWithFontInfo.getString(), stringWithFontInfo.getFont());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                logger.error("error has occurred.", (Throwable)unsupportedEncodingException);
            }
            catch (IOException iOException) {
                logger.error("error has occurred.", (Throwable)iOException);
            }
        }
        this.setFont(font);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f2, float f3) {
        if (this.anglePoint != null) {
            this.emf.modifyWorldTransform(-1.5707963267948966, this.anglePoint.x, this.anglePoint.y);
        }
        this.drawString(attributedCharacterIterator, Math.round(f2), Math.round(f3));
        if (this.anglePoint != null) {
            this.emf.modifyWorldTransform(1.5707963267948966, this.anglePoint.x, this.anglePoint.y);
        }
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.setTextColor(this.color);
        this.underlineOn = (Integer)attributedCharacterIterator.getAttribute(TextAttribute.UNDERLINE) != 0;
        this.resetFontHandle();
        StringBuilder stringBuilder = new StringBuilder();
        double d2 = 0.0;
        char c2 = attributedCharacterIterator.first();
        while (c2 != '\uffff') {
            stringBuilder.append(c2);
            c2 = attributedCharacterIterator.next();
        }
        String string = new String(stringBuilder);
        EMFFontHelper eMFFontHelper = new EMFFontHelper(this.getFont().getName(), this.getFont().getStyle(), this.getFont().getSize(), this.fontValue);
        for (EMFFontHelper.StringWithFontInfo stringWithFontInfo : eMFFontHelper.parseString(string)) {
            n = (int)((double)n + d2);
            this.setFont(stringWithFontInfo.getFont());
            this.resetBrushHandle();
            this.resetPenHandle();
            this.resetFontHandle();
            d2 = stringWithFontInfo.getFont().getStringBounds(stringWithFontInfo.getString(), new FontRenderContext(new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f), true, true)).getWidth();
            try {
                this.emf.textOut(EMF.doubleToInt((double)n + this.translateX), EMF.doubleToInt((double)n2 + this.translateY), stringWithFontInfo.getString(), stringWithFontInfo.getFont());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                logger.error("error has occurred.", (Throwable)unsupportedEncodingException);
            }
            catch (IOException iOException) {
                logger.error("error has occurred.", (Throwable)iOException);
            }
        }
    }

    public void setTextColor(Color color) {
        this.emf.setTextColor(color);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        this.resetBrushHandle();
        this.emf.drawImage(image, n, n2, n3, n4, Color.WHITE);
        return true;
    }

    @Override
    public void translate(double d2, double d3) {
        this.translateX = d2;
        this.translateY = d3;
        this.transform.translate(d2, d3);
    }

    public void translatePositon(double d2, double d3) {
        this.emf.modifyWorldTransform(d2, d3);
    }

    @Override
    public void setTransform(AffineTransform affineTransform) {
        this.transform = affineTransform;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return new FontRenderContext(this.transform, true, true);
    }

    protected void resetBrushHandle() {
        int n = this.getColor().getAlpha() != 0 ? this.brushStyle : 1;
        this.brushHandle = this.emf.createBrushIndirect(n, this.getColor(), this.brushHatch);
        this.emf.selectObject(this.brushHandle);
    }

    protected void resetPenHandle() {
        int n = this.color.getAlpha() != 0 ? this.penStyle : this.penStyle & 0xFFFFFFF0 | 5;
        this.penHandle = this.emf.extCreatePen(0, 0, 0, 0, n, this.penWidth, 0, this.color, 0, 0, null);
        this.emf.selectObject(this.penHandle);
    }

    protected void resetFontHandle() {
        try {
            this.fontHandle = this.emf.createFontIndirect(this.getFont(), this.fontEscapement, this.underlineOn, false);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error("error has occurred.", (Throwable)unsupportedEncodingException);
        }
        catch (IOException iOException) {
            logger.error("error has occurred.", (Throwable)iOException);
        }
        this.emf.selectObject(this.fontHandle);
    }

    public EMFOutputStream getEMFOutputStream() {
        EMFOutputStream eMFOutputStream = this.emf.getEMFOutputStream();
        return eMFOutputStream;
    }

    public void setSepcialCase(boolean bl) {
        this.isSpecial = bl;
    }

    public boolean isSpecialCase() {
        return this.isSpecial;
    }

    @Override
    public void setAnglePoint(Pnt2d pnt2d) {
        this.anglePoint = pnt2d;
    }

    @Override
    public Pnt2d getAnglePoint() {
        return this.anglePoint;
    }

    public void setShadow(boolean bl) {
        this.isShadow = bl;
    }
}

